/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.Constants;
import cc.arduino.contributions.DownloadableContributionsDownloader;
import cc.arduino.contributions.GPGDetachedSignatureVerifier;
import cc.arduino.contributions.GZippedJsonDownloader;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndex;
import cc.arduino.utils.ArchiveExtractor;
import cc.arduino.utils.MultiStepProgress;
import cc.arduino.utils.network.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.helpers.FileUtils;

public class LibraryInstaller {
    private static Logger log = LogManager.getLogger(LibraryInstaller.class);
    private final Platform platform;
    private final GPGDetachedSignatureVerifier signatureVerifier;

    public LibraryInstaller(Platform platform, GPGDetachedSignatureVerifier signatureVerifier) {
        this.platform = platform;
        this.signatureVerifier = signatureVerifier;
    }

    public synchronized void updateIndex(ProgressListener progressListener) throws Exception {
        MultiStepProgress progress = new MultiStepProgress(3);
        DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.librariesIndexer.getStagingFolder());
        File outputFile = BaseNoGui.librariesIndexer.getIndexFile();
        String signatureFileName = FilenameUtils.getName((String)new URL(Constants.LIBRARY_INDEX_URL).getPath());
        File libraryIndexTemp = File.createTempFile(signatureFileName, ".tmp");
        URL libraryURL = new URL(Constants.LIBRARY_INDEX_URL);
        URL libraryGzURL = new URL(Constants.LIBRARY_INDEX_URL_GZ);
        String statusText = I18n.tr("Downloading libraries index...");
        try {
            GZippedJsonDownloader gZippedJsonDownloader = new GZippedJsonDownloader(downloader, libraryURL, libraryGzURL);
            gZippedJsonDownloader.download(libraryIndexTemp, progress, statusText, progressListener, true);
        }
        catch (InterruptedException e) {
            return;
        }
        progress.stepDone();
        URL signatureUrl = new URL(String.valueOf(libraryURL.toString()) + ".sig");
        if (downloader.verifyDomain(signatureUrl)) {
            if (downloader.checkSignature(progress, signatureUrl, progressListener, this.signatureVerifier, statusText, libraryIndexTemp)) {
                if (libraryIndexTemp.length() > 0L) {
                    Files.move(libraryIndexTemp.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                FileDownloader.invalidateFiles(libraryGzURL, libraryURL, signatureUrl);
                log.error("Fail to verify the signature of {} the cached files have been removed", (Object)libraryURL);
            }
        } else {
            log.info("The domain is not selected to verify the signature. library index: {}", (Object)signatureUrl);
        }
        BaseNoGui.librariesIndexer.parseIndex();
        this.rescanLibraryIndex(progress, progressListener);
    }

    public void install(ContributedLibrary lib, ProgressListener progressListener) throws Exception {
        ArrayList<ContributedLibrary> libs = new ArrayList<ContributedLibrary>();
        libs.add(lib);
        this.install(libs, progressListener);
    }

    public synchronized void install(List<ContributedLibrary> libs, ProgressListener progressListener) throws Exception {
        MultiStepProgress progress = new MultiStepProgress(3 * libs.size() + 1);
        for (ContributedLibrary lib : libs) {
            this.performInstall(lib, progressListener, progress);
        }
        this.rescanLibraryIndex(progress, progressListener);
    }

    private void performInstall(ContributedLibrary lib, ProgressListener progressListener, MultiStepProgress progress) throws Exception {
        File tmpFolder;
        Optional<ContributedLibrary> replacedLib;
        File destFolder;
        block7: {
            if (lib.isLibraryInstalled()) {
                System.out.println(I18n.format(I18n.tr("Library is already installed: {0}:{1}"), lib.getName(), lib.getParsedVersion()));
                return;
            }
            File libsFolder = BaseNoGui.getSketchbookLibrariesFolder().folder;
            destFolder = new File(libsFolder, lib.getName().replaceAll(" ", "_"));
            LibrariesIndex index = BaseNoGui.librariesIndexer.getIndex();
            replacedLib = index.find(lib.getName()).stream().filter(l -> l.getInstalledLibrary().isPresent()).filter(l -> l.getInstalledLibrary().get().getInstalledFolder().equals(destFolder)).findAny();
            if (!replacedLib.isPresent() && destFolder.exists()) {
                System.out.println(I18n.format(I18n.tr("Library {0} is already installed in: {1}"), lib.getName(), destFolder));
                return;
            }
            DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.librariesIndexer.getStagingFolder());
            try {
                downloader.download(lib, progress, I18n.format(I18n.tr("Downloading library: {0}"), lib.getName()), progressListener, false);
            }
            catch (InterruptedException e) {
                return;
            }
            progress.stepDone();
            progress.setStatus(I18n.format(I18n.tr("Installing library: {0}:{1}"), lib.getName(), lib.getParsedVersion()));
            progressListener.onProgress(progress);
            tmpFolder = FileUtils.createTempFolder(libsFolder);
            try {
                new ArchiveExtractor(this.platform).extract(lib.getDownloadedFile(), tmpFolder, 1);
            }
            catch (Exception e) {
                if (!tmpFolder.exists()) break block7;
                FileUtils.recursiveDelete(tmpFolder);
            }
        }
        progress.stepDone();
        if (replacedLib.isPresent()) {
            this.remove(replacedLib.get(), progressListener);
        }
        tmpFolder.renameTo(destFolder);
        progress.stepDone();
    }

    public synchronized void remove(ContributedLibrary lib, ProgressListener progressListener) throws IOException {
        if (lib.isIDEBuiltIn()) {
            return;
        }
        MultiStepProgress progress = new MultiStepProgress(2);
        progress.setStatus(I18n.format(I18n.tr("Removing library: {0}:{1}"), lib.getName(), lib.getParsedVersion()));
        progressListener.onProgress(progress);
        FileUtils.recursiveDelete(lib.getInstalledLibrary().get().getInstalledFolder());
        progress.stepDone();
        this.rescanLibraryIndex(progress, progressListener);
    }

    private void rescanLibraryIndex(MultiStepProgress progress, ProgressListener progressListener) {
        progress.setStatus(I18n.tr("Updating list of installed libraries"));
        progressListener.onProgress(progress);
        BaseNoGui.librariesIndexer.rescanLibraries();
        progress.stepDone();
    }
}

