/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.Constants;
import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionsDownloader;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.SignatureVerifier;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributedToolReference;
import cc.arduino.contributions.packages.PackageIndexFilenameFilter;
import cc.arduino.filters.FileExecutablePredicate;
import cc.arduino.utils.ArchiveExtractor;
import cc.arduino.utils.MultiStepProgress;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;
import processing.app.helpers.filefilters.OnlyDirs;

public class ContributionInstaller {
    private static Logger log = LogManager.getLogger(ContributionInstaller.class);
    private final Platform platform;
    private final SignatureVerifier signatureVerifier;

    public ContributionInstaller(Platform platform, SignatureVerifier signatureVerifier) {
        this.platform = platform;
        this.signatureVerifier = signatureVerifier;
    }

    public synchronized List<String> install(ContributedPlatform contributedPlatform, ProgressListener progressListener) throws Exception {
        LinkedList<String> errors = new LinkedList<String>();
        if (contributedPlatform.isInstalled()) {
            throw new Exception("Platform is already installed!");
        }
        ArrayList<ContributedTool> tools = new ArrayList<ContributedTool>();
        for (ContributedTool tool : contributedPlatform.getResolvedTools()) {
            DownloadableContribution downloadable = tool.getDownloadableContribution(this.platform);
            if (downloadable == null) {
                throw new Exception(I18n.format(I18n.tr("Tool {0} is not available for your operating system."), tool.getName()));
            }
            if (tool.isInstalled() && !tool.isBuiltIn()) continue;
            tools.add(tool);
        }
        DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.indexer.getStagingFolder());
        MultiStepProgress progress = new MultiStepProgress((tools.size() + 1) * 2);
        try {
            downloader.download(contributedPlatform, progress, I18n.tr("Downloading boards definitions."), progressListener, false);
            progress.stepDone();
            int i = 1;
            for (ContributedTool tool : tools) {
                String msg = I18n.format(I18n.tr("Downloading tools ({0}/{1})."), i, tools.size());
                ++i;
                downloader.download(tool.getDownloadableContribution(this.platform), progress, msg, progressListener, false);
                progress.stepDone();
            }
        }
        catch (InterruptedException e) {
            return errors;
        }
        ContributedPackage pack = contributedPlatform.getParentPackage();
        File packageFolder = new File(BaseNoGui.indexer.getPackagesFolder(), pack.getName());
        List resolvedToolReferences = contributedPlatform.getResolvedToolReferences().entrySet().stream().filter(entry -> !((ContributedTool)entry.getValue()).isInstalled() || ((ContributedTool)entry.getValue()).isBuiltIn()).collect(Collectors.toList());
        int i = 1;
        for (Map.Entry entry2 : resolvedToolReferences) {
            progress.setStatus(I18n.format(I18n.tr("Installing tools ({0}/{1})..."), i, resolvedToolReferences.size()));
            progressListener.onProgress(progress);
            ++i;
            ContributedTool tool = (ContributedTool)entry2.getValue();
            Path destFolder = Paths.get(BaseNoGui.indexer.getPackagesFolder().getAbsolutePath(), ((ContributedToolReference)entry2.getKey()).getPackager(), "tools", tool.getName(), tool.getVersion());
            Files.createDirectories(destFolder, new FileAttribute[0]);
            DownloadableContribution toolContrib = tool.getDownloadableContribution(this.platform);
            assert (toolContrib.getDownloadedFile() != null);
            new ArchiveExtractor(this.platform).extract(toolContrib.getDownloadedFile(), destFolder.toFile(), 1);
            try {
                this.findAndExecutePostInstallScriptIfAny(destFolder.toFile(), contributedPlatform.getParentPackage().isTrusted(), PreferencesData.areInsecurePackagesAllowed());
            }
            catch (IOException e) {
                errors.add(I18n.tr("Error running post install script"));
            }
            tool.setInstalled(true);
            tool.setInstalledFolder(destFolder.toFile());
            progress.stepDone();
        }
        progress.setStatus(I18n.tr("Installing boards..."));
        progressListener.onProgress(progress);
        File platformFolder = new File(packageFolder, "hardware" + File.separator + contributedPlatform.getArchitecture());
        File destFolder = new File(platformFolder, contributedPlatform.getParsedVersion());
        Files.createDirectories(destFolder.toPath(), new FileAttribute[0]);
        new ArchiveExtractor(this.platform).extract(contributedPlatform.getDownloadedFile(), destFolder, 1);
        contributedPlatform.setInstalled(true);
        contributedPlatform.setInstalledFolder(destFolder);
        try {
            this.findAndExecutePostInstallScriptIfAny(destFolder, contributedPlatform.getParentPackage().isTrusted(), PreferencesData.areInsecurePackagesAllowed());
        }
        catch (IOException e) {
            e.printStackTrace();
            errors.add(I18n.tr("Error running post install script"));
        }
        progress.stepDone();
        progress.setStatus(I18n.tr("Installation completed!"));
        progressListener.onProgress(progress);
        return errors;
    }

    private void findAndExecutePostInstallScriptIfAny(File folder, boolean trusted, boolean trustAll) throws IOException {
        Collection scripts = this.platform.postInstallScripts(folder).stream().filter(new FileExecutablePredicate()).collect(Collectors.toList());
        if (scripts.isEmpty()) {
            String[] subfolders = folder.list(new OnlyDirs());
            if (subfolders.length != 1) {
                return;
            }
            this.findAndExecutePostInstallScriptIfAny(new File(folder, subfolders[0]), trusted, trustAll);
            return;
        }
        this.executeScripts(folder, scripts, trusted, trustAll);
    }

    private void findAndExecutePreUninstallScriptIfAny(File folder, boolean trusted, boolean trustAll) throws IOException {
        Collection scripts = this.platform.preUninstallScripts(folder).stream().filter(new FileExecutablePredicate()).collect(Collectors.toList());
        if (scripts.isEmpty()) {
            String[] subfolders = folder.list(new OnlyDirs());
            if (subfolders.length != 1) {
                return;
            }
            this.findAndExecutePreUninstallScriptIfAny(new File(folder, subfolders[0]), trusted, trustAll);
            return;
        }
        this.executeScripts(folder, scripts, trusted, trustAll);
    }

    private void executeScripts(File folder, Collection<File> postInstallScripts, boolean trusted, boolean trustAll) throws IOException {
        File script = postInstallScripts.iterator().next();
        if (!trusted && !trustAll) {
            System.err.println(I18n.format(I18n.tr("Warning: non trusted contribution, skipping script execution ({0})"), script));
            return;
        }
        if (trustAll) {
            System.err.println(I18n.format(I18n.tr("Warning: forced untrusted script execution ({0})"), script));
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdout, (OutputStream)stderr));
        executor.setWorkingDirectory(folder);
        executor.setExitValues(null);
        int exitValue = executor.execute(new CommandLine(script));
        executor.setExitValues(new int[0]);
        System.out.write(stdout.toByteArray());
        System.err.write(stderr.toByteArray());
        if (executor.isFailure(exitValue)) {
            throw new IOException();
        }
    }

    public synchronized List<String> remove(ContributedPlatform contributedPlatform) {
        if (contributedPlatform == null || contributedPlatform.isBuiltIn()) {
            return new LinkedList<String>();
        }
        LinkedList<String> errors = new LinkedList<String>();
        try {
            this.findAndExecutePreUninstallScriptIfAny(contributedPlatform.getInstalledFolder(), contributedPlatform.getParentPackage().isTrusted(), PreferencesData.areInsecurePackagesAllowed());
        }
        catch (IOException e) {
            errors.add(I18n.tr("Error running post install script"));
        }
        for (ContributedTool tool : contributedPlatform.getResolvedTools()) {
            if (BaseNoGui.indexer.isContributedToolUsed(contributedPlatform, tool) || tool.isBuiltIn()) continue;
            File destFolder = tool.getInstalledFolder();
            FileUtils.recursiveDelete(destFolder);
            tool.setInstalled(false);
            tool.setInstalledFolder(null);
            try {
                Files.delete(destFolder.getParentFile().toPath());
            }
            catch (Exception e) {
                log.info("The directory is not empty there is another version installed. directory {}", (Object)destFolder.getParentFile().toPath(), (Object)e);
            }
        }
        FileUtils.recursiveDelete(contributedPlatform.getInstalledFolder());
        contributedPlatform.setInstalled(false);
        contributedPlatform.setInstalledFolder(null);
        return errors;
    }

    public synchronized List<String> updateIndex(ProgressListener progressListener) {
        MultiStepProgress progress = new MultiStepProgress(1);
        DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.indexer.getStagingFolder());
        HashSet<String> packageIndexURLs = new HashSet<String>(PreferencesData.getCollection("boardsmanager.additional.urls"));
        packageIndexURLs.add(Constants.PACKAGE_INDEX_URL);
        LinkedList<String> downloadedPackageIndexFilesAccumulator = new LinkedList<String>();
        for (String packageIndexURLString : packageIndexURLs) {
            try {
                URL packageIndexURL = new URL(packageIndexURLString);
                String indexFileName = FilenameUtils.getName((String)packageIndexURL.getPath());
                downloadedPackageIndexFilesAccumulator.add(BaseNoGui.indexer.getIndexFile(indexFileName).getName());
                log.info("Start download and signature check of={}", packageIndexURLs);
                downloader.downloadIndexAndSignature(progress, packageIndexURL, progressListener, this.signatureVerifier);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                System.err.println(e.getMessage());
            }
        }
        progress.stepDone();
        log.info("Downloaded package index URL={}", packageIndexURLs);
        return downloadedPackageIndexFilesAccumulator;
    }

    public synchronized void deleteUnknownFiles(List<String> downloadedPackageIndexFiles) throws IOException {
        File preferencesFolder = BaseNoGui.indexer.getIndexFile(".").getParentFile();
        File[] additionalPackageIndexFiles = preferencesFolder.listFiles(new PackageIndexFilenameFilter("package_index.json"));
        if (additionalPackageIndexFiles == null) {
            return;
        }
        log.info("Check unknown files. Additional package index folder files={}, Additional package index url downloaded={}", downloadedPackageIndexFiles, (Object)additionalPackageIndexFiles);
        File[] fileArray = additionalPackageIndexFiles;
        int n = additionalPackageIndexFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File additionalPackageIndexFile = fileArray[n2];
            if (!downloadedPackageIndexFiles.contains(additionalPackageIndexFile.getName())) {
                log.info("Delete this unknown file={} because not included in this list={}", (Object)additionalPackageIndexFile, (Object)additionalPackageIndexFiles);
                Files.delete(additionalPackageIndexFile.toPath());
            }
            ++n2;
        }
    }
}

