/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.i18n;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ExternalProcessOutputParser {
    private static final Pattern SPLIT = Pattern.compile(" \\|\\|\\| ");

    public Map<String, Object> parse(String s) {
        if (!s.startsWith("===")) {
            throw new IllegalArgumentException(s);
        }
        s = s.substring(3);
        HashMap<String, Object> output = new HashMap<String, Object>();
        String[] parts = SPLIT.split(s);
        int idx = 0;
        if (parts.length == 3) {
            output.put("level", parts[idx++]);
        }
        output.put("msg", parts[idx++]);
        output.put("args", this.parseArgs(parts[idx++]));
        return output;
    }

    private Object[] parseArgs(String argsAsString) {
        if (!argsAsString.startsWith("[") || !argsAsString.endsWith("]")) {
            throw new IllegalArgumentException(argsAsString);
        }
        if ((argsAsString = argsAsString.substring(1, argsAsString.length() - 1)).isEmpty()) {
            return new Object[0];
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsAsString.split(" ")));
        List<String> additionalArgs = this.addAsManyEmptyArgsAsEndingSpaces(argsAsString, args);
        int i = 0;
        while (i < args.size()) {
            try {
                args.set(i, URLDecoder.decode((String)args.get(i), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        args.addAll(additionalArgs);
        return args.toArray();
    }

    private List<String> addAsManyEmptyArgsAsEndingSpaces(String argsAsString, List<String> args) {
        LinkedList<String> additionalArgs = new LinkedList<String>();
        if (argsAsString.charAt(argsAsString.length() - 1) == ' ') {
            String allArgsButEndingSpacesAsString = args.stream().collect(Collectors.joining(" "));
            String endingSpacesOnly = argsAsString.replace(allArgsButEndingSpacesAsString, "");
            int i = 0;
            while (i < endingSpacesOnly.length()) {
                additionalArgs.add("");
                ++i;
            }
        }
        return additionalArgs;
    }
}

