/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.PluggableDiscoveryMessage;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import processing.app.I18n;
import processing.app.PreferencesData;

public class PluggableDiscovery
implements Discovery {
    private final String discoveryName;
    private final String[] cmd;
    private final List<BoardPort> portList = new ArrayList<BoardPort>();
    private Process program = null;
    private Thread pollingThread;

    private void debug(String x) {
        if (PreferencesData.getBoolean("discovery.debug")) {
            System.out.println(String.valueOf(this.discoveryName) + ": " + x);
        }
    }

    public PluggableDiscovery(String discoveryName, String[] cmd) {
        this.cmd = cmd;
        this.discoveryName = discoveryName;
    }

    @Override
    public void run() {
        try {
            this.start();
            InputStream input = this.program.getInputStream();
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(input);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            while (this.program != null && this.program.isAlive()) {
                JsonNode tree = (JsonNode)mapper.readTree(parser);
                if (tree == null) {
                    if (this.program == null || !this.program.isAlive()) break;
                    System.err.println(I18n.format("{0}: Invalid json message", this.discoveryName));
                    break;
                }
                this.debug("Received json: " + tree);
                this.processJsonNode(mapper, tree);
            }
            this.debug("thread exit normally");
        }
        catch (InterruptedException e) {
            this.debug("thread exit by interrupt");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.debug("thread exit other exception");
            e.printStackTrace();
        }
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJsonNode(ObjectMapper mapper, JsonNode node) {
        JsonNode eventTypeNode = node.get("eventType");
        if (eventTypeNode == null) {
            System.err.println(I18n.format("{0}: Invalid message, missing eventType", this.discoveryName));
            return;
        }
        switch (eventTypeNode.asText()) {
            case "error": {
                try {
                    PluggableDiscoveryMessage msg = (PluggableDiscoveryMessage)mapper.treeToValue((TreeNode)node, PluggableDiscoveryMessage.class);
                    this.debug("error: " + msg.getMessage());
                    if (msg.getMessage().contains("START_SYNC")) {
                        this.startPolling();
                    }
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                return;
            }
            case "list": {
                JsonNode portsNode = node.get("ports");
                if (portsNode == null) {
                    System.err.println(I18n.format("{0}: Invalid message, missing ports list", this.discoveryName));
                    return;
                }
                if (!portsNode.isArray()) {
                    System.err.println(I18n.format("{0}: Invalid message, ports list should be an array", this.discoveryName));
                    return;
                }
                List<BoardPort> list = this.portList;
                synchronized (list) {
                    this.portList.clear();
                }
                portsNode.forEach(portNode -> {
                    BoardPort port = this.mapJsonNodeToBoardPort(mapper, node);
                    if (port != null) {
                        this.addOrUpdate(port);
                    }
                });
                return;
            }
            case "add": {
                BoardPort addedPort = this.mapJsonNodeToBoardPort(mapper, node);
                if (addedPort != null) {
                    this.addOrUpdate(addedPort);
                }
                return;
            }
            case "remove": {
                BoardPort removedPort = this.mapJsonNodeToBoardPort(mapper, node);
                if (removedPort != null) {
                    this.remove(removedPort);
                }
                return;
            }
        }
        this.debug("Invalid event: " + eventTypeNode.asText());
    }

    private BoardPort mapJsonNodeToBoardPort(ObjectMapper mapper, JsonNode node) {
        try {
            BoardPort port = (BoardPort)mapper.treeToValue((TreeNode)node.get("port"), BoardPort.class);
            if (port.getLabel() == null || port.getLabel().isEmpty()) {
                port.setLabel(port.getAddress());
            }
            port.searchMatchingBoard();
            return port;
        }
        catch (JsonProcessingException e) {
            System.err.println(I18n.format("{0}: Invalid BoardPort message", this.discoveryName));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.debug("Starting: " + StringUtils.join((Object[])this.cmd, (String)" "));
            this.program = Runtime.getRuntime().exec(this.cmd);
        }
        catch (Exception e) {
            this.program = null;
            return;
        }
        this.debug("START_SYNC");
        this.write("START_SYNC\n");
        this.pollingThread = null;
    }

    private void startPolling() {
        this.debug("START");
        this.write("START\n");
        Thread pollingThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (PluggableDiscovery.this.program != null && PluggableDiscovery.this.program.isAlive()) {
                        PluggableDiscovery.this.debug("LIST");
                        PluggableDiscovery.this.write("LIST\n");
                        1.sleep(2500L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        pollingThread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.pollingThread != null) {
            this.pollingThread.interrupt();
            this.pollingThread = null;
        }
        this.write("STOP\n");
        if (this.program != null) {
            this.program.destroy();
            this.program = null;
        }
    }

    private void write(String command) {
        if (this.program != null && this.program.isAlive()) {
            OutputStream out = this.program.getOutputStream();
            try {
                out.write(command.getBytes());
                out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdate(BoardPort port) {
        String address = port.getAddress();
        if (address == null) {
            return;
        }
        List<BoardPort> list = this.portList;
        synchronized (list) {
            this.portList.removeIf(bp -> address.equals(bp.getAddress()));
            this.portList.add(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(BoardPort port) {
        String address = port.getAddress();
        if (address == null) {
            return;
        }
        List<BoardPort> list = this.portList;
        synchronized (list) {
            this.portList.removeIf(bp -> address.equals(bp.getAddress()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BoardPort> listDiscoveredBoards() {
        List<BoardPort> list = this.portList;
        synchronized (list) {
            return new ArrayList<BoardPort>(this.portList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BoardPort> listDiscoveredBoards(boolean complete) {
        List<BoardPort> list = this.portList;
        synchronized (list) {
            return new ArrayList<BoardPort>(this.portList);
        }
    }

    public String toString() {
        return this.discoveryName;
    }
}

