/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.compress.utils.IOUtils;

public class SSH {
    final Session session;

    public SSH(Session session) {
        this.session = session;
    }

    public boolean execSyncCommand(String command) throws JSchException, IOException {
        return this.execSyncCommand(command, null, null);
    }

    public boolean execSyncCommand(String command, PrintStream stdoutConsumer, PrintStream stderrConsumer) throws JSchException, IOException {
        boolean bl;
        InputStream stdout = null;
        InputStream stderr = null;
        Channel channel = null;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            stdout = channel.getInputStream();
            stderr = ((ChannelExec)channel).getErrStream();
            channel.connect();
            int exitCode = this.consumeOutputSyncAndReturnExitCode(channel, stdout, stdoutConsumer, stderr, stderrConsumer);
            bl = exitCode == 0;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stdout);
            IOUtils.closeQuietly(stderr);
            if (channel != null) {
                channel.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)stdout);
        IOUtils.closeQuietly((Closeable)stderr);
        if (channel != null) {
            channel.disconnect();
        }
        return bl;
    }

    private int consumeOutputSyncAndReturnExitCode(Channel channel, InputStream stdout, PrintStream stdoutConsumer, InputStream stderr, PrintStream stderrConsumer) throws IOException {
        byte[] tmp = new byte[102400];
        while (true) {
            this.consumeStream(tmp, stdout, stdoutConsumer);
            this.consumeStream(tmp, stderr, stderrConsumer);
            if (channel.isClosed()) {
                return channel.getExitStatus();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    private void consumeStream(byte[] buffer, InputStream in, PrintStream out) throws IOException {
        while (in.available() > 0) {
            int length = in.read(buffer, 0, buffer.length);
            if (length < 0) break;
            if (out == null) continue;
            out.print(new String(buffer, 0, length));
        }
    }
}

