/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import processing.app.helpers.FileUtils;
import processing.app.packages.UserLibrary;

public class LibraryList
extends LinkedList<UserLibrary> {
    public LibraryList(LibraryList libs) {
        super(libs);
    }

    public LibraryList() {
    }

    public LibraryList(List<UserLibrary> ideLibs) {
        super(ideLibs);
    }

    public synchronized UserLibrary getByName(String name) {
        for (UserLibrary l : this) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }

    public synchronized void sort() {
        Collections.sort(this, (x, y) -> x.getName().compareToIgnoreCase(y.getName()));
    }

    public synchronized LibraryList filterLibrariesInSubfolder(File subFolder) {
        LibraryList res = new LibraryList();
        for (UserLibrary lib : this) {
            if (!FileUtils.isSubDirectory(subFolder, lib.getInstalledFolder())) continue;
            res.add(lib);
        }
        return res;
    }

    public synchronized boolean hasLibrary(UserLibrary lib) {
        for (UserLibrary l : this) {
            if (l != lib) continue;
            return true;
        }
        return false;
    }

    public static Collector<UserLibrary, LibraryList, LibraryList> collector() {
        return new Collector<UserLibrary, LibraryList, LibraryList>(){

            @Override
            public Supplier<LibraryList> supplier() {
                return () -> new LibraryList();
            }

            @Override
            public BiConsumer<LibraryList, UserLibrary> accumulator() {
                return (libs, lib) -> {
                    boolean bl = libs.add(lib);
                };
            }

            @Override
            public BinaryOperator<LibraryList> combiner() {
                return (we, they) -> {
                    we.addAll(they);
                    return we;
                };
            }

            @Override
            public Function<LibraryList, LibraryList> finisher() {
                return libs -> libs;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.noneOf(Collector.Characteristics.class);
            }
        };
    }
}

