/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.ContributionsSelfCheck;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import processing.app.BaseNoGui;
import processing.app.packages.UserLibraryFolder;

public class UpdatableLibraryTest {
    File testdata = new File(UpdatableLibraryTest.class.getResource("/").getFile(), "../testdata/libraries");
    File index_SD_only = new File(this.testdata, "index_SD_only");
    File SD111 = new File(this.testdata, "SD_1.1.1");
    File SD121 = new File(this.testdata, "SD_1.2.1");
    File index_Bridge_only = new File(this.testdata, "index_Bridge_only");
    File Bridge163 = new File(this.testdata, "Bridge_1.6.3");
    File Bridge170 = new File(this.testdata, "Bridge_1.7.0");

    @Test
    public void testUpdatableLibrary() throws Exception {
        LibrariesIndexer indexer;
        ArrayList<UserLibraryFolder> folders = new ArrayList<UserLibraryFolder>();
        folders.add(new UserLibraryFolder(this.SD111, UserLibraryFolder.Location.IDE_BUILTIN));
        BaseNoGui.librariesIndexer = indexer = new LibrariesIndexer(this.index_SD_only);
        indexer.parseIndex();
        indexer.setLibrariesFolders(folders);
        indexer.rescanLibraries();
        ContributedLibrary sdLib = (ContributedLibrary)indexer.getIndex().getInstalled("SD").get();
        Assert.assertTrue((String)"SD lib is installed", (boolean)sdLib.isLibraryInstalled());
        Assert.assertEquals((String)"SD installed version", (Object)"1.1.1", (Object)sdLib.getParsedVersion());
        Assert.assertTrue((boolean)ContributionsSelfCheck.checkForUpdatableLibraries());
        folders.add(new UserLibraryFolder(this.SD121, UserLibraryFolder.Location.SKETCHBOOK));
        indexer.setLibrariesFolders(folders);
        sdLib = (ContributedLibrary)indexer.getIndex().getInstalled("SD").get();
        Assert.assertTrue((String)"SD lib is installed", (boolean)sdLib.isLibraryInstalled());
        Assert.assertEquals((String)"SD installed version", (Object)"1.2.1", (Object)sdLib.getParsedVersion());
        Assert.assertFalse((boolean)ContributionsSelfCheck.checkForUpdatableLibraries());
    }

    @Test
    public void testUpdatableLibraryWithBundled() throws Exception {
        LibrariesIndexer indexer;
        ArrayList<UserLibraryFolder> folders = new ArrayList<UserLibraryFolder>();
        folders.add(new UserLibraryFolder(this.Bridge163, UserLibraryFolder.Location.IDE_BUILTIN));
        BaseNoGui.librariesIndexer = indexer = new LibrariesIndexer(this.index_Bridge_only);
        indexer.parseIndex();
        indexer.setLibrariesFolders(folders);
        indexer.rescanLibraries();
        ContributedLibrary l = (ContributedLibrary)indexer.getIndex().getInstalled("Bridge").get();
        Assert.assertTrue((String)"Bridge lib is installed", (boolean)l.isLibraryInstalled());
        Assert.assertEquals((String)"Bridge installed version", (Object)"1.6.3", (Object)l.getParsedVersion());
        Assert.assertTrue((boolean)ContributionsSelfCheck.checkForUpdatableLibraries());
        folders.add(new UserLibraryFolder(this.Bridge170, UserLibraryFolder.Location.SKETCHBOOK));
        indexer.setLibrariesFolders(folders);
        l = (ContributedLibrary)indexer.getIndex().getInstalled("Bridge").get();
        Assert.assertTrue((String)"Bridge lib is installed", (boolean)l.isLibraryInstalled());
        Assert.assertEquals((String)"Bridge installed version", (Object)"1.7.0", (Object)l.getParsedVersion());
        Assert.assertFalse((boolean)ContributionsSelfCheck.checkForUpdatableLibraries());
    }
}

