/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.VersionHelper;
import com.github.zafarkhaja.semver.Version;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class VersionHelperTest {
    public void assertOptionalEquals(String expected, Optional<Version> value) {
        Assert.assertTrue((boolean)value.isPresent());
        Assert.assertEquals((Object)expected, (Object)value.get().toString());
    }

    @Test
    public void testVersions() throws Exception {
        this.assertOptionalEquals("1.0.0", VersionHelper.valueOf((String)"1.0.0"));
        this.assertOptionalEquals("1.0.0", VersionHelper.valueOf((String)"1.0"));
        this.assertOptionalEquals("1.0.0", VersionHelper.valueOf((String)"1"));
        this.assertOptionalEquals("1.0.0-abc", VersionHelper.valueOf((String)"1.0.0-abc"));
        this.assertOptionalEquals("1.0.0-abc", VersionHelper.valueOf((String)"1.0-abc"));
        this.assertOptionalEquals("1.0.0-abc", VersionHelper.valueOf((String)"1-abc"));
        this.assertOptionalEquals("1.0.0+abc", VersionHelper.valueOf((String)"1.0.0+abc"));
        this.assertOptionalEquals("1.0.0+abc", VersionHelper.valueOf((String)"1.0+abc"));
        this.assertOptionalEquals("1.0.0+abc", VersionHelper.valueOf((String)"1+abc"));
        this.assertOptionalEquals("1.0.0-def+abc", VersionHelper.valueOf((String)"1.0.0-def+abc"));
        this.assertOptionalEquals("1.0.0-def+abc", VersionHelper.valueOf((String)"1.0-def+abc"));
        this.assertOptionalEquals("1.0.0-def+abc", VersionHelper.valueOf((String)"1-def+abc"));
        this.assertOptionalEquals("1.0.0+def-abc", VersionHelper.valueOf((String)"1.0.0+def-abc"));
        this.assertOptionalEquals("1.0.0+def-abc", VersionHelper.valueOf((String)"1.0+def-abc"));
        this.assertOptionalEquals("1.0.0+def-abc", VersionHelper.valueOf((String)"1+def-abc"));
    }
}

