/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.i18n;

import cc.arduino.i18n.ExternalProcessOutputParser;
import cc.arduino.i18n.Language;
import cc.arduino.i18n.Languages;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.junit.Assert;
import org.junit.Test;
import processing.app.AbstractWithPreferencesTest;
import processing.app.I18n;

public class I18NTest
extends AbstractWithPreferencesTest {
    @Test
    public void testMessageFormat() throws Exception {
        Object[] args = new Object[]{"a", "b", "c"};
        String actual = I18n.format((String)"WARNING: Category '{0}' in library {1} is not valid. Setting to '{2}'", (Object[])args);
        Assert.assertEquals((Object)"WARNING: Category 'a' in library b is not valid. Setting to 'c'", (Object)actual);
    }

    @Test
    public void testMessageFormatFromExternalProcess() throws Exception {
        Map output = new ExternalProcessOutputParser().parse("===WARNING: Category '{0}' in library {1} is not valid. Setting to '{2}' ||| [ Wire Uncategorized]");
        String actual = I18n.format((String)((String)output.get("msg")), (Object[])((Object[])output.get("args")));
        Assert.assertEquals((Object)"WARNING: Category '' in library Wire is not valid. Setting to 'Uncategorized'", (Object)actual);
    }

    @Test
    public void testAllLocales() {
        Language[] languageArray = Languages.languages;
        int n = Languages.languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (!language.getIsoCode().equals("")) {
                ResourceBundle bundle;
                Locale locale = this.toLocale(language);
                if (locale.equals((bundle = ResourceBundle.getBundle("processing.app.i18n.Resources", locale)).getLocale())) {
                    Collections.list(bundle.getKeys()).stream().map(bundle::getString).filter(key -> !key.contains("<html")).forEach(key -> {
                        try {
                            I18n.format((String)key, (Object[])new Object[0]);
                        }
                        catch (IllegalArgumentException e) {
                            System.out.println(language);
                            System.out.println((String)key);
                            throw e;
                        }
                    });
                } else {
                    System.out.println("Missing locale: " + locale);
                }
            }
            ++n2;
        }
    }

    private Locale toLocale(Language language) {
        String[] languageParts = language.getIsoCode().split("_");
        if (languageParts.length == 2) {
            return new Locale(languageParts[0], languageParts[1]);
        }
        return new Locale(languageParts[0]);
    }
}

