/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.net;

import cc.arduino.net.CustomProxySelector;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomProxySelectorTest {
    private Map<String, String> preferences;
    private URI uri;

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.net.useSystemProxies", "true");
        this.uri = new URL("https://www.arduino.cc").toURI();
        this.preferences = new HashMap<String, String>();
    }

    @Test
    public void testNoProxy() throws Exception {
        this.preferences.put("proxy.type", "none");
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)Proxy.NO_PROXY, (Object)proxy);
    }

    @Test
    public void testSystemProxy() throws Exception {
        this.preferences.put("proxy.type", "auto");
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)ProxySelector.getDefault().select(this.uri).get(0), (Object)proxy);
    }

    @Test
    public void testProxyPACHTTP() throws Exception {
        this.preferences.put("proxy.type", "auto");
        this.preferences.put("proxy.pac.url", CustomProxySelectorTest.class.getResource("proxy_http.pac").toExternalForm());
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy.example.com", 8080)), (Object)proxy);
    }

    @Test
    public void testProxyPACHTTPWithLogin() throws Exception {
        this.preferences.put("proxy.type", "auto");
        this.preferences.put("proxy.pac.url", CustomProxySelectorTest.class.getResource("proxy_http.pac").toExternalForm());
        this.preferences.put("proxy.manual.username", "auto");
        this.preferences.put("proxy.manual.password", "autopassword");
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy.example.com", 8080)), (Object)proxy);
        PasswordAuthentication authentication = Authenticator.requestPasswordAuthentication(null, 8080, this.uri.toURL().getProtocol(), "ciao", "");
        Assert.assertEquals((Object)authentication.getUserName(), (Object)"auto");
        Assert.assertEquals((Object)String.valueOf(authentication.getPassword()), (Object)"autopassword");
    }

    @Test
    public void testProxyPACSOCKS() throws Exception {
        this.preferences.put("proxy.type", "auto");
        this.preferences.put("proxy.pac.url", CustomProxySelectorTest.class.getResource("proxy_socks.pac").toExternalForm());
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("proxy.example.com", 8080)), (Object)proxy);
    }

    @Test
    public void testProxyPACDirect() throws Exception {
        this.preferences.put("proxy.type", "auto");
        this.preferences.put("proxy.pac.url", CustomProxySelectorTest.class.getResource("proxy_direct.pac").toExternalForm());
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)Proxy.NO_PROXY, (Object)proxy);
    }

    @Test
    public void testProxyPACComplex() throws Exception {
        this.preferences.put("proxy.type", "auto");
        this.preferences.put("proxy.pac.url", CustomProxySelectorTest.class.getResource("proxy_complex.pac").toExternalForm());
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("4.5.6.7", 8080)), (Object)proxy);
    }

    @Test
    public void testProxyPACComplex2() throws Exception {
        this.preferences.put("proxy.type", "auto");
        this.preferences.put("proxy.pac.url", CustomProxySelectorTest.class.getResource("proxy_complex.pac").toExternalForm());
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(new URL("http://www.intranet.domain.com/ciao").toURI());
        Assert.assertEquals((Object)Proxy.NO_PROXY, (Object)proxy);
    }

    @Test
    public void testManualProxy() throws Exception {
        this.preferences.put("proxy.type", "manual");
        this.preferences.put("proxy.manual.type", "HTTP");
        this.preferences.put("proxy.manual.hostname", "localhost");
        this.preferences.put("proxy.manual.port", "8080");
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 8080)), (Object)proxy);
    }

    @Test
    public void testManualProxyWithLogin() throws Exception {
        this.preferences.put("proxy.type", "manual");
        this.preferences.put("proxy.manual.type", "HTTP");
        this.preferences.put("proxy.manual.hostname", "localhost");
        this.preferences.put("proxy.manual.port", "8080");
        this.preferences.put("proxy.manual.username", "username");
        this.preferences.put("proxy.manual.password", "pwd");
        CustomProxySelector proxySelector = new CustomProxySelector(this.preferences);
        Proxy proxy = proxySelector.getProxyFor(this.uri);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 8080)), (Object)proxy);
        PasswordAuthentication authentication = Authenticator.requestPasswordAuthentication(null, 8080, this.uri.toURL().getProtocol(), "ciao", "");
        Assert.assertEquals((Object)authentication.getUserName(), (Object)"username");
        Assert.assertEquals((Object)String.valueOf(authentication.getPassword()), (Object)"pwd");
    }
}

