/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.packages.uploaders.MergeSketchWithBooloader;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import processing.app.helpers.FileUtils;

public class MergeSketchWithUploaderTest {
    private File sketch;
    private File bootloader;

    @Before
    public void setup() throws Exception {
        File originalSketch = MergeSketchWithUploaderTest.getResourceFile("/sketch.hex");
        this.sketch = new File(System.getProperty("java.io.tmpdir"), "sketch.hex");
        FileUtils.copyFile((File)originalSketch, (File)this.sketch);
        MergeSketchWithUploaderTest.removeCariageReturns(this.sketch);
        File originalBootloader = MergeSketchWithUploaderTest.getResourceFile("/optiboot_atmega328.hex");
        this.bootloader = new File(System.getProperty("java.io.tmpdir"), "optiboot_atmega328.hex");
        FileUtils.copyFile((File)originalBootloader, (File)this.bootloader);
        MergeSketchWithUploaderTest.removeCariageReturns(this.bootloader);
    }

    @After
    public void removeTmpFile() {
        this.sketch.delete();
    }

    @Test
    public void shouldMergeWithOptiboot() throws Exception {
        Assert.assertEquals((long)11720L, (long)this.sketch.length());
        Assert.assertEquals((long)1432L, (long)this.bootloader.length());
        File bootloader = MergeSketchWithUploaderTest.getResourceFile("/optiboot_atmega328.hex");
        new MergeSketchWithBooloader().merge(this.sketch, bootloader);
        Assert.assertEquals((long)13140L, (long)this.sketch.length());
    }

    private static File getResourceFile(String resourcePath) throws Exception {
        return new File(URLDecoder.decode(MergeSketchWithUploaderTest.class.getResource(resourcePath).getFile(), "UTF-8"));
    }

    private static void removeCariageReturns(File file) throws Exception {
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        StringBuilder contentBuilder = new StringBuilder();
        for (String line : lines) {
            contentBuilder.append(line).append('\n');
        }
        Files.write(file.toPath(), contentBuilder.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

