/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.FileUtils;

public abstract class AbstractWithPreferencesTest {
    protected List<File> deleteAfter = new LinkedList<File>();
    protected File preferencesFile;

    @Before
    public void init() throws Exception {
        File settingsDir = Files.createTempDirectory("arduino_test_settings", new FileAttribute[0]).toFile();
        this.deleteAfter.add(settingsDir);
        this.preferencesFile = new File(settingsDir, "preferences.txt");
        File sketchbookDir = new File(settingsDir, "sketchbook");
        sketchbookDir.mkdir();
        BaseNoGui.initPlatform();
        BaseNoGui.getPlatform().init();
        PreferencesData.init((File)this.preferencesFile);
        PreferencesData.set((String)"settings.path", (String)settingsDir.toString());
        PreferencesData.set((String)"sketchbook.path", (String)sketchbookDir.toString());
        PreferencesData.set((String)"update.check", (String)sketchbookDir.toString());
        PreferencesData.save();
        Theme.init();
        BaseNoGui.initPackages();
        Base.untitledFolder = FileUtils.createTempFolder((String)("untitled" + new Random().nextInt(Integer.MAX_VALUE)), (String)".tmp");
        this.deleteAfter.add(Base.untitledFolder);
    }

    protected String[] getBaseArgs() {
        return new String[]{"--preferences-file", this.preferencesFile.toString()};
    }

    protected Base createBase() throws Exception {
        Base base = new Base(this.getBaseArgs());
        Assert.assertEquals((Object)this.preferencesFile, (Object)PreferencesData.preferencesFile);
        return base;
    }

    @After
    public void cleanup() throws IOException {
        for (File f : this.deleteAfter) {
            FileUtils.recursiveDelete((File)f);
        }
        this.deleteAfter = new LinkedList<File>();
    }
}

