/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.compress.utils.IOUtils;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import processing.app.AbstractWithPreferencesTest;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;

public class CommandLineTest
extends AbstractWithPreferencesTest {
    private static File buildPath;
    private static File arduinoPath;

    @BeforeClass
    public static void findBuildPaths() throws Exception {
        buildPath = new File(System.getProperty("user.dir"));
        while (!new File(buildPath, "build").isDirectory()) {
            if ((buildPath = buildPath.getParentFile()) != null) continue;
            throw new Exception("Could not determine build path");
        }
        System.out.println("found buildpath: " + buildPath);
        if (OSUtils.isLinux()) {
            arduinoPath = new File(buildPath, "build/linux/work/arduino");
        }
        if (OSUtils.isWindows()) {
            arduinoPath = new File(buildPath, "build/windows/work/arduino.exe");
        }
        if (OSUtils.isMacOS()) {
            arduinoPath = new File(buildPath, "build/macosx/work/Arduino.app/Contents/MacOS/Arduino");
        }
        if (!arduinoPath.canExecute()) {
            throw new Exception("Could not determine arduino location");
        }
        System.out.println("found arduino: " + arduinoPath);
    }

    public Process runArduino(boolean output, boolean success, File wd, String[] extraArgs) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        ArrayList<String> args = new ArrayList<String>();
        args.add(arduinoPath.getAbsolutePath());
        args.addAll(Arrays.asList(this.getBaseArgs()));
        args.addAll(Arrays.asList(extraArgs));
        System.out.println("Running: " + String.join((CharSequence)" ", args));
        Process pr = rt.exec(args.toArray(new String[0]), null, wd);
        if (output) {
            IOUtils.copy((InputStream)pr.getInputStream(), (OutputStream)System.out);
            IOUtils.copy((InputStream)pr.getErrorStream(), (OutputStream)System.out);
        }
        pr.waitFor();
        if (success) {
            Assert.assertEquals((long)0L, (long)pr.exitValue());
        }
        return pr;
    }

    @Test
    public void testCommandLineBuildWithRelativePath() throws Exception {
        File wd = new File(buildPath, "build/shared/examples/01.Basics/Blink/");
        this.runArduino(true, true, wd, new String[]{"--board", "arduino:avr:uno", "--verify", "Blink.ino"});
    }

    @Test
    public void testCommandLinePreferencesSave() throws Exception {
        File prefFile = File.createTempFile("test_pref", ".txt");
        prefFile.deleteOnExit();
        this.runArduino(true, true, null, new String[]{"--save-prefs", "--preferences-file", prefFile.getAbsolutePath(), "--version"});
        this.runArduino(true, true, null, new String[]{"--pref", "test_pref=xxx", "--preferences-file", prefFile.getAbsolutePath()});
        PreferencesMap prefs = new PreferencesMap(prefFile);
        Assert.assertNull((String)"preference should not be saved", (Object)prefs.get((Object)"test_pref"));
        this.runArduino(true, true, null, new String[]{"--pref", "test_pref=xxx", "--preferences-file", prefFile.getAbsolutePath(), "--save-prefs"});
        prefs = new PreferencesMap(prefFile);
        Assert.assertEquals((String)"preference should be saved", (Object)"xxx", (Object)prefs.get((Object)"test_pref"));
    }

    @Test
    public void testCommandLineVersion() throws Exception {
        Process pr = this.runArduino(false, true, null, new String[]{"--version"});
        Assertions.assertThat((String)new String(IOUtils.toByteArray((InputStream)pr.getInputStream()))).matches("Arduino: \\d+\\.\\d+\\.\\d+.*\r?\n");
    }

    @Test
    public void testCommandLineMultipleAction() throws Exception {
        Process pr = this.runArduino(true, false, null, new String[]{"--version", "--verify"});
        Assertions.assertThat((int)pr.exitValue()).as("Multiple Action will be rejected").isEqualTo(3);
    }
}

