/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.ConsoleOutputStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.Base;
import processing.app.PreferencesData;
import processing.app.Theme;

public class EditorConsole
extends JScrollPane {
    private static ConsoleOutputStream out;
    private static ConsoleOutputStream err;
    private int startOfLine = 0;
    private int insertPosition = 0;
    private static final Pattern newLinePattern;
    private final DefaultStyledDocument document = new DefaultStyledDocument();
    private final JTextPane consoleTextPane = new JTextPane(this.document);
    private SimpleAttributeSet stdOutStyle;
    private SimpleAttributeSet stdErrStyle;

    static {
        newLinePattern = Pattern.compile("([^\r\n]*)([\r\n]*\n)?(\r+)?");
    }

    public static synchronized void setCurrentEditorConsole(EditorConsole console) {
        if (out == null) {
            out = new ConsoleOutputStream(console.stdOutStyle, System.out);
            System.setOut(new PrintStream(out, true));
            err = new ConsoleOutputStream(console.stdErrStyle, System.err);
            System.setErr(new PrintStream(err, true));
        }
        out.setCurrentEditorConsole(console);
        err.setCurrentEditorConsole(console);
    }

    public EditorConsole(Base base) {
        this.consoleTextPane.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.consoleTextPane.getCaret();
        caret.setUpdatePolicy(1);
        this.consoleTextPane.setFocusTraversalKeysEnabled(false);
        Color backgroundColour = Theme.getColor("console.color");
        this.consoleTextPane.setBackground(backgroundColour);
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        Font actualFont = new Font(consoleFont.getName(), consoleFont.getStyle(), Theme.scale(editorFont.getSize()));
        this.stdOutStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdOutStyle, Theme.getColor("console.output.color"));
        StyleConstants.setBackground(this.stdOutStyle, backgroundColour);
        StyleConstants.setFontSize(this.stdOutStyle, actualFont.getSize());
        StyleConstants.setFontFamily(this.stdOutStyle, actualFont.getFamily());
        StyleConstants.setBold(this.stdOutStyle, actualFont.isBold());
        StyleConstants.setItalic(this.stdOutStyle, actualFont.isItalic());
        this.consoleTextPane.setParagraphAttributes(this.stdOutStyle, true);
        this.stdErrStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdErrStyle, Theme.getColor("console.error.color"));
        StyleConstants.setBackground(this.stdErrStyle, backgroundColour);
        StyleConstants.setFontSize(this.stdErrStyle, actualFont.getSize());
        StyleConstants.setFontFamily(this.stdErrStyle, actualFont.getFamily());
        StyleConstants.setBold(this.stdErrStyle, actualFont.isBold());
        StyleConstants.setItalic(this.stdErrStyle, actualFont.isItalic());
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this.consoleTextPane);
        this.setViewportView(noWrapPanel);
        this.getVerticalScrollBar().setUnitIncrement(7);
        FontMetrics metrics = this.getFontMetrics(actualFont);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = PreferencesData.getInteger((String)"console.lines");
        this.setPreferredSize(new Dimension(100, height * lines));
        this.setMinimumSize(new Dimension(100, height * lines));
        if (base != null) {
            base.addEditorFontResizeListeners(this.consoleTextPane);
        }
    }

    public void applyPreferences() {
        block7: {
            Font consoleFont = Theme.getFont("console.font");
            Font editorFont = PreferencesData.getFont((String)"editor.font");
            Font actualFont = new Font(consoleFont.getName(), consoleFont.getStyle(), Theme.scale(editorFont.getSize()));
            AttributeSet stdOutStyleOld = this.stdOutStyle.copyAttributes();
            AttributeSet stdErrStyleOld = this.stdErrStyle.copyAttributes();
            StyleConstants.setFontSize(this.stdOutStyle, actualFont.getSize());
            StyleConstants.setFontSize(this.stdErrStyle, actualFont.getSize());
            if (this.stdOutStyle.isEqual(stdOutStyleOld) && this.stdErrStyle.isEqual(stdOutStyleOld)) break block7;
            if (out != null) {
                out.setAttibutes(this.stdOutStyle);
            }
            if (err != null) {
                err.setAttibutes(this.stdErrStyle);
            }
            int end = this.document.getLength() - 1;
            while (end >= 0) {
                int start;
                block6: {
                    SimpleAttributeSet newAttrs;
                    block9: {
                        AttributeSet attrs;
                        block8: {
                            Element elem = this.document.getParagraphElement(end);
                            start = elem.getStartOffset();
                            attrs = elem.getElement(0).getAttributes();
                            if (!attrs.isEqual(stdErrStyleOld)) break block8;
                            newAttrs = this.stdErrStyle;
                            break block9;
                        }
                        if (!attrs.isEqual(stdOutStyleOld)) break block6;
                        newAttrs = this.stdOutStyle;
                    }
                    try {
                        String text = this.document.getText(start, end - start);
                        this.document.remove(start, end - start);
                        this.document.insertString(start, text, newAttrs);
                    }
                    catch (BadLocationException e) {
                        if (this.document.getLength() == 0) break block6;
                        throw new Error(e);
                    }
                }
                end = start - 1;
            }
        }
    }

    public void clear() {
        try {
            this.document.remove(0, this.document.getLength());
            this.startOfLine = 0;
            this.insertPosition = 0;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void scrollDown() {
        this.getHorizontalScrollBar().setValue(0);
        this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getMaximum());
    }

    public boolean isEmpty() {
        return this.document.getLength() == 0;
    }

    public void insertString(String str, SimpleAttributeSet attributes) throws BadLocationException {
        Matcher m = newLinePattern.matcher(str);
        while (m.find()) {
            String content = m.group(1);
            String newlines = m.group(2);
            String crs = m.group(3);
            int replaceLength = Math.min(content.length(), this.document.getLength() - this.insertPosition);
            this.document.replace(this.insertPosition, replaceLength, content, attributes);
            this.insertPosition += content.length();
            if (newlines != null) {
                this.document.insertString(this.document.getLength(), newlines, attributes);
                this.startOfLine = this.insertPosition = this.document.getLength();
            }
            if (crs == null) continue;
            this.insertPosition = this.startOfLine;
        }
    }

    public String getText() {
        return this.consoleTextPane.getText();
    }
}

