/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import processing.app.AbstractWithPreferencesTest;
import processing.app.EditorConsole;

public class EditorConsoleTest
extends AbstractWithPreferencesTest {
    private EditorConsole console;

    @Before
    public void createConsole() {
        this.console = new EditorConsole(null);
    }

    public String escapeString(String input) {
        return input.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
    }

    public void assertOutput(String output) {
        Assert.assertEquals((Object)this.escapeString(output), (Object)this.escapeString(this.console.getText()));
    }

    @Test
    public void testHelloWorld() throws Exception {
        this.console.insertString("Hello, world!", null);
        this.assertOutput("Hello, world!");
    }

    @Test
    public void testCrNlHandling() throws Exception {
        this.console.insertString("abc\r\ndef", null);
        this.assertOutput("abc\r\ndef");
        this.console.insertString("xyz", null);
        this.assertOutput("abc\r\ndefxyz");
        this.console.insertString("000\r\n123", null);
        this.assertOutput("abc\r\ndefxyz000\r\n123");
        this.console.insertString("\r\n", null);
        this.assertOutput("abc\r\ndefxyz000\r\n123\r\n");
    }

    @Test
    public void testNlHandling() throws Exception {
        this.console.insertString("abc\ndef", null);
        this.assertOutput("abc\ndef");
        this.console.insertString("xyz", null);
        this.assertOutput("abc\ndefxyz");
        this.console.insertString("000\n123", null);
        this.assertOutput("abc\ndefxyz000\n123");
        this.console.insertString("\n", null);
        this.assertOutput("abc\ndefxyz000\n123\n");
    }

    @Test
    public void testCrHandling() throws Exception {
        this.console.clear();
        this.console.insertString("abc\rdef", null);
        this.assertOutput("def");
        this.console.insertString("\r", null);
        this.assertOutput("def");
        this.console.insertString("\r\r\r", null);
        this.assertOutput("def");
        this.console.insertString("123", null);
        this.assertOutput("123");
        this.console.insertString("\r456\r\r", null);
        this.assertOutput("456");
        this.console.insertString("000", null);
        this.assertOutput("000");
        this.console.insertString("\r\nxxx\r", null);
        this.assertOutput("000\r\nxxx");
        this.console.insertString("yyy", null);
        this.assertOutput("000\r\nyyy");
        this.console.insertString("\r", null);
        this.assertOutput("000\r\nyyy");
        this.console.insertString("\n", null);
        this.assertOutput("000\r\nyyy\n");
    }

    @Test
    public void testCrPartialOverwrite() throws Exception {
        this.console.insertString("abcdef\r", null);
        this.assertOutput("abcdef");
        this.console.insertString("123", null);
        this.assertOutput("123def");
        this.console.insertString("4", null);
        this.assertOutput("1234ef");
        this.console.insertString("\r\n56", null);
        this.assertOutput("1234ef\r\n56");
    }

    @Test
    public void testTogether() throws Exception {
        this.console.insertString("abc\n123456\rdef\rx\r\nyyy\nzzz\r999", null);
        this.assertOutput("abc\nxef456\r\nyyy\n999");
    }
}

