/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;
import processing.app.AbstractTextMonitor;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.PreferencesMap;

public class UpdateTextAreaActionTest {
    private static final String TIMESTAMP_REGEX = "\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d";

    @Before
    public void setup() {
        PreferencesData.defaults = new PreferencesMap();
        PreferencesData.set((String)"editor.font", (String)"Monospaced,plain,12");
        PreferencesData.set((String)"gui.scale", (String)"100");
        Theme.defaults = new PreferencesMap();
        Theme.table.put((Object)"console.font", (Object)"Monospaced,plain,12");
    }

    @Test
    public void noTimestampAdded() {
        DummyTextMonitor textMon = new DummyTextMonitor(new BoardPort());
        textMon.addTimeStampBox.setSelected(false);
        textMon.updateTextArea("line1\nline2\r\nline3");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("line1\nline2\r\nline3");
    }

    @Test
    public void all3LinesHaveTimestampAdded() {
        DummyTextMonitor textMon = new DummyTextMonitor(new BoardPort());
        textMon.addTimeStampBox.setSelected(true);
        textMon.updateTextArea("line1\nline2\r\nline3");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> line1\\n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> line2\\r\\n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> line3");
    }

    @Test
    public void emptyLinesHaveTimestampToo() {
        DummyTextMonitor textMon = new DummyTextMonitor(new BoardPort());
        textMon.addTimeStampBox.setSelected(true);
        textMon.updateTextArea("line_1\n\nline_2");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> line_1\\n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> \\n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> line_2");
    }

    @Test
    public void newLinesAreRememberedWhenNewBufferIsUsed() {
        DummyTextMonitor textMon = new DummyTextMonitor(new BoardPort());
        textMon.addTimeStampBox.setSelected(true);
        textMon.updateTextArea("no newline");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> no newline");
        textMon.updateTextArea(" more text");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> no newline more text");
        textMon.updateTextArea("\n");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> no newline more text\n");
        textMon.updateTextArea("\n");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> no newline more text\n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> \n");
        textMon.updateTextArea("third line");
        Assertions.assertThat((String)textMon.textArea.getText()).matches("\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> no newline more text\n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> \n\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d -> third line");
    }

    class DummyTextMonitor
    extends AbstractTextMonitor {
        public DummyTextMonitor(BoardPort boardPort) {
            super(boardPort);
        }
    }
}

