/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.UploaderFactory;
import cc.arduino.packages.uploaders.GenericNetworkUploader;
import cc.arduino.packages.uploaders.SSHUploader;
import cc.arduino.packages.uploaders.SerialUploader;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import processing.app.AbstractWithPreferencesTest;
import processing.app.debug.LegacyTargetBoard;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackageStub;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformStub;
import processing.app.helpers.PreferencesMap;

public class UploaderFactoryTest
extends AbstractWithPreferencesTest {
    @Test
    public void shouldCreateAnInstanceOfSSHUploader() throws Exception {
        LegacyTargetBoard board = new LegacyTargetBoard("yun", new PreferencesMap(new HashMap()), (TargetPlatform)new TargetPlatformStub("id", new TargetPackageStub("id")));
        BoardPort boardPort = new BoardPort();
        boardPort.setBoardName("yun");
        boardPort.setAddress("192.168.0.1");
        boardPort.setProtocol("network");
        boardPort.getPrefs().put((Object)"ssh_upload", (Object)"yes");
        Uploader uploader = new UploaderFactory().newUploader((TargetBoard)board, boardPort, false);
        Assert.assertTrue((boolean)(uploader instanceof SSHUploader));
    }

    @Test
    public void shouldCreateAnInstanceOfGenericNetworkUploader() throws Exception {
        LegacyTargetBoard board = new LegacyTargetBoard("yun", new PreferencesMap(new HashMap()), (TargetPlatform)new TargetPlatformStub("id", new TargetPackageStub("id")));
        BoardPort boardPort = new BoardPort();
        boardPort.setBoardName("yun");
        boardPort.setAddress("192.168.0.1");
        boardPort.setProtocol("network");
        boardPort.getPrefs().put((Object)"ssh_upload", (Object)"no");
        Uploader uploader = new UploaderFactory().newUploader((TargetBoard)board, boardPort, false);
        Assert.assertTrue((boolean)(uploader instanceof GenericNetworkUploader));
    }

    @Test
    public void shouldCreateAnInstanceOfBasicUploaderWhenPortIsSerial() throws Exception {
        LegacyTargetBoard board = new LegacyTargetBoard("uno", new PreferencesMap(new HashMap()), (TargetPlatform)new TargetPlatformStub("id", new TargetPackageStub("id")));
        BoardPort boardPort = new BoardPort();
        boardPort.setBoardName("Arduino Leonardo");
        boardPort.setAddress("/dev/ttyACM0");
        boardPort.setProtocol("serial");
        Uploader uploader = new UploaderFactory().newUploader((TargetBoard)board, boardPort, false);
        Assert.assertTrue((boolean)(uploader instanceof SerialUploader));
    }
}

