/*
 * Decompiled with CFR 0.152.
 */
package com.kbp.client.api;

import com.google.common.collect.ImmutableSet;
import com.kbp.client.api.IPatchedKeyBinding;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class KeyBindingBuilder {
    protected String category = "key.categories.gameplay";
    protected int key = 0;
    protected ImmutableSet<Integer> cmb_keys = ImmutableSet.of();
    protected IKeyConflictContext conflict_context = KeyConflictContext.IN_GAME;

    protected KeyBindingBuilder() {
    }

    public KeyBindingBuilder withCategory(String category) {
        this.category = category;
        return this;
    }

    public KeyBindingBuilder withKey(int key) {
        this.key = key;
        return this;
    }

    public KeyBindingBuilder withMouseButton(int button) {
        this.key = button - 100;
        return this;
    }

    public KeyBindingBuilder withCmbKeys(Integer ... cmb_keys) {
        this.cmb_keys = ImmutableSet.copyOf((Object[])cmb_keys);
        return this;
    }

    public KeyBindingBuilder withConflictContext(IKeyConflictContext context) {
        this.conflict_context = context;
        return this;
    }

    public abstract IPatchedKeyBinding build();

    public IPatchedKeyBinding buildAndRegis() {
        IPatchedKeyBinding kb = this.build();
        ClientRegistry.registerKeyBinding((KeyBinding)kb.getKeyBinding());
        return kb;
    }
}

