/*
 * Decompiled with CFR 0.152.
 */
package com.kbp.client.gui;

import com.kbp.client.KBPModConfig;
import com.kbp.client.gui.GuiConfigScreen;
import com.kbp.client.impl.IKeyBindingImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
final class GuiShadowCountList
extends GuiListExtended {
    private final GuiConfigScreen parent_screen;
    private final GuiButton save_all_btn;
    private final GuiListExtended.IGuiListEntry[] list_entries;
    private final int max_label_width;
    private final Map<String, Integer> shadow_count = Arrays.stream(KBPModConfig.shadow_key_bindings).collect(Collectors.groupingBy(Function.identity(), Collectors.summingInt(o -> 1)));
    private final HashMap<String, Integer> shadow_change = new HashMap();

    GuiShadowCountList(GuiConfigScreen parent, GuiButton save_all_btn) {
        super(parent.field_146297_k, parent.field_146294_l + 45, parent.field_146295_m, 23, parent.field_146295_m - 32, 20);
        this.parent_screen = parent;
        this.save_all_btn = save_all_btn;
        KeyBinding[] kb_arr = (KeyBinding[])Arrays.stream(this.field_148161_k.field_71474_y.field_74324_K).filter(kb -> !IKeyBindingImpl.isShadowKeyBinding(kb)).toArray(KeyBinding[]::new);
        Map grouped = Arrays.stream(kb_arr).collect(Collectors.groupingBy(KeyBinding::func_151466_e, Collectors.mapping(x$0 -> new ShadowCountEntry((KeyBinding)x$0), Collectors.toList())));
        this.list_entries = (GuiListExtended.IGuiListEntry[])Arrays.stream(kb_arr).map(KeyBinding::func_151466_e).distinct().flatMap(category -> Stream.concat(Stream.of(new CategoryEntry((String)category)), ((List)grouped.get(category)).stream().sorted(Comparator.comparing(e -> ((ShadowCountEntry)e).label_text)))).toArray(GuiListExtended.IGuiListEntry[]::new);
        this.max_label_width = grouped.values().stream().flatMap(Collection::parallelStream).map(e -> ((ShadowCountEntry)e).label_text).mapToInt(arg_0 -> ((FontRenderer)this.field_148161_k.field_71466_p).func_78256_a(arg_0)).max().orElse(0);
    }

    protected int func_148127_b() {
        return this.list_entries.length;
    }

    @Nonnull
    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.list_entries[index];
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 35;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    void _applyChanges() {
        assert (!this.shadow_change.isEmpty());
        KBPModConfig.shadow_key_bindings = (String[])this.shadow_count.entrySet().stream().flatMap(e -> {
            String name = (String)e.getKey();
            int cnt = (Integer)e.getValue();
            return Stream.generate(() -> name).limit(cnt);
        }).toArray(String[]::new);
    }

    private final class ShadowCountEntry
    implements GuiListExtended.IGuiListEntry {
        private final String kb_name;
        private final String label_text;
        private final GuiButton reduce_count_btn;
        private final GuiButton increase_count_btn;
        private final GuiButton count_field;

        private ShadowCountEntry(KeyBinding kb) {
            String name;
            this.kb_name = name = kb.func_151464_g();
            this.label_text = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.reduce_count_btn = new GuiButton(0, 0, 0, 20, 20, "-");
            this.increase_count_btn = new GuiButton(0, 0, 0, 20, 20, "+");
            int count = this.__getShadowCount();
            GuiButton count_field = new GuiButton(0, 0, 0, 20, 20, Integer.toString(count));
            count_field.field_146124_l = false;
            this.count_field = count_field;
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            Minecraft mc = GuiShadowCountList.this.field_148161_k;
            int pos_x = x + 90 - GuiShadowCountList.this.max_label_width;
            int pos_y = y + slotHeight / 2 - mc.field_71466_p.field_78288_b / 2;
            mc.field_71466_p.func_78276_b(this.label_text, pos_x, pos_y, MathHelper.func_180181_b((int)255, (int)255, (int)255));
            int count = this.__getShadowCount();
            GuiButton rcb = this.reduce_count_btn;
            rcb.field_146128_h = x + 105;
            rcb.field_146129_i = y;
            rcb.field_146124_l = count > 0;
            rcb.func_191745_a(mc, mouseX, mouseY, partialTicks);
            GuiButton cf = this.count_field;
            cf.field_146128_h = x + 127;
            cf.field_146129_i = y;
            cf.func_191745_a(mc, mouseX, mouseY, partialTicks);
            GuiButton icb = this.increase_count_btn;
            icb.field_146128_h = x + 149;
            icb.field_146129_i = y;
            icb.field_146124_l = count < 5;
            icb.func_191745_a(mc, mouseX, mouseY, partialTicks);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            Minecraft mc = GuiShadowCountList.this.field_148161_k;
            if (this.reduce_count_btn.func_146116_c(mc, mouseX, mouseY)) {
                this.reduce_count_btn.func_146113_a(mc.func_147118_V());
                this.__shiftShadowCount(-1);
                return true;
            }
            if (this.increase_count_btn.func_146116_c(mc, mouseX, mouseY)) {
                this.increase_count_btn.func_146113_a(mc.func_147118_V());
                this.__shiftShadowCount(1);
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.reduce_count_btn.func_146118_a(x, y);
            this.increase_count_btn.func_146118_a(x, y);
        }

        private int __getShadowCount() {
            return GuiShadowCountList.this.shadow_count.getOrDefault(this.kb_name, 0);
        }

        private void __shiftShadowCount(int delta) {
            int count = this.__getShadowCount() + delta;
            this.count_field.field_146126_j = Integer.toString(count);
            String kb = this.kb_name;
            GuiShadowCountList.this.shadow_count.compute(kb, (k, v) -> count != 0 ? Integer.valueOf(count) : null);
            HashMap shadow_change = GuiShadowCountList.this.shadow_change;
            shadow_change.compute(kb, (k, v) -> {
                int prev_delta = v != null ? v : 0;
                int new_delta = prev_delta + delta;
                return new_delta != 0 ? Integer.valueOf(new_delta) : null;
            });
            ((GuiShadowCountList)GuiShadowCountList.this).save_all_btn.field_146124_l = !shadow_change.isEmpty();
        }
    }

    private final class CategoryEntry
    implements GuiListExtended.IGuiListEntry {
        private final String label_text;
        private final int label_width;

        private CategoryEntry(String name) {
            this.label_text = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            Minecraft mc = GuiShadowCountList.this.field_148161_k;
            this.label_width = mc.field_71466_p.func_78256_a(this.label_text);
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            Minecraft mc = GuiShadowCountList.this.field_148161_k;
            FontRenderer font_renderer = mc.field_71466_p;
            int pos_x = ((GuiShadowCountList)GuiShadowCountList.this).parent_screen.field_146294_l / 2 - this.label_width / 2;
            int pos_y = y + slotHeight - font_renderer.field_78288_b - 1;
            font_renderer.func_78276_b(this.label_text, pos_x, pos_y, MathHelper.func_180181_b((int)255, (int)255, (int)255));
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }
    }
}

