/*
 * Decompiled with CFR 0.152.
 */
package com.kbp.client.impl;

import com.google.common.collect.ImmutableSet;
import com.kbp.client.impl.ShadowKeyBinding;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public interface IKeyBindingImpl {
    public static final ImmutableSet<Integer> CMB_CTRL = ImmutableSet.of((Object)29);
    public static final ImmutableSet<Integer> CMB_META = ImmutableSet.of((Object)219);
    public static final ImmutableSet<Integer> CMB_SHIFT = ImmutableSet.of((Object)42);
    public static final ImmutableSet<Integer> CMB_ALT = ImmutableSet.of((Object)56);

    default public void initDefaultCmbKeys(ImmutableSet<Integer> cmb_keys) {
        throw new UnsupportedOperationException();
    }

    public Object getDelegate();

    public static boolean isKeyDown(int key_code) {
        return key_code < 0 ? Mouse.isButtonDown((int)(key_code + 100)) : Keyboard.isKeyDown((int)key_code);
    }

    public static ImmutableSet<Integer> toCmbKeySet(KeyModifier modifier) {
        switch (modifier) {
            case CONTROL: {
                return Minecraft.field_142025_a ? CMB_META : CMB_CTRL;
            }
            case SHIFT: {
                return CMB_SHIFT;
            }
            case ALT: {
                return CMB_ALT;
            }
        }
        return ImmutableSet.of();
    }

    public static KeyModifier toModifier(Set<Integer> cmb_keys) {
        boolean contains_ctrl;
        if (cmb_keys.isEmpty()) {
            return KeyModifier.NONE;
        }
        boolean bl = Minecraft.field_142025_a ? cmb_keys.contains(219) || cmb_keys.contains(220) : (contains_ctrl = cmb_keys.contains(29) || cmb_keys.contains(157));
        if (contains_ctrl) {
            return KeyModifier.CONTROL;
        }
        if (cmb_keys.contains(42) || cmb_keys.contains(54)) {
            return KeyModifier.SHIFT;
        }
        if (cmb_keys.contains(56) || cmb_keys.contains(184)) {
            return KeyModifier.ALT;
        }
        return KeyModifier.NONE;
    }

    public static boolean isShadowKeyBinding(KeyBinding kb) {
        return kb instanceof ShadowKeyBinding;
    }

    public static Optional<KeyBinding> getShadowTarget(KeyBinding kb) {
        if (kb instanceof ShadowKeyBinding) {
            ShadowKeyBinding skb = (ShadowKeyBinding)kb;
            return Optional.of(skb.target);
        }
        return Optional.empty();
    }

    public static Optional<String> getShadowTarget(String description) {
        if (description.startsWith("shadow#")) {
            int suffix = description.indexOf(64);
            return Optional.of(description.substring(7, suffix));
        }
        return Optional.empty();
    }
}

