/*
 * Decompiled with CFR 0.152.
 */
package com.kbp.client.mixin;

import com.google.common.collect.ImmutableSet;
import com.kbp.client.api.IPatchedKeyBinding;
import com.kbp.client.impl.IKeyBindingImpl;
import com.kbp.client.impl.InputSignal;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyModifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyBinding.class})
public abstract class KeyBindingMixin
implements IKeyBindingImpl,
IPatchedKeyBinding {
    @Shadow
    @Final
    private static KeyBindingMap field_74514_b;
    @Shadow
    private boolean field_74513_e;
    @Shadow
    private int field_151474_i;
    @Shadow(remap=false)
    private KeyModifier keyModifierDefault;
    @Shadow(remap=false)
    private KeyModifier keyModifier;
    @Unique
    private boolean is_active;
    @Unique
    private ImmutableSet<Integer> current_cmb_keys;
    @Unique
    private ImmutableSet<Integer> default_cmb_keys;
    @Unique
    private InputSignal input_signal;

    @Shadow
    public abstract int func_151463_i();

    @Shadow
    public abstract void func_151462_b(int var1);

    @Shadow
    public abstract int func_151469_h();

    @Shadow(remap=false)
    public abstract IKeyConflictContext getKeyConflictContext();

    @Unique
    private void __incrActiveCnt() {
        InputSignal signal = this.input_signal;
        ++signal.active_count;
        if (signal.active_count == 1) {
            this.field_74513_e = true;
            signal.press_callbacks.forEach(Runnable::run);
        }
    }

    @Unique
    private void __decrActiveCnt() {
        InputSignal signal = this.input_signal;
        --signal.active_count;
        if (signal.active_count == 0) {
            this.field_74513_e = false;
            signal.release_callbacks.forEach(Runnable::run);
        }
    }

    @Overwrite
    public static void func_74507_a(int key) {
        field_74514_b.lookupAll(key).stream().filter(KeyBinding::func_151470_d).forEachOrdered(kb -> {
            KeyBindingMixin kbm = (KeyBindingMixin)kb;
            KeyBindingMixin delegate = (KeyBindingMixin)kbm.getDelegate();
            ++delegate.field_151474_i;
        });
    }

    @Overwrite
    public static void func_74510_a(int key, boolean is_down) {
        if (!is_down) {
            field_74514_b.lookupAll(key).forEach(kb -> {
                KeyBindingMixin kbm = (KeyBindingMixin)kb;
                kbm.releaseKey();
            });
            return;
        }
        Iterator itr = field_74514_b.lookupAll(key).iterator();
        while (itr.hasNext()) {
            KeyBindingMixin kbm1;
            ImmutableSet<Integer> cmb_keys1;
            int after_priority;
            ImmutableSet<Integer> cmb_keys;
            KeyBindingMixin kbm = (KeyBindingMixin)itr.next();
            IKeyConflictContext ctx = kbm.getKeyConflictContext();
            if (!ctx.isActive() || !(cmb_keys = kbm.getCmbKeys()).stream().allMatch(IKeyBindingImpl::isKeyDown)) continue;
            kbm.pressKey();
            int priority = cmb_keys.size();
            while (itr.hasNext() && (after_priority = (cmb_keys1 = (kbm1 = (KeyBindingMixin)itr.next()).getCmbKeys()).size()) == priority) {
                IKeyConflictContext ctx1 = kbm1.getKeyConflictContext();
                if (!ctx1.isActive() || !cmb_keys1.stream().allMatch(IKeyBindingImpl::isKeyDown)) continue;
                kbm1.pressKey();
            }
            break block0;
        }
    }

    @Inject(method={"<init>(Ljava/lang/String;ILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void onNew(String description, int key_code, String category, CallbackInfo ci) {
        ImmutableSet empty;
        if (!IKeyBindingImpl.isShadowKeyBinding(this.getKeyBinding())) {
            this.input_signal = new InputSignal();
        }
        this.default_cmb_keys = empty = ImmutableSet.of();
        this.current_cmb_keys = empty;
    }

    @Inject(method={"<init>(Ljava/lang/String;Lnet/minecraftforge/client/settings/IKeyConflictContext;Lnet/minecraftforge/client/settings/KeyModifier;ILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void onNew(String description, IKeyConflictContext conflict_context, KeyModifier modifier, int key_code, String category, CallbackInfo ci) {
        this.input_signal = new InputSignal();
        KeyModifier resolved = this.keyModifier;
        ImmutableSet<Integer> cmb_keys = IKeyBindingImpl.toCmbKeySet(resolved);
        if (!cmb_keys.isEmpty()) {
            KeyBinding self = this.getKeyBinding();
            field_74514_b.removeKey(self);
            this.default_cmb_keys = cmb_keys;
            this.current_cmb_keys = cmb_keys;
            field_74514_b.addKey(key_code, self);
        } else {
            this.default_cmb_keys = cmb_keys;
            this.current_cmb_keys = cmb_keys;
        }
    }

    @Overwrite
    private void func_74505_d() {
        KeyBindingMixin delegate = (KeyBindingMixin)this.getDelegate();
        delegate.field_151474_i = Math.max(0, delegate.field_151474_i - 1);
        this.releaseKey();
    }

    @Overwrite(remap=false)
    public boolean isActiveAndMatches(int key_code) {
        return key_code != 0 && key_code == this.func_151463_i() && this.getCmbKeys().stream().allMatch(IKeyBindingImpl::isKeyDown) && this.getKeyConflictContext().isActive();
    }

    @Overwrite(remap=false)
    public void setKeyModifierAndCode(KeyModifier modifier, int key_code) {
        KeyModifier resolved = modifier.matches(key_code) ? KeyModifier.NONE : modifier;
        this.setKeyAndCmbKeys(key_code, IKeyBindingImpl.toCmbKeySet(resolved));
    }

    @Overwrite(remap=false)
    public void setToDefault() {
        this.setKeyAndCmbKeys(this.func_151469_h(), this.getDefaultCmbKeys());
    }

    @Overwrite(remap=false)
    public boolean isSetToDefaultValue() {
        return this.func_151463_i() == this.func_151469_h() && this.getCmbKeys().equals(this.getDefaultCmbKeys());
    }

    @Overwrite(remap=false)
    public boolean conflicts(KeyBinding other) {
        IKeyConflictContext ctx1;
        boolean is_ctx_conflict;
        IKeyConflictContext ctx0 = this.getKeyConflictContext();
        boolean bl = is_ctx_conflict = ctx0.conflicts(ctx1 = other.getKeyConflictContext()) || ctx1.conflicts(ctx0);
        if (!is_ctx_conflict) {
            return false;
        }
        KeyBindingMixin okbm = (KeyBindingMixin)other;
        ImmutableSet<Integer> cmb0 = this.getCmbKeys();
        ImmutableSet<Integer> cmb1 = okbm.getCmbKeys();
        int key0 = this.func_151463_i();
        int key1 = other.func_151463_i();
        return cmb0.contains((Object)key1) || cmb1.contains((Object)key0) || key0 == key1 && cmb0.equals(cmb1);
    }

    @Overwrite(remap=false)
    public boolean hasKeyCodeModifierConflict(KeyBinding other) {
        IKeyConflictContext ctx1;
        boolean is_ctx_conflict;
        IKeyConflictContext ctx0 = this.getKeyConflictContext();
        boolean bl = is_ctx_conflict = ctx0.conflicts(ctx1 = other.getKeyConflictContext()) || ctx1.conflicts(ctx0);
        if (!is_ctx_conflict) {
            return false;
        }
        KeyBindingMixin okbm = (KeyBindingMixin)other;
        ImmutableSet<Integer> cmb0 = this.getCmbKeys();
        ImmutableSet<Integer> cmb1 = okbm.getCmbKeys();
        int key0 = this.func_151463_i();
        int key1 = other.func_151463_i();
        return cmb0.contains((Object)key1) || cmb1.contains((Object)key0);
    }

    @Overwrite(remap=false)
    public String getDisplayName() {
        return Stream.concat(this.getCmbKeys().stream(), Stream.of(Integer.valueOf(this.func_151463_i()))).map(GameSettings::func_74298_c).collect(Collectors.joining(" + "));
    }

    @Override
    public void pressKey() {
        if (!this.is_active) {
            this.is_active = true;
            KeyBindingMixin delegate = (KeyBindingMixin)this.getDelegate();
            delegate.__incrActiveCnt();
        }
    }

    @Override
    public void releaseKey() {
        if (this.is_active) {
            this.is_active = false;
            KeyBindingMixin delegate = (KeyBindingMixin)this.getDelegate();
            delegate.__decrActiveCnt();
        }
    }

    @Override
    public final void initDefaultCmbKeys(ImmutableSet<Integer> cmb_keys) {
        if (!cmb_keys.isEmpty()) {
            KeyModifier modifier;
            assert (!cmb_keys.contains((Object)this.func_151463_i()));
            KeyBinding self = this.getKeyBinding();
            field_74514_b.removeKey(self);
            this.default_cmb_keys = cmb_keys;
            this.current_cmb_keys = cmb_keys;
            this.keyModifierDefault = modifier = IKeyBindingImpl.toModifier(cmb_keys);
            this.keyModifier = modifier;
            field_74514_b.addKey(self.func_151463_i(), self);
        }
    }

    @Override
    public Object getDelegate() {
        return this;
    }

    @Override
    public ImmutableSet<Integer> getDefaultCmbKeys() {
        return this.default_cmb_keys;
    }

    @Override
    public ImmutableSet<Integer> getCmbKeys() {
        return this.current_cmb_keys;
    }

    @Override
    public void setKeyAndCmbKeys(int key, ImmutableSet<Integer> cmb_keys) {
        assert (!cmb_keys.contains((Object)key));
        this.func_151462_b(key);
        this.current_cmb_keys = cmb_keys;
        this.keyModifier = IKeyBindingImpl.toModifier(cmb_keys);
    }

    @Override
    public void addPressCallback(Runnable callback) {
        this.input_signal.press_callbacks.add(callback);
    }

    @Override
    public boolean removePressCallback(Runnable callback) {
        return this.input_signal.press_callbacks.remove(callback);
    }

    @Override
    public void addReleaseCallback(Runnable callback) {
        this.input_signal.release_callbacks.add(callback);
    }

    @Override
    public boolean removeReleaseCallback(Runnable callback) {
        return this.input_signal.release_callbacks.remove(callback);
    }

    @Override
    public final KeyBinding getKeyBinding() {
        return (KeyBinding)this;
    }
}

