/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.IJsonSerializable;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.drawable.text.AnimatedText;
import com.cleanroommc.modularui.drawable.text.CompoundKey;
import com.cleanroommc.modularui.drawable.text.DynamicKey;
import com.cleanroommc.modularui.drawable.text.FormattingState;
import com.cleanroommc.modularui.drawable.text.KeyIcon;
import com.cleanroommc.modularui.drawable.text.LangKey;
import com.cleanroommc.modularui.drawable.text.StringKey;
import com.cleanroommc.modularui.drawable.text.StyledText;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.google.gson.JsonObject;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IKey
extends IDrawable,
IJsonSerializable {
    public static final int TEXT_COLOR = -12566464;
    public static final TextRenderer renderer = new TextRenderer();
    public static final IKey EMPTY = IKey.str("");
    public static final IKey LINE_FEED = IKey.str("\n");
    public static final IKey SPACE = IKey.str(" ");
    public static final TextFormatting BLACK = TextFormatting.BLACK;
    public static final TextFormatting DARK_BLUE = TextFormatting.DARK_BLUE;
    public static final TextFormatting DARK_GREEN = TextFormatting.DARK_GREEN;
    public static final TextFormatting DARK_AQUA = TextFormatting.DARK_AQUA;
    public static final TextFormatting DARK_RED = TextFormatting.DARK_RED;
    public static final TextFormatting DARK_PURPLE = TextFormatting.DARK_PURPLE;
    public static final TextFormatting GOLD = TextFormatting.GOLD;
    public static final TextFormatting GRAY = TextFormatting.GRAY;
    public static final TextFormatting DARK_GRAY = TextFormatting.DARK_GRAY;
    public static final TextFormatting BLUE = TextFormatting.BLUE;
    public static final TextFormatting GREEN = TextFormatting.GREEN;
    public static final TextFormatting AQUA = TextFormatting.AQUA;
    public static final TextFormatting RED = TextFormatting.RED;
    public static final TextFormatting LIGHT_PURPLE = TextFormatting.LIGHT_PURPLE;
    public static final TextFormatting YELLOW = TextFormatting.YELLOW;
    public static final TextFormatting WHITE = TextFormatting.WHITE;
    public static final TextFormatting OBFUSCATED = TextFormatting.OBFUSCATED;
    public static final TextFormatting BOLD = TextFormatting.BOLD;
    public static final TextFormatting STRIKETHROUGH = TextFormatting.STRIKETHROUGH;
    public static final TextFormatting UNDERLINE = TextFormatting.UNDERLINE;
    public static final TextFormatting ITALIC = TextFormatting.ITALIC;
    public static final TextFormatting RESET = TextFormatting.RESET;

    public static IKey lang(@NotNull String key) {
        return new LangKey(key);
    }

    public static IKey lang(@NotNull String key, Object ... args) {
        return new LangKey(key, args);
    }

    public static IKey lang(@NotNull String key, @NotNull Supplier<Object[]> argsSupplier) {
        return new LangKey(key, argsSupplier);
    }

    public static IKey lang(@NotNull Supplier<String> keySupplier) {
        return new LangKey(keySupplier);
    }

    public static IKey lang(@NotNull Supplier<String> keySupplier, @NotNull Supplier<Object[]> argsSupplier) {
        return new LangKey(keySupplier, argsSupplier);
    }

    public static IKey str(@NotNull String key) {
        return new StringKey(key);
    }

    public static IKey str(@NotNull String key, Object ... args) {
        return new StringKey(key, args);
    }

    @Deprecated
    public static IKey format(@NotNull String key, Object ... args) {
        return IKey.str(key, args);
    }

    public static IKey comp(IKey ... keys) {
        return new CompoundKey(keys);
    }

    public static IKey dynamic(@NotNull @NotNull Supplier<@NotNull String> getter) {
        return new DynamicKey(getter);
    }

    public String get();

    default public String getFormatted(@Nullable FormattingState parentFormatting) {
        return this.get();
    }

    default public String getFormatted() {
        return this.getFormatted(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        renderer.setColor(widgetTheme.getTextColor());
        renderer.setShadow(widgetTheme.getTextShadow());
        renderer.setAlignment(Alignment.Center, width, height);
        renderer.setScale(1.0f);
        renderer.setPos(x, y);
        renderer.draw(this.getFormatted());
    }

    @Override
    default public boolean canApplyTheme() {
        return true;
    }

    default public TextWidget<?> asWidget() {
        return new TextWidget(this);
    }

    default public StyledText withStyle() {
        return new StyledText(this);
    }

    default public AnimatedText withAnimation() {
        return new AnimatedText(this);
    }

    @Nullable
    default public FormattingState getFormatting() {
        return null;
    }

    public IKey style(@Nullable TextFormatting var1);

    default public IKey style(TextFormatting ... formatting) {
        for (TextFormatting tf : formatting) {
            this.style(tf);
        }
        return this;
    }

    default public IKey removeFormatColor() {
        return this.style((TextFormatting)null);
    }

    public IKey removeStyle();

    default public StyledText alignment(Alignment alignment) {
        return this.withStyle().alignment(alignment);
    }

    default public StyledText color(int color) {
        return this.withStyle().color(() -> color);
    }

    default public StyledText color(@Nullable IntSupplier color) {
        return this.withStyle().color(color);
    }

    default public StyledText scale(float scale) {
        return this.withStyle().scale(scale);
    }

    default public StyledText shadow(@Nullable Boolean shadow) {
        return this.withStyle().shadow(shadow);
    }

    @Override
    default public Icon asIcon() {
        return new Icon(this);
    }

    default public KeyIcon asTextIcon() {
        return new KeyIcon(this);
    }

    @Override
    default public void loadFromJson(JsonObject json) {
        if (json.has("color") || json.has("shadow") || json.has("align") || json.has("alignment") || json.has("scale")) {
            StyledText styledText1;
            StyledText styledText;
            IKey iKey = this;
            StyledText styledText2 = styledText = iKey instanceof StyledText ? (styledText1 = (StyledText)iKey) : this.withStyle();
            if (json.has("color")) {
                styledText.color(JsonHelper.getInt(json, 0, "color"));
            }
            styledText.shadow(JsonHelper.getBoolean(json, false, "shadow"));
            styledText.alignment(JsonHelper.deserialize(json, Alignment.class, styledText.getAlignment(), "align", "alignment"));
            styledText.scale(JsonHelper.getFloat(json, 1.0f, "scale"));
        }
    }
}

