/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.IJsonSerializable;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.AdaptableUITexture;
import com.cleanroommc.modularui.drawable.ColorType;
import com.cleanroommc.modularui.drawable.DrawableSerialization;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.TiledUITexture;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.Interpolations;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class UITexture
implements IDrawable,
IJsonSerializable {
    public static final UITexture DEFAULT = UITexture.fullImage("gui/options_background", ColorType.DEFAULT);
    private static final ResourceLocation ICONS_LOCATION = new ResourceLocation("modularui", "textures/gui/icons.png");
    private static final String TEXTURES_PREFIX = "textures/";
    private static final String PNG_SUFFIX = ".png";
    public final ResourceLocation location;
    public final float u0;
    public final float v0;
    public final float u1;
    public final float v1;
    @Nullable
    public final ColorType colorType;
    private static int defaultImageWidth = 16;
    private static int defaultImageHeight = 16;

    static UITexture icon(String name, int x, int y, int w, int h) {
        return UITexture.builder().location(ICONS_LOCATION).imageSize(256, 256).xy(x, y, w, h).iconColorType().name(name).build();
    }

    static UITexture icon(String name, int x, int y) {
        return UITexture.icon(name, x, y, 16, 16);
    }

    public UITexture(ResourceLocation location, float u0, float v0, float u1, float v1, @Nullable ColorType colorType) {
        boolean textures;
        this.colorType = colorType;
        boolean png = !location.func_110623_a().endsWith(PNG_SUFFIX);
        boolean bl = textures = !location.func_110623_a().startsWith(TEXTURES_PREFIX);
        if (png || textures) {
            String path = location.func_110623_a();
            path = png ? (textures ? TEXTURES_PREFIX + path + PNG_SUFFIX : path + PNG_SUFFIX) : TEXTURES_PREFIX + path;
            location = new ResourceLocation(location.func_110624_b(), path);
        }
        this.location = location;
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UITexture fullImage(ResourceLocation location) {
        return new UITexture(location, 0.0f, 0.0f, 1.0f, 1.0f, null);
    }

    public static UITexture fullImage(String location) {
        return UITexture.fullImage(new ResourceLocation(location), null);
    }

    public static UITexture fullImage(String mod, String location) {
        return UITexture.fullImage(new ResourceLocation(mod, location), null);
    }

    public static UITexture fullImage(ResourceLocation location, ColorType colorType) {
        return new UITexture(location, 0.0f, 0.0f, 1.0f, 1.0f, colorType);
    }

    public static UITexture fullImage(String location, ColorType colorType) {
        return UITexture.fullImage(new ResourceLocation(location), colorType);
    }

    public static UITexture fullImage(String mod, String location, ColorType colorType) {
        return UITexture.fullImage(new ResourceLocation(mod, location), colorType);
    }

    public UITexture getSubArea(Area bounds) {
        return this.getSubArea(bounds.x, bounds.y, bounds.ex(), bounds.ey());
    }

    public UITexture getSubArea(float uStart, float vStart, float uEnd, float vEnd) {
        return new UITexture(this.location, this.lerpU(uStart), this.lerpV(vStart), this.lerpU(uEnd), this.lerpV(vEnd), this.colorType);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    protected final float lerpU(float u) {
        return Interpolations.lerp(this.u0, this.u1, u);
    }

    protected final float lerpV(float v) {
        return Interpolations.lerp(this.v0, this.v1, v);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.applyColor(this.colorType != null ? this.colorType.getColor(widgetTheme) : ColorType.DEFAULT.getColor(widgetTheme));
        this.draw(x, y, width, height);
    }

    public void draw(float x, float y, float width, float height) {
        GuiDraw.drawTexture(this.location, x, y, x + width, y + height, this.u0, this.v0, this.u1, this.v1);
    }

    @Deprecated
    public void drawSubArea(float x, float y, float width, float height, float uStart, float vStart, float uEnd, float vEnd) {
        this.drawSubArea(x, y, width, height, uStart, vStart, uEnd, vEnd, WidgetTheme.getDefault().getTheme());
    }

    public void drawSubArea(float x, float y, float width, float height, float uStart, float vStart, float uEnd, float vEnd, WidgetTheme widgetTheme) {
        if (this.canApplyTheme()) {
            Color.setGlColor(widgetTheme.getColor());
        } else {
            Color.setGlColorOpaque(Color.WHITE.main);
        }
        GuiDraw.drawTexture(this.location, x, y, x + width, y + height, this.lerpU(uStart), this.lerpV(vStart), this.lerpU(uEnd), this.lerpV(vEnd));
    }

    @Override
    public boolean canApplyTheme() {
        return this.colorType != null;
    }

    public static UITexture parseFromJson(JsonObject json) {
        String colorTypeName;
        boolean mode2;
        UITexture drawable;
        String name = JsonHelper.getString(json, null, "name", "id");
        if (name != null && (drawable = DrawableSerialization.getTexture(name)) != null) {
            return drawable;
        }
        Builder builder = UITexture.builder();
        builder.location(JsonHelper.getString(json, "modularui:gui/widgets/error", "location")).imageSize(JsonHelper.getInt(json, defaultImageWidth, "imageWidth", "iw"), JsonHelper.getInt(json, defaultImageHeight, "imageHeight", "ih"));
        boolean mode1 = json.has("x") || json.has("y") || json.has("w") || json.has("h") || json.has("width") || json.has("height");
        boolean bl = mode2 = json.has("u0") || json.has("v0") || json.has("u1") || json.has("u1");
        if (mode1) {
            if (mode2) {
                throw new JsonParseException("Tried to specify x, y, w, h and u0, v0, u1, v1!");
            }
            builder.xy(JsonHelper.getInt(json, 0, "x"), JsonHelper.getInt(json, 0, "y"), JsonHelper.getInt(json, builder.iw, "w", "width"), JsonHelper.getInt(json, builder.ih, "h", "height"));
        } else if (mode2) {
            builder.uv(JsonHelper.getFloat(json, 0.0f, "u0"), JsonHelper.getFloat(json, 0.0f, "v0"), JsonHelper.getFloat(json, 1.0f, "u1"), JsonHelper.getFloat(json, 1.0f, "v1"));
        }
        int bl2 = JsonHelper.getInt(json, 0, "bl", "borderLeft", "borderX", "border");
        int br = JsonHelper.getInt(json, 0, "br", "borderRight", "borderY", "border");
        int bt = JsonHelper.getInt(json, 0, "bt", "borderTop", "borderBottom", "border");
        int bb = JsonHelper.getInt(json, 0, "bb", "borderBottom", "borderTop", "border");
        if (bl2 > 0 || br > 0 || bt > 0 || bb > 0) {
            builder.adaptable(bl2, bt, br, bb);
        }
        if (JsonHelper.getBoolean(json, false, "tiled")) {
            builder.tiled();
        }
        if ((colorTypeName = JsonHelper.getString(json, null, "colorType", "color")) != null) {
            builder.colorType(ColorType.get(colorTypeName));
        } else if (JsonHelper.getBoolean(json, false, "canApplyTheme")) {
            builder.canApplyTheme();
        }
        return builder.build();
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        String name = DrawableSerialization.getTextureId(this);
        if (name != null) {
            json.addProperty("id", name);
            return true;
        }
        json.addProperty("location", this.location.toString());
        json.addProperty("u0", (Number)Float.valueOf(this.u0));
        json.addProperty("v0", (Number)Float.valueOf(this.v0));
        json.addProperty("u1", (Number)Float.valueOf(this.u1));
        json.addProperty("v1", (Number)Float.valueOf(this.v1));
        if (this.colorType != null) {
            json.addProperty("colorType", this.colorType.getName());
        }
        return true;
    }

    public static void setDefaultImageSize(int w, int h) {
        defaultImageWidth = w;
        defaultImageHeight = h;
    }

    static /* synthetic */ int access$200() {
        return defaultImageWidth;
    }

    static /* synthetic */ int access$300() {
        return defaultImageHeight;
    }

    public static class Builder {
        private ResourceLocation location;
        private int iw = UITexture.access$200();
        private int ih = UITexture.access$300();
        private int x;
        private int y;
        private int w;
        private int h;
        private float u0 = 0.0f;
        private float v0 = 0.0f;
        private float u1 = 1.0f;
        private float v1 = 1.0f;
        private Mode mode = Mode.FULL;
        private int bl = 0;
        private int bt = 0;
        private int br = 0;
        private int bb = 0;
        private String name;
        private boolean tiled = false;
        private ColorType colorType = null;

        public Builder location(ResourceLocation loc) {
            this.location = loc;
            return this;
        }

        public Builder location(String mod, String path) {
            this.location = new ResourceLocation(mod, path);
            return this;
        }

        public Builder location(String path) {
            this.location = new ResourceLocation(path);
            return this;
        }

        public Builder imageSize(int w, int h) {
            this.iw = w;
            this.ih = h;
            return this;
        }

        public Builder tiled(int imageWidth, int imageHeight) {
            return this.tiled().imageSize(imageWidth, imageHeight);
        }

        public Builder tiled() {
            this.tiled = true;
            return this;
        }

        public Builder fullImage() {
            this.mode = Mode.FULL;
            return this;
        }

        public Builder xy(int x, int y, int w, int h) {
            this.mode = Mode.PIXEL;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder uv(float u0, float v0, float u1, float v1) {
            this.mode = Mode.RELATIVE;
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public Builder adaptable(int bl, int bt, int br, int bb) {
            this.bl = bl;
            this.bt = bt;
            this.br = br;
            this.bb = bb;
            return this;
        }

        public Builder adaptable(int borderX, int borderY) {
            return this.adaptable(borderX, borderY, borderX, borderY);
        }

        public Builder adaptable(int border) {
            return this.adaptable(border, border);
        }

        public Builder canApplyTheme() {
            return this.defaultColorType();
        }

        public Builder colorType(@Nullable ColorType colorType) {
            this.colorType = colorType;
            return this;
        }

        public Builder defaultColorType() {
            return this.colorType(ColorType.DEFAULT);
        }

        public Builder textColorType() {
            return this.colorType(ColorType.TEXT);
        }

        public Builder iconColorType() {
            return this.colorType(ColorType.ICON);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public UITexture build() {
            UITexture texture = this.create();
            if (this.name == null) {
                String[] p = texture.location.func_110623_a().split("/");
                p = p[p.length - 1].split("\\.");
                String string = this.name = texture.location.func_110624_b().equals("modularui") ? p[0] : texture.location.func_110624_b() + ":" + p[0];
                if (DrawableSerialization.getTexture(this.name) != null) {
                    return texture;
                }
            }
            DrawableSerialization.registerTexture(this.name, texture);
            return texture;
        }

        private UITexture create() {
            if (this.location == null) {
                throw new NullPointerException("Location must not be null");
            }
            if (this.iw <= 0 || this.ih <= 0) {
                throw new IllegalArgumentException("Image size must be > 0");
            }
            if (this.mode == Mode.FULL) {
                this.u0 = 0.0f;
                this.v0 = 0.0f;
                this.u1 = 1.0f;
                this.v1 = 1.0f;
                this.mode = Mode.RELATIVE;
            } else if (this.mode == Mode.PIXEL) {
                float tw = 1.0f / (float)this.iw;
                float th = 1.0f / (float)this.ih;
                this.u0 = (float)this.x * tw;
                this.v0 = (float)this.y * th;
                this.u1 = (float)(this.x + this.w) * tw;
                this.v1 = (float)(this.y + this.h) * th;
                this.mode = Mode.RELATIVE;
            }
            if (this.mode == Mode.RELATIVE) {
                if (this.u0 < 0.0f || this.v0 < 0.0f || this.u1 > 1.0f || this.v1 > 1.0f) {
                    throw new IllegalArgumentException("UV values must be 0 - 1");
                }
                if (this.bl > 0 || this.bt > 0 || this.br > 0 || this.bb > 0) {
                    return new AdaptableUITexture(this.location, this.u0, this.v0, this.u1, this.v1, this.colorType, this.iw, this.ih, this.bl, this.bt, this.br, this.bb, this.tiled);
                }
                if (this.tiled) {
                    return new TiledUITexture(this.location, this.u0, this.v0, this.u1, this.v1, this.iw, this.ih, this.colorType);
                }
                return new UITexture(this.location, this.u0, this.v0, this.u1, this.v1, this.colorType);
            }
            throw new IllegalStateException();
        }
    }

    private static enum Mode {
        FULL,
        PIXEL,
        RELATIVE;

    }
}

