/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.EntityGuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class EntityGuiFactory
extends AbstractUIFactory<EntityGuiData> {
    public static EntityGuiFactory INSTANCE = new EntityGuiFactory();

    protected EntityGuiFactory() {
        super("mui:entity");
    }

    public <E extends Entity> void open(EntityPlayer player, E entity) {
        Objects.requireNonNull(player);
        EntityGuiFactory.verifyEntity(player, entity);
        GuiManager.open(this, new EntityGuiData(player, entity), (EntityPlayerMP)player);
    }

    private static <E extends Entity> void verifyEntity(EntityPlayer player, E entity) {
        Objects.requireNonNull(entity);
        if (!entity.func_70089_S()) {
            throw new IllegalArgumentException("Can't open dead Entity GUI!");
        }
        if (player.field_70170_p != entity.field_70170_p) {
            throw new IllegalArgumentException("Entity must be in same dimension as the player!");
        }
    }

    @Override
    @NotNull
    public IGuiHolder<EntityGuiData> getGuiHolder(EntityGuiData guiData) {
        return Objects.requireNonNull(this.castGuiHolder(guiData.getGuiHolder()), "Found Entity is not a gui holder!");
    }

    @Override
    public void writeGuiData(EntityGuiData guiData, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(guiData.getGuiHolder().func_145782_y());
    }

    @Override
    @NotNull
    public EntityGuiData readGuiData(EntityPlayer entityPlayer, PacketBuffer packetBuffer) {
        return new EntityGuiData(entityPlayer, entityPlayer.field_70170_p.func_73045_a(packetBuffer.readInt()));
    }

    @Override
    public boolean canInteractWith(EntityPlayer player, EntityGuiData guiData) {
        Entity guiHolder = guiData.getGuiHolder();
        return super.canInteractWith(player, guiData) && guiHolder != null && player.func_70092_e(guiHolder.field_70165_t, guiHolder.field_70163_u, guiHolder.field_70161_v) <= 64.0 && player.field_70170_p == guiHolder.field_70170_p && guiHolder.func_70089_S();
    }
}

