/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.EntityGuiFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.ItemGuiFactory;
import com.cleanroommc.modularui.factory.PlayerInventoryGuiFactory;
import com.cleanroommc.modularui.factory.SidedTileEntityGuiFactory;
import com.cleanroommc.modularui.factory.SimpleGuiFactory;
import com.cleanroommc.modularui.factory.TileEntityGuiFactory;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public class GuiFactories {
    public static TileEntityGuiFactory tileEntity() {
        return TileEntityGuiFactory.INSTANCE;
    }

    public static SidedTileEntityGuiFactory sidedTileEntity() {
        return SidedTileEntityGuiFactory.INSTANCE;
    }

    public static EntityGuiFactory entity() {
        return EntityGuiFactory.INSTANCE;
    }

    @Deprecated
    public static ItemGuiFactory item() {
        return ItemGuiFactory.INSTANCE;
    }

    public static PlayerInventoryGuiFactory playerInventory() {
        return PlayerInventoryGuiFactory.INSTANCE;
    }

    public static SimpleGuiFactory createSimple(String name, IGuiHolder<GuiData> holder) {
        return new SimpleGuiFactory(name, holder);
    }

    public static SimpleGuiFactory createSimple(String name, Supplier<IGuiHolder<GuiData>> holder) {
        return new SimpleGuiFactory(name, holder);
    }

    @ApiStatus.Internal
    public static void init() {
        GuiManager.registerFactory(GuiFactories.tileEntity());
        GuiManager.registerFactory(GuiFactories.sidedTileEntity());
        GuiManager.registerFactory(GuiFactories.entity());
        GuiManager.registerFactory(GuiFactories.item());
        GuiManager.registerFactory(GuiFactories.playerInventory());
    }

    private GuiFactories() {
    }
}

