/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.PlayerInventoryGuiData;
import com.cleanroommc.modularui.factory.inventory.InventoryType;
import com.cleanroommc.modularui.factory.inventory.InventoryTypes;
import com.cleanroommc.modularui.utils.Platform;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class PlayerInventoryGuiFactory
extends AbstractUIFactory<PlayerInventoryGuiData> {
    public static final PlayerInventoryGuiFactory INSTANCE = new PlayerInventoryGuiFactory();

    public void openFromPlayerInventory(EntityPlayer player, int index) {
        GuiManager.open(this, new PlayerInventoryGuiData(player, InventoryTypes.PLAYER, index), PlayerInventoryGuiFactory.verifyServerSide(player));
    }

    public void openFromHand(EntityPlayer player, EnumHand hand) {
        this.openFromPlayerInventory(player, hand == EnumHand.OFF_HAND ? 40 : player.field_71071_by.field_70461_c);
    }

    public void openFromBaubles(EntityPlayer player, int index) {
        if (!ModularUI.Mods.BAUBLES.isLoaded()) {
            throw new IllegalArgumentException("Can't open UI for baubles item when bauble is not loaded!");
        }
        GuiManager.open(this, new PlayerInventoryGuiData(player, InventoryTypes.BAUBLES, index), PlayerInventoryGuiFactory.verifyServerSide(player));
    }

    public void open(EntityPlayer player, InventoryType type, int index) {
        GuiManager.open(this, new PlayerInventoryGuiData(player, type, index), PlayerInventoryGuiFactory.verifyServerSide(player));
    }

    @SideOnly(value=Side.CLIENT)
    public void openFromPlayerInventoryClient(int index) {
        GuiManager.openFromClient(this, new PlayerInventoryGuiData((EntityPlayer)Platform.getClientPlayer(), InventoryTypes.PLAYER, index));
    }

    @SideOnly(value=Side.CLIENT)
    public void openFromHandClient(EnumHand hand) {
        this.openFromPlayerInventoryClient(hand == EnumHand.OFF_HAND ? 40 : Platform.getClientPlayer().field_71071_by.field_70461_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void openFromBaublesClient(int index) {
        if (!ModularUI.Mods.BAUBLES.isLoaded()) {
            throw new IllegalArgumentException("Can't open UI for baubles item when bauble is not loaded!");
        }
        GuiManager.openFromClient(this, new PlayerInventoryGuiData((EntityPlayer)Platform.getClientPlayer(), InventoryTypes.BAUBLES, index));
    }

    @SideOnly(value=Side.CLIENT)
    public void openClient(InventoryType type, int index) {
        GuiManager.openFromClient(this, new PlayerInventoryGuiData((EntityPlayer)Platform.getClientPlayer(), type, index));
    }

    private PlayerInventoryGuiFactory() {
        super("mui:player_inv");
    }

    @Override
    @NotNull
    public IGuiHolder<PlayerInventoryGuiData> getGuiHolder(PlayerInventoryGuiData data) {
        return Objects.requireNonNull(this.castGuiHolder(data.getUsedItemStack().func_77973_b()), "Item was not a gui holder!");
    }

    @Override
    public void writeGuiData(PlayerInventoryGuiData guiData, PacketBuffer buffer) {
        guiData.getInventoryType().write(buffer);
        buffer.func_150787_b(guiData.getSlotIndex());
    }

    @Override
    @NotNull
    public PlayerInventoryGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new PlayerInventoryGuiData(player, InventoryType.read(buffer), buffer.func_150792_a());
    }
}

