/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.network.packets;

import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.network.IPacket;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class OpenGuiPacket<T extends GuiData>
implements IPacket {
    private int windowId;
    private UIFactory<T> factory;
    private PacketBuffer data;

    public OpenGuiPacket() {
    }

    public OpenGuiPacket(int windowId, UIFactory<T> factory, PacketBuffer data) {
        this.windowId = windowId;
        this.factory = factory;
        this.data = data;
    }

    @Override
    public void write(PacketBuffer buf) throws IOException {
        buf.func_150787_b(this.windowId);
        buf.func_180714_a(this.factory.getFactoryName());
        NetworkUtils.writeByteBuf(buf, (ByteBuf)this.data);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.windowId = buf.func_150792_a();
        this.factory = GuiManager.getFactory(buf.func_150789_c(32));
        this.data = NetworkUtils.readPacketBuffer(buf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public IPacket executeClient(NetHandlerPlayClient handler) {
        GuiManager.openFromClient(this.windowId, this.factory, this.data, Platform.getClientPlayer());
        return null;
    }

    @Override
    @Nullable
    public IPacket executeServer(NetHandlerPlayServer handler) {
        T guiData = this.factory.readGuiData((EntityPlayer)handler.field_147369_b, this.data);
        GuiManager.open(this.factory, guiData, handler.field_147369_b);
        return null;
    }
}

