/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.bogosorter.api.IPosSetter;
import com.cleanroommc.bogosorter.api.ISortableContainer;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.core.mixins.early.minecraft.ContainerAccessor;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEAAnimationHandler;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(modid="bogosorter", iface="com.cleanroommc.bogosorter.api.ISortableContainer")
public class ModularContainer
extends Container
implements ISortableContainer {
    private static final int DROP_TO_WORLD = -999;
    private static final int LEFT_MOUSE = 0;
    private static final int RIGHT_MOUSE = 1;
    private EntityPlayer player;
    private ModularSyncManager syncManager;
    private boolean init = true;
    private final List<ModularSlot> phantomSlots = new ArrayList<ModularSlot>();
    private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();
    private GuiData guiData;
    private UISettings settings;
    @SideOnly(value=Side.CLIENT)
    private ModularScreen optionalScreen;

    public static ModularContainer getCurrent(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ModularContainer) {
            ModularContainer container2 = (ModularContainer)container;
            return container2;
        }
        return null;
    }

    @ApiStatus.Internal
    public void construct(EntityPlayer player, PanelSyncManager panelSyncManager, UISettings settings, String mainPanelName, GuiData guiData) {
        this.player = player;
        this.syncManager = new ModularSyncManager(this);
        this.syncManager.construct(mainPanelName, panelSyncManager);
        this.settings = settings;
        this.guiData = guiData;
        this.sortShiftClickSlots();
    }

    @SideOnly(value=Side.CLIENT)
    void initializeClient(ModularScreen screen) {
        this.optionalScreen = screen;
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public void constructClientOnly() {
        this.player = Platform.getClientPlayer();
        this.syncManager = null;
    }

    public boolean isInitialized() {
        return this.player != null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModularScreen getScreen() {
        if (this.optionalScreen == null) {
            throw new NullPointerException("ModularScreen is not yet initialised!");
        }
        return this.optionalScreen;
    }

    public ContainerAccessor acc() {
        return (ContainerAccessor)((Object)this);
    }

    @MustBeInvokedByOverriders
    public void func_75134_a(@NotNull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.syncManager != null) {
            this.syncManager.onClose();
        }
    }

    @MustBeInvokedByOverriders
    public void func_75142_b() {
        super.func_75142_b();
        if (this.syncManager != null) {
            this.syncManager.detectAndSendChanges(this.init);
        }
        this.init = false;
    }

    @ApiStatus.Internal
    public void onUpdate() {
        if (this.syncManager != null) {
            this.syncManager.onUpdate();
        }
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(Comparator.comparingInt(slot -> Objects.requireNonNull(slot.getSlotGroup()).getShiftClickPriority()));
    }

    public void func_190896_a(@NotNull List<ItemStack> items) {
        if (this.field_75151_b.size() != items.size()) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", (Object)this.field_75151_b.size(), (Object)items.size());
        }
        for (int i = 0; i < Math.min(this.field_75151_b.size(), items.size()); ++i) {
            this.func_75139_a(i).func_75215_d(items.get(i));
        }
    }

    @ApiStatus.Internal
    public void registerSlot(String panelName, ModularSlot slot) {
        SlotGroup slotGroup;
        if (slot.isPhantom()) {
            if (this.phantomSlots.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.phantomSlots.add(slot);
        } else {
            if (this.field_75151_b.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.func_75146_a((Slot)slot);
        }
        if (slot.getSlotGroupName() != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slot.getSlotGroupName());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + slot.getSlotGroupName() + "' is not registered!"));
                return;
            }
            slot.slotGroup(slotGroup);
        }
        if (slot.getSlotGroup() != null && (slotGroup = slot.getSlotGroup()).allowShiftTransfer()) {
            this.shiftClickSlots.add(slot);
            if (!this.init) {
                this.sortShiftClickSlots();
            }
        }
    }

    @Contract(value="_, null, null -> fail")
    @NotNull
    @ApiStatus.Internal
    public SlotGroup validateSlotGroup(String panelName, @Nullable String slotGroupName, @Nullable SlotGroup slotGroup) {
        if (slotGroup != null) {
            if (this.getSyncManager().getSlotGroup(panelName, slotGroup.getName()) == null) {
                throw new IllegalArgumentException("Slot group is not registered in the GUI.");
            }
            return slotGroup;
        }
        if (slotGroupName != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slotGroupName);
            if (slotGroup == null) {
                throw new IllegalArgumentException("Can't find slot group for name " + slotGroupName);
            }
            return slotGroup;
        }
        throw new IllegalArgumentException("Either the slot group or the name must not be null!");
    }

    public ModularSyncManager getSyncManager() {
        if (this.syncManager == null) {
            throw new IllegalStateException("GuiSyncManager is not available for client only GUI's.");
        }
        return this.syncManager;
    }

    public boolean isClient() {
        return this.syncManager == null || NetworkUtils.isClient(this.player);
    }

    public boolean isClientOnly() {
        return this.syncManager == null;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public GuiData getGuiData() {
        return this.guiData;
    }

    public ModularSlot getModularSlot(int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot instanceof ModularSlot) {
            ModularSlot modularSlot = (ModularSlot)slot;
            return modularSlot;
        }
        throw new IllegalStateException("A non-ModularSlot was found, but all slots in a ModularContainer must extend ModularSlot.");
    }

    public List<ModularSlot> getShiftClickSlots() {
        return Collections.unmodifiableList(this.shiftClickSlots);
    }

    public void onSlotChanged(ModularSlot slot, ItemStack stack, boolean onlyAmountChanged) {
    }

    public boolean func_75145_c(@NotNull EntityPlayer playerIn) {
        return this.settings.canPlayerInteractWithUI(playerIn);
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        ItemStack returnable = Platform.EMPTY_STACK;
        InventoryPlayer inventoryplayer = player.field_71071_by;
        if (clickTypeIn == ClickType.QUICK_CRAFT || this.acc().getDragEvent() != 0) {
            return this.superSlotClick(slotId, mouseButton, clickTypeIn, player);
        }
        if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                return this.superSlotClick(slotId, mouseButton, clickTypeIn, player);
            }
            if (slotId < 0) {
                return Platform.EMPTY_STACK;
            }
            if (clickTypeIn == ClickType.QUICK_MOVE) {
                Slot fromSlot = this.func_75139_a(slotId);
                if (!fromSlot.func_82869_a(player)) {
                    return Platform.EMPTY_STACK;
                }
                returnable = NEAAnimationHandler.shouldHandleNEA(this) ? NEAAnimationHandler.injectQuickMove(this, player, slotId, fromSlot) : this.handleQuickMove(player, slotId, fromSlot);
            } else {
                Slot clickedSlot = this.func_75139_a(slotId);
                ItemStack slotStack = clickedSlot.func_75211_c();
                ItemStack heldStack = inventoryplayer.func_70445_o();
                if (slotStack.func_190926_b()) {
                    if (!heldStack.func_190926_b() && clickedSlot.func_75214_a(heldStack)) {
                        int stackCount;
                        int n = stackCount = mouseButton == 0 ? heldStack.func_190916_E() : 1;
                        if (stackCount > clickedSlot.func_178170_b(heldStack)) {
                            stackCount = clickedSlot.func_178170_b(heldStack);
                        }
                        clickedSlot.func_75215_d(heldStack.func_77979_a(stackCount));
                    }
                } else if (clickedSlot.func_82869_a(player)) {
                    int stackCount;
                    if (heldStack.func_190926_b() && !slotStack.func_190926_b()) {
                        int s = Math.min(slotStack.func_190916_E(), slotStack.func_77976_d());
                        int toRemove = mouseButton == 0 ? s : (s + 1) / 2;
                        inventoryplayer.func_70437_b(slotStack.func_77979_a(toRemove));
                        clickedSlot.func_75215_d(slotStack);
                        clickedSlot.func_190901_a(player, inventoryplayer.func_70445_o());
                    } else if (clickedSlot.func_75214_a(heldStack)) {
                        if (slotStack.func_77973_b() == heldStack.func_77973_b() && slotStack.func_77960_j() == heldStack.func_77960_j() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack)) {
                            int stackCount2;
                            int n = stackCount2 = mouseButton == 0 ? heldStack.func_190916_E() : 1;
                            if (stackCount2 > clickedSlot.func_178170_b(heldStack) - slotStack.func_190916_E()) {
                                stackCount2 = clickedSlot.func_178170_b(heldStack) - slotStack.func_190916_E();
                            }
                            heldStack.func_190918_g(stackCount2);
                            slotStack.func_190917_f(stackCount2);
                            clickedSlot.func_75215_d(slotStack);
                        } else if (heldStack.func_190916_E() <= clickedSlot.func_178170_b(heldStack)) {
                            clickedSlot.func_75215_d(heldStack);
                            inventoryplayer.func_70437_b(slotStack);
                        }
                    } else if (!(slotStack.func_77973_b() != heldStack.func_77973_b() || heldStack.func_77976_d() <= 1 || slotStack.func_77981_g() && slotStack.func_77960_j() != heldStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack) || slotStack.func_190926_b() || (stackCount = slotStack.func_190916_E()) + heldStack.func_190916_E() > heldStack.func_77976_d())) {
                        heldStack.func_190917_f(stackCount);
                        slotStack = clickedSlot.func_75209_a(stackCount);
                        if (slotStack.func_190926_b()) {
                            clickedSlot.func_75215_d(Platform.EMPTY_STACK);
                        }
                        clickedSlot.func_190901_a(player, inventoryplayer.func_70445_o());
                    }
                }
                clickedSlot.func_75218_e();
            }
            this.func_75142_b();
            return returnable;
        }
        return this.superSlotClick(slotId, mouseButton, clickTypeIn, player);
    }

    @NotNull
    protected final ItemStack superSlotClick(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        return super.func_184996_a(slotId, mouseButton, clickTypeIn, player);
    }

    public final ItemStack handleQuickMove(EntityPlayer player, int slotId, Slot fromSlot) {
        ItemStack returnable;
        ItemStack remainder;
        do {
            remainder = this.func_82846_b(player, slotId);
            returnable = Platform.copyStack(remainder);
        } while (!Platform.isStackEmpty(remainder) && ItemHandlerHelper.canItemStacksStack((ItemStack)fromSlot.func_75211_c(), (ItemStack)remainder));
        return returnable;
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull EntityPlayer playerIn, int index) {
        ItemStack stack;
        ModularSlot slot = this.getModularSlot(index);
        if (!slot.isPhantom() && !(stack = slot.func_75211_c()).func_190926_b()) {
            ItemStack remainder;
            ItemStack copy = stack.func_77946_l();
            stack = stack.func_77946_l();
            int base = 0;
            if (stack.func_190916_E() > stack.func_77976_d()) {
                base = stack.func_190916_E() - stack.func_77976_d();
                stack.func_190920_e(stack.func_77976_d());
            }
            if (ItemStack.func_77989_b((ItemStack)(remainder = this.transferItem(slot, stack.func_77946_l())), (ItemStack)stack)) {
                return Platform.EMPTY_STACK;
            }
            if (base == 0 && remainder.func_190926_b()) {
                stack = Platform.EMPTY_STACK;
            } else {
                stack.func_190920_e(base + remainder.func_190916_E());
            }
            slot.func_75215_d(stack);
            slot.func_75220_a(remainder, copy);
            slot.func_190901_a(playerIn, remainder);
            slot.onCraftShiftClick(playerIn, remainder);
            return copy;
        }
        return Platform.EMPTY_STACK;
    }

    protected ItemStack transferItem(ModularSlot fromSlot, ItemStack fromStack) {
        @Nullable SlotGroup fromSlotGroup = fromSlot.getSlotGroup();
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            int maxSize;
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            ItemStack toStack = toSlot.func_75211_c().func_77946_l();
            if (fromSlot.isPhantom() || !ItemHandlerHelper.canItemStacksStack((ItemStack)fromStack, (ItemStack)toStack)) continue;
            int j = toStack.func_190916_E() + fromStack.func_190916_E();
            if (j <= (maxSize = toSlot.func_178170_b(fromStack))) {
                fromStack.func_190920_e(0);
                toStack.func_190920_e(j);
                toSlot.func_75215_d(toStack);
            } else if (toStack.func_190916_E() < maxSize) {
                fromStack.func_190918_g(maxSize - toStack.func_190916_E());
                toStack.func_190920_e(maxSize);
                toSlot.func_75215_d(toStack);
            }
            if (!fromStack.func_190926_b()) continue;
            return fromStack;
        }
        boolean hasNonEmptyPhantom = false;
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            ItemStack itemstack = toSlot.func_75211_c();
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            if (toSlot.isPhantom()) {
                if (!itemstack.func_190926_b()) {
                    hasNonEmptyPhantom = true;
                    continue;
                }
                toSlot.func_75215_d(fromStack.func_77946_l());
                return fromStack;
            }
            if (!itemstack.func_190926_b()) continue;
            if (fromStack.func_190916_E() > toSlot.func_178170_b(fromStack)) {
                toSlot.func_75215_d(fromStack.func_77979_a(toSlot.func_178170_b(fromStack)));
            } else {
                toSlot.func_75215_d(fromStack.func_77979_a(fromStack.func_190916_E()));
            }
            if (fromStack.func_190916_E() >= 1) continue;
            break;
        }
        if (!hasNonEmptyPhantom) {
            return fromStack;
        }
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.isPhantom() || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            toSlot.func_75215_d(fromStack.func_77946_l());
            return fromStack;
        }
        return fromStack;
    }

    public void buildSortingContext(ISortingContextBuilder builder) {
        if (this.syncManager != null) {
            this.syncManager.buildSortingContext(builder);
        }
    }

    public IPosSetter getPlayerButtonPosSetter() {
        return null;
    }
}

