/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;

public class LocatedElement<T> {
    private final T element;
    private final TransformationMatrix transformationMatrix;

    public LocatedElement(T element, TransformationMatrix transformationMatrix) {
        this.element = element;
        this.transformationMatrix = new TransformationMatrix(transformationMatrix, null);
    }

    public T getElement() {
        return this.element;
    }

    public TransformationMatrix getTransformationMatrix() {
        return this.transformationMatrix;
    }

    public void applyMatrix(GuiContext context) {
        context.push(this.transformationMatrix);
    }

    public void unapplyMatrix(GuiContext context) {
        context.pop(this.transformationMatrix);
    }

    public String toString() {
        return "LocatedElement[" + this.getElement() + "]";
    }

    public LocatedElementHashStrategy<T> createHashStrategy() {
        return new LocatedElementHashStrategy();
    }

    public static class LocatedElementHashStrategy<T>
    implements Hash.Strategy<LocatedElement<T>> {
        public int hashCode(LocatedElement<T> o) {
            return Objects.hashCode(o == null ? null : ((LocatedElement)o).element);
        }

        public boolean equals(LocatedElement<T> a, LocatedElement<T> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return Objects.equals(((LocatedElement)a).element, ((LocatedElement)b).element);
        }
    }
}

