/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.test;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.animation.Animator;
import com.cleanroommc.modularui.animation.SequentialAnimator;
import com.cleanroommc.modularui.animation.Wait;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.SpriteDrawable;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.factory.ClientGUI;
import com.cleanroommc.modularui.screen.CustomModularScreen;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.test.GLTestGui;
import com.cleanroommc.modularui.test.TestGui;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.ColorShade;
import com.cleanroommc.modularui.utils.GameObjectHelper;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.Interpolations;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.utils.SpriteHelper;
import com.cleanroommc.modularui.utils.fakeworld.ArraySchema;
import com.cleanroommc.modularui.utils.fakeworld.FakeEntity;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.StringValue;
import com.cleanroommc.modularui.widget.DraggableWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ColorPickerDialog;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.SchemaWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.TransformWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class TestGuis
extends CustomModularScreen {
    @Override
    @NotNull
    public ModularPanel buildUI(ModularGuiContext context) {
        ArrayList<Method> uiMethods = new ArrayList<Method>();
        for (Method method : TestGuis.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !ModularPanel.class.isAssignableFrom(method.getReturnType()) || method.getParameterCount() != 0) continue;
            uiMethods.add(method);
        }
        uiMethods.sort(Comparator.comparing(Method::getName));
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("client_tests").height(200)).width(170)).padding(7)).child((IWidget)((Flow)Flow.column().child((IWidget)IKey.str("Client Test UIs").asWidget().margin(1))).child((IWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)new ListWidget().widthRel(1.0f)).expanded()).children(uiMethods.size(), i -> {
            Method m = (Method)uiMethods.get(i);
            String name = m.getName();
            if (name.startsWith("build")) {
                name = name.substring(5);
            }
            if (name.endsWith("UI")) {
                name = name.substring(0, name.length() - 2);
            }
            name = name.replaceAll("([a-z])([A-Z])", "$1 $2");
            return TestGuis.button(name).onMousePressed(button -> {
                try {
                    ClientGUI.open(new ModularScreen((ModularPanel)m.invoke(null, new Object[0])).openParentOnClose(true));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    ModularUI.LOGGER.throwing((Throwable)e);
                }
                return true;
            });
        }).child(TestGuis.button("OpenGL test").onMousePressed(button -> {
            ClientGUI.open(new GLTestGui().openParentOnClose(true));
            return true;
        }))).child(TestGuis.button("Sortable List").onMousePressed(button -> {
            ClientGUI.open(new TestGui().openParentOnClose(true));
            return true;
        }))).child(TestGuis.button("Test self").onMousePressed(button -> {
            ClientGUI.open(this);
            return true;
        }))));
    }

    private static ButtonWidget<?> button(String text) {
        return (ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().height(16)).widthRel(1.0f)).margin(0, 1)).overlay(IKey.str(text));
    }

    @NotNull
    public static ModularPanel buildToggleGridListUI() {
        boolean[][] states = new boolean[4][16];
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("grid_list"){

            @Override
            public void onInit() {
                super.onInit();
                this.getScreen().useTheme("mui:test_theme");
            }
        }.height(100)).coverChildrenWidth()).padding(7)).child(((ListWidget)((ListWidget)new ListWidget().coverChildrenWidth()).heightRel(1.0f)).children(4, i -> ((Grid)((Grid)new Grid().left(0)).coverChildren()).mapTo(4, 16, j -> (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().overlay(GuiTextures.BOOKMARK)).value(new BoolValue.Dynamic(() -> states[i][j], val -> {
            states[i][j] = val;
        })).size(10)).margin(1)).debugName("G:" + i + ",W:" + j))));
    }

    @NotNull
    public static ModularPanel buildPendulumAnimationUI() {
        IWidget widget = (IWidget)((Widget)GuiTextures.MUI_LOGO.asWidget().size(20)).pos(65, 65);
        Animator animator = ((Animator)((Animator)new Animator().bounds(0.0f, 1.0f).curve(Interpolation.SINE_INOUT).reverseOnFinish(true)).repeatsOnFinish(-1)).duration(1200);
        animator.reset(true);
        animator.animate(true);
        return (ModularPanel)((ModularPanel)ModularPanel.defaultPanel("main").size(150)).child(((TransformWidget)new TransformWidget().child(widget)).transform(stack -> {
            double angle = Math.PI;
            float x = (float)(55.0 * Math.cos((double)animator.getValue() * angle));
            float y = (float)(55.0 * Math.sin((double)animator.getValue() * angle));
            stack.translate(x, y);
        }));
    }

    @NotNull
    public static ModularPanel buildPostTheLogAnimationUI() {
        Animator post = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(-35.0f, 0.0f);
        Animator the = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(-20.0f, 0.0f);
        Animator fucking = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(53.0f, 0.0f);
        Animator log = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(20.0f, 0.0f);
        Animator logGrow = new Animator().curve(Interpolation.LINEAR).duration(2500).bounds(0.0f, 1.0f);
        SequentialAnimator animator = new Wait(300).followedBy(post).followedBy(the).followedBy(fucking).followedBy(log).followedBy(logGrow);
        animator.animate();
        Random rnd = new Random();
        TextureAtlasSprite[] sprites = (TextureAtlasSprite[])IntStream.range(0, 10).mapToObj(SpriteHelper::getDestroyBlockSprite).toArray(TextureAtlasSprite[]::new);
        IDrawable broken = (context1, x, y, width, height, widgetTheme) -> {
            if (logGrow.getValue() < 0.1f) {
                return;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            GuiDraw.drawTiledSprite(sprites[(int)Math.min(9.0f, logGrow.getValue() * 10.0f)], x, y, width + 24, height + 24);
        };
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("main").coverChildren()).padding(12)).overlay(broken)).child((IWidget)((Flow)((Flow)new Column().coverChildren()).child((IWidget)((Flow)((Flow)((Flow)new Row().coverChildren()).child(IKey.str("Post ").asWidget().transform((widget, stack) -> stack.translate(post.getValue(), 0.0f)))).child(IKey.str("the ").asWidget().transform((widget, stack) -> stack.translate(0.0f, the.getValue())))).child(IKey.str("fucking ").asWidget().transform((widget, stack) -> stack.translate(fucking.getValue(), 0.0f))))).child(((TextWidget)IKey.str("LOOOOGG!!!! ").asWidget().paddingTop(4)).transform((widget, stack) -> {
            float logVal = log.getValue();
            float logGrowVal = logGrow.getValue();
            stack.translate((float)rnd.nextInt(5) * logGrowVal, logVal + (float)rnd.nextInt(5) * logGrowVal);
            int x0 = widget.getArea().width / 2;
            int y0 = widget.getArea().height;
            float scale = Interpolations.lerp(1.0f, 3.0f, logGrowVal);
            stack.translate(x0, y0);
            stack.scale(scale, scale);
            stack.translate(-x0, -y0);
            widget.color(Color.interpolate(-16514044, Color.RED.main, Math.min(1.0f, 1.2f * logGrowVal)));
        })));
    }

    @NotNull
    public static ModularPanel buildSpriteAndEntityUI() {
        TextureAtlasSprite sprite = SpriteHelper.getSpriteOfBlockState(GameObjectHelper.getBlockState("minecraft", "command_block"), EnumFacing.UP);
        EntityDragon entity = FakeEntity.create(EntityDragon.class);
        float period = 3000.0f;
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)ModularPanel.defaultPanel("main").size(150)).child((IWidget)((TextWidget)new TextWidget(IKey.str("Test String")).scale(0.6f).horizontalCenter()).top(7))).child((IWidget)((DraggableWidget)((DraggableWidget)((DraggableWidget)((DraggableWidget)new DraggableWidget().background(new SpriteDrawable(sprite))).size(20)).alignX(0.5f)).top(20)).tooltipBuilder(tooltip -> {
            tooltip.addLine("Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.  Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.  Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.  Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem");
            tooltip.addLine("Longer Line 2");
            tooltip.addLine("Line 3");
            tooltip.alignment(Alignment.Center);
            tooltip.scale(0.5f);
            tooltip.pos(RichTooltip.Pos.NEXT_TO_MOUSE);
        }))).child((IWidget)((Widget)((Widget)new IDrawable(){
            final /* synthetic */ Entity val$entity;
            final /* synthetic */ float val$period;
            {
                this.val$entity = entity;
                this.val$period = f;
            }

            @Override
            public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
                GuiDraw.drawEntity(this.val$entity, 0.0f, 0.0f, width, height, context.getCurrentDrawingZ(), e -> {
                    float scale = 0.9f;
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    GlStateManager.func_179109_b((float)0.0f, (float)7.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(360.0f * ((float)Minecraft.func_71386_F() % this.val$period) / this.val$period), (float)0.0f, (float)1.0f, (float)0.0f);
                }, null);
            }
        }.asWidget().alignX(0.5f)).bottom(10)).size(100, 75));
    }

    @NotNull
    public static ModularPanel buildRichTextUI() {
        return (ModularPanel)((ModularPanel)new ModularPanel("main").size(176, 166)).child(((RichTextWidget)((RichTextWidget)new RichTextWidget().sizeRel(1.0f)).margin(7)).autoUpdate(true).textBuilder(text -> ((RichText)((RichText)((RichText)((RichText)((RichText)text.add("Hello ").add((IDrawable)new ItemDrawable(new ItemStack((Block)Blocks.field_150349_c)).asIcon().asHoverable().tooltip(richTooltip -> richTooltip.addFromItem(new ItemStack((Block)Blocks.field_150349_c)).add(TextFormatting.GRAY + "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua."))).add(", nice to ").add(new ItemDrawable(new ItemStack(Items.field_151147_al)).asIcon().asInteractable().onMousePressed(button -> {
            ModularUI.LOGGER.info("Pressed Pork");
            return true;
        })).add(" you. ").add(IKey.GREEN + "This is a long ").add((IDrawable)IKey.str("string").style(IKey.DARK_PURPLE).asTextIcon().asHoverable().addTooltipLine("Text Tooltip")).add(" of characters" + IKey.RESET).add(" and not numbers as some might think...").newLine()).newLine()).add(IKey.comp(IKey.comp(IKey.str("Underline all: "), IKey.comp(IKey.str("Green Text, "), IKey.str("this is red").style(IKey.RED), IKey.str(" and this should be green again")).style(IKey.GREEN), IKey.str(". Still underlined, ")).style(IKey.UNDERLINE), IKey.str("but not anymore."))).newLine()).add(IKey.str("Green, %s, %s and green again", IKey.str("red").style(IKey.RED), IKey.str("underline").style(null, IKey.UNDERLINE)).style(IKey.GREEN)).newLine()).add(TextFormatting.RESET + "" + TextFormatting.UNDERLINE + "Underlined" + TextFormatting.RESET).newLine()).add("A long line which should wrap around").textShadow(false)));
    }

    @NotNull
    public static ModularPanel buildWorldSchemaUI() {
        ArraySchema schema = ArraySchema.builder().layer("D   D", "     ", "     ", "     ").layer(" DDD ", " E E ", "     ", "     ").layer(" DDD ", "  E  ", "  G  ", "  B  ").layer(" DDD ", " E E ", "     ", "     ").layer("D   D", "     ", "     ", "     ").where('D', "minecraft:gold_block").where('E', "minecraft:emerald_block").where('G', "minecraft:diamond_block").where('B', "minecraft:beacon").build();
        ModularPanel panel = (ModularPanel)ModularPanel.defaultPanel("main").size(170);
        ((ModularPanel)panel.child((IWidget)new SchemaWidget(schema).full())).child((IWidget)((SchemaWidget.LayerButton)((SchemaWidget.LayerButton)new SchemaWidget.LayerButton(schema, 0, 3).bottom(1)).left(1)).size(16));
        return panel;
    }

    public static ModularPanel buildCollapseDisabledChildrenUI() {
        Random rnd = new Random();
        return (ModularPanel)((ModularPanel)ModularPanel.defaultPanel("list", 100, 150).padding(7)).child(((ListWidget)((ListWidget)new ListWidget().sizeRel(1.0f)).collapseDisabledChild()).children(12, i -> ((Widget)((Widget)((Widget)new Widget().widthRel(1.0f)).height(16)).widgetTheme(IThemeApi.BUTTON)).overlay(IKey.str(String.valueOf(i + 1))).onUpdateListener(w -> {
            if (rnd.nextDouble() < 0.05) {
                w.setEnabled(!w.isEnabled());
            }
        })));
    }

    @NotNull
    public static ModularPanel buildSearchTest() {
        List<String> items = Arrays.asList("Chicken", "Jockey", "Flint", "Steel", "Steve", "Diamond", "Ingot", "Iron", "Armor", "Greg");
        StringValue searchValue = new StringValue("");
        return (ModularPanel)ModularPanel.defaultPanel("search", 100, 150).child((IWidget)((Flow)((Flow)Flow.column().padding(5)).child((IWidget)((TextFieldWidget)new TextFieldWidget().value(searchValue).height(16)).widthRel(1.0f))).child(((ListWidget)((ListWidget)new ListWidget().collapseDisabledChild().expanded()).widthRel(1.0f)).children(items.size(), i -> ((TextWidget)((TextWidget)((TextWidget)((TextWidget)new TextWidget(IKey.str((String)items.get(i))).alignment(Alignment.Center)).color(Color.WHITE.main).widthRel(1.0f)).height(16)).background(GuiTextures.MC_BUTTON)).setEnabledIf(w -> ((String)items.get(i)).toLowerCase().contains(searchValue.getStringValue())))));
    }

    @NotNull
    public static ModularPanel buildColorTheoryUI() {
        ArrayList<Pair> colors = new ArrayList<Pair>();
        for (ColorShade shade : ColorShade.getAll()) {
            IntIterator intIterator = shade.iterator();
            while (intIterator.hasNext()) {
                int c = (Integer)intIterator.next();
                colors.add(Pair.of((Object)c, (Object)Float.valueOf(Color.getLuminance(c))));
            }
        }
        colors.sort((a, b) -> Float.compare(((Float)a.getRight()).floatValue(), ((Float)b.getRight()).floatValue()));
        IDrawable luminanceSortedColors = (context1, x, y, width, height, widgetTheme) -> {
            float w = (float)width / (float)colors.size();
            float x0 = x;
            for (Pair c : colors) {
                GuiDraw.drawRect(x0, y, w, height, (Integer)c.getLeft());
                x0 += w;
            }
        };
        Rectangle color1 = new Rectangle().setColor(Color.BLACK.main);
        Rectangle color2 = new Rectangle().setColor(Color.WHITE.main);
        IDrawable gradient = (context1, x, y, width, height, widgetTheme) -> GuiDraw.drawHorizontalGradientRect(x, y, width, height, color1.getColor(), color2.getColor());
        IDrawable correctedGradient = (context1, x, y, width, height, widgetTheme) -> {
            int points = 500;
            Platform.setupDrawColor();
            Platform.setupDrawGradient();
            Platform.startDrawing(Platform.DrawMode.TRIANGLE_STRIP, Platform.VertexFormat.POS_COLOR, buffer -> {
                float x0 = x;
                float w = (float)width / (float)points;
                for (int i = 0; i < points; ++i) {
                    int color = Color.lerp(color1.getColor(), color2.getColor(), (float)i / (float)points);
                    int r = Color.getRed(color);
                    int g = Color.getGreen(color);
                    int b = Color.getBlue(color);
                    int a = 255;
                    buffer.func_181662_b((double)x0, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)x0, (double)(y + height), 0.0).func_181669_b(r, g, b, a).func_181675_d();
                    x0 += w;
                }
            });
            Platform.endDrawGradient();
        };
        ModularPanel panel = (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("colors").width(300)).coverChildrenHeight()).padding(7);
        IPanelHandler colorPicker1 = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog("color_picker1", color1::setColor, color1.getColor(), true).setDraggable(true).relative(panel)).top(0)).rightRel(1.0f), true);
        IPanelHandler colorPicker2 = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog("color_picker2", color2::setColor, color2.getColor(), true).setDraggable(true).relative(panel)).top(0)).leftRel(1.0f), true);
        return (ModularPanel)panel.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().coverChildrenHeight()).child((IWidget)IKey.str("Colors sorted by luminance").asWidget().margin(1))).child((IWidget)((Widget)luminanceSortedColors.asWidget().widthRel(1.0f)).height(10))).child((IWidget)((TextWidget)IKey.str("Blending color").asWidget().margin(1)).marginTop(2))).child((IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().debugName("color picker button 1")).background(color1)).disableHoverBackground()).onMousePressed(mouseButton -> {
            colorPicker1.openPanel();
            return true;
        }))).child(IKey.str("<--  Select colors  -->").asWidget())).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().debugName("color picker button 2")).background(color2)).disableHoverBackground()).onMousePressed(mouseButton -> {
            colorPicker2.openPanel();
            return true;
        })))).child((IWidget)IKey.str("OpenGL color gradient").asWidget().margin(1))).child((IWidget)((Widget)gradient.asWidget().widthRel(1.0f)).height(10))).child((IWidget)IKey.str("Gamma corrected gradient").asWidget().margin(1))).child((IWidget)((Widget)correctedGradient.asWidget().widthRel(1.0f)).height(10)));
    }

    @NotNull
    public static ModularPanel buildViewportTransformUI() {
        return (ModularPanel)new TestPanel("test").child(((Widget)((Widget)((Widget)new Widget().align(Alignment.Center)).size(50, 50)).background(GuiTextures.MC_BUTTON)).hoverBackground(GuiTextures.MC_BUTTON_HOVERED));
    }

    private static class TestPanel
    extends ModularPanel {
        public TestPanel(String name) {
            super(name);
            ((ModularPanel)this.align(Alignment.Center)).size(100, 100);
        }

        @Override
        public void transform(IViewportStack stack) {
            super.transform(stack);
            stack.translate(50.0f, 50.0f);
            float angle = (float)((double)((float)(Minecraft.func_71386_F() % 4000L) / 4000.0f * 2.0f) * Math.PI);
            stack.rotateZ(angle);
            long t = Minecraft.func_71386_F() % 4000L;
            float scale = t <= 2000L ? Interpolation.BACK_INOUT.interpolate(0.5f, 1.0f, (float)t / 2000.0f) : Interpolation.BACK_INOUT.interpolate(0.5f, 1.0f, (float)(2000L - t + 2000L) / 2000.0f);
            stack.scale(scale, scale);
            stack.translate(-50.0f, -50.0f);
        }
    }
}

