/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.theme.ReloadThemeEvent;
import com.cleanroommc.modularui.theme.Theme;
import com.cleanroommc.modularui.theme.ThemeAPI;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.theme.WidgetThemeKey;
import com.cleanroommc.modularui.theme.WidgetThemeMap;
import com.cleanroommc.modularui.theme.WidgetThemeParser;
import com.cleanroommc.modularui.utils.AssetHelper;
import com.cleanroommc.modularui.utils.JsonBuilder;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.utils.ObjectList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@ApiStatus.Internal
public class ThemeManager
implements ISelectiveResourceReloadListener {
    protected static final WidgetThemeEntry<WidgetTheme> defaultFallbackWidgetTheme = IThemeApi.get().getDefaultTheme().getWidgetTheme(IThemeApi.FALLBACK);
    private static final JsonObject emptyJson = new JsonObject();

    public static void reload() {
        ModularUI.LOGGER.info("Reloading Themes...");
        MinecraftForge.EVENT_BUS.post((Event)new ReloadThemeEvent.Pre());
        ThemeAPI.INSTANCE.onReload();
        ThemeManager.loadThemesJsons();
        ThemeManager.validateJsonScreenThemes();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadThemeEvent.Post());
    }

    private static void loadThemesJsons() {
        Object2ObjectOpenHashMap themes = new Object2ObjectOpenHashMap();
        ObjectList.ObjectArrayList themesJsons = ObjectList.create();
        for (IResource resource : AssetHelper.findAssets("themes.json")) {
            themesJsons.add(resource.func_177241_a().toString());
            try {
                JsonElement element = JsonHelper.parse(resource.func_110527_b());
                if (!element.isJsonObject()) {
                    resource.close();
                    continue;
                }
                JsonObject definitions = element.getAsJsonObject();
                for (Map.Entry entry : definitions.entrySet()) {
                    if (((String)entry.getKey()).equals("screens")) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) {
                            ModularUI.LOGGER.error("Theme screen definitions must be an object!");
                            continue;
                        }
                        ThemeManager.loadScreenThemes(((JsonElement)entry.getValue()).getAsJsonObject());
                        continue;
                    }
                    if (((JsonElement)entry.getValue()).isJsonObject() || ((JsonElement)entry.getValue()).isJsonArray() || ((JsonElement)entry.getValue()).isJsonNull()) {
                        ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Theme must be a string!"));
                        continue;
                    }
                    themes.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).add(((JsonElement)entry.getValue()).getAsString());
                }
                resource.close();
            }
            catch (Exception e) {
                ModularUI.LOGGER.catching((Throwable)e);
            }
        }
        ModularUI.LOGGER.info("Found themes.json's at {}", themesJsons);
        ThemeManager.loadThemes((Map<String, List<String>>)themes);
    }

    public static void loadThemes(Map<String, List<String>> themesPaths) {
        boolean changed;
        Object2ObjectOpenHashMap themeMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, List<String>> entry : themesPaths.entrySet()) {
            ThemeJson theme;
            if (entry.getValue().isEmpty() || (theme = ThemeManager.loadThemeJson(entry.getKey(), entry.getValue())) == null) continue;
            themeMap.put(entry.getKey(), theme);
        }
        for (Map.Entry entry : ThemeAPI.INSTANCE.defaultThemes.entrySet()) {
            if (themeMap.containsKey(entry.getKey())) continue;
            themeMap.put((String)entry.getKey(), new ThemeJson((String)entry.getKey(), ((List)entry.getValue()).stream().map(JsonBuilder::getJson).collect(Collectors.toList()), false));
        }
        if (themeMap.isEmpty()) {
            return;
        }
        ThemeManager.validateAncestorTree((Map<String, ThemeJson>)themeMap);
        if (themeMap.isEmpty()) {
            return;
        }
        Object2ObjectLinkedOpenHashMap sortedThemes = new Object2ObjectLinkedOpenHashMap();
        block2: do {
            changed = false;
            Iterator iterator = themeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!"DEFAULT".equals(((ThemeJson)entry.getValue()).parent) && !sortedThemes.containsKey(((ThemeJson)entry.getValue()).parent)) continue;
                sortedThemes.put((String)entry.getKey(), (ThemeJson)entry.getValue());
                iterator.remove();
                changed = true;
                continue block2;
            }
        } while (changed);
        for (ThemeJson themeJson : sortedThemes.values()) {
            Theme theme = themeJson.deserialize();
            ThemeAPI.INSTANCE.registerTheme(theme);
        }
    }

    private static void validateAncestorTree(Map<String, ThemeJson> themeMap) {
        ObjectOpenHashSet invalidThemes = new ObjectOpenHashSet();
        block0: for (ThemeJson theme : themeMap.values()) {
            if (invalidThemes.contains(theme)) continue;
            ObjectOpenHashSet parents = new ObjectOpenHashSet();
            parents.add(theme);
            ThemeJson parent = theme;
            while (!"DEFAULT".equals(parent.parent)) {
                if ((parent = themeMap.get(parent.parent)) == null) {
                    ModularUI.LOGGER.error("Can't find parent '{}' for theme '{}'! All children for '{}' are therefore invalid!", (Object)theme.parent, (Object)theme.id, (Object)theme.id);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                if (parents.contains(parent)) {
                    ModularUI.LOGGER.error("Ancestor tree for themes can't be circular! All of the following make a circle or are children of the circle: {}", (Object)parents);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                if (invalidThemes.contains(parent)) {
                    ModularUI.LOGGER.error("Parent '{}' was found to be invalid before. All following are children of it and are therefore invalid too: {}", (Object)theme.parent, (Object)parents);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                parents.add(parent);
            }
        }
        for (ThemeJson theme : invalidThemes) {
            themeMap.remove(theme.id);
        }
    }

    private static ThemeJson loadThemeJson(String id, List<String> paths) {
        ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
        boolean override = false;
        for (String path : paths) {
            ResourceLocation rl;
            if (path.contains(":")) {
                String[] parts = path.split(":", 2);
                rl = new ResourceLocation(parts[0], "themes/" + parts[1] + ".json");
            } else {
                rl = new ResourceLocation("themes/" + path + ".json");
            }
            IResource resource = AssetHelper.findAsset(rl);
            if (resource == null) {
                return null;
            }
            JsonElement element = JsonHelper.parse(resource.func_110527_b());
            try {
                resource.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!element.isJsonObject()) continue;
            if (JsonHelper.getBoolean(element.getAsJsonObject(), false, "override")) {
                jsons.clear();
                override = true;
            }
            jsons.add(element.getAsJsonObject());
        }
        if (jsons.isEmpty()) {
            ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Theme must be a JsonObject!"));
            return null;
        }
        return new ThemeJson(id, jsons, override);
    }

    private static void loadScreenThemes(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                String theme = ((JsonElement)entry.getValue()).getAsString();
                ThemeAPI.INSTANCE.jsonScreenThemes.put((Object)((String)entry.getKey()), (Object)theme);
                continue;
            }
            ModularUI.LOGGER.error("Theme screen definitions must be strings!");
        }
    }

    private static void validateJsonScreenThemes() {
        ObjectIterator iterator = ThemeAPI.INSTANCE.jsonScreenThemes.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ThemeAPI.INSTANCE.hasTheme((String)entry.getValue())) continue;
            ModularUI.LOGGER.error("Tried to register theme '{}' for screen '{}', but theme does not exist", entry.getValue(), entry.getKey());
            iterator.remove();
        }
    }

    public void onResourceManagerReload(@NotNull IResourceManager resourceManager, @NotNull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            ThemeManager.reload();
        }
    }

    private static class ThemeJson {
        private final String id;
        private final String parent;
        private final List<JsonObject> jsons;
        private final boolean override;

        private ThemeJson(String id, List<JsonObject> jsons, boolean override) {
            this.id = id;
            this.override = override;
            String p = null;
            ListIterator<JsonObject> iterator = jsons.listIterator(jsons.size());
            while (iterator.hasPrevious()) {
                JsonObject json = iterator.previous();
                if (!json.has("parent")) continue;
                p = json.get("parent").getAsString();
                break;
            }
            this.parent = p == null ? "DEFAULT" : p;
            this.jsons = jsons;
        }

        private Theme deserialize() {
            WidgetTheme fallback;
            if (!ThemeAPI.INSTANCE.hasTheme(this.parent)) {
                throw new IllegalStateException(String.format("Ancestor tree was validated, but parent '%s' was still null during parsing!", this.parent));
            }
            ITheme parent = ThemeAPI.INSTANCE.getTheme(this.parent);
            JsonBuilder jsonBuilder = new JsonBuilder();
            if (!this.override) {
                for (JsonBuilder builder : ThemeAPI.INSTANCE.getJavaDefaultThemes(this.id)) {
                    jsonBuilder.addAllOf(builder);
                }
            }
            for (JsonObject json : this.jsons) {
                jsonBuilder.addAllOf(json);
            }
            WidgetThemeMap widgetThemes = new WidgetThemeMap();
            WidgetThemeEntry<WidgetTheme> parentWidgetTheme = parent.getFallback();
            WidgetTheme fallbackHover = fallback = new WidgetTheme(parentWidgetTheme.getTheme(), jsonBuilder.getJson(), null);
            JsonObject hoverJson = this.getJson(jsonBuilder.getJson(), ":hover");
            if (hoverJson == null) {
                hoverJson = this.getJson(jsonBuilder.getJson(), IThemeApi.FALLBACK.getFullName() + ":hover");
            }
            if (hoverJson != null) {
                fallbackHover = new WidgetTheme(fallback, hoverJson, null);
            }
            widgetThemes.putTheme(IThemeApi.FALLBACK, new WidgetThemeEntry<WidgetTheme>(IThemeApi.FALLBACK, fallback, fallbackHover));
            for (WidgetThemeKey<?> key : ThemeAPI.INSTANCE.getWidgetThemeKeys()) {
                if (key == IThemeApi.FALLBACK) continue;
                this.parse(widgetThemes, parent, key, jsonBuilder);
            }
            return new Theme(this.id, parent, widgetThemes);
        }

        private <T extends WidgetTheme> void parse(WidgetThemeMap map, ITheme parent, WidgetThemeKey<T> key, JsonBuilder json) {
            JsonObject widgetThemeHoverJson;
            WidgetThemeParser<T> parser = key.getParser();
            boolean definedInTheme = true;
            JsonObject widgetThemeJson = this.getJson(json.getJson(), key.getFullName());
            if (widgetThemeJson == null) {
                definedInTheme = false;
            }
            if ((widgetThemeHoverJson = this.getJson(json.getJson(), key.getFullName() + ":hover")) == null && !definedInTheme) {
                if (key.isSubWidgetTheme()) {
                    WidgetThemeEntry<T> entry = map.getTheme(key.getParent());
                    map.putTheme(key, new WidgetThemeEntry<T>(key, entry.getTheme(), entry.getHoverTheme()));
                    return;
                }
                widgetThemeJson = emptyJson;
                widgetThemeHoverJson = emptyJson;
            }
            JsonObject fallback = key.isSubWidgetTheme() ? null : json.getJson();
            Object widgetTheme = null;
            if (widgetThemeJson != null) {
                T parentWidgetTheme = key.isSubWidgetTheme() ? map.getTheme(key.getParent()).getTheme() : parent.getWidgetTheme(key).getTheme();
                widgetTheme = parser.parse(parentWidgetTheme, widgetThemeJson, fallback);
            }
            Object widgetThemeHover = null;
            if (widgetThemeHoverJson != null) {
                Object parentWidgetTheme = definedInTheme ? widgetTheme : (Object)parent.getWidgetTheme(key).getHoverTheme();
                widgetThemeHover = parser.parse(parentWidgetTheme, widgetThemeHoverJson, fallback);
            }
            if (widgetTheme != null) {
                if (widgetThemeHover != null) {
                    map.putTheme(key, new WidgetThemeEntry<Object>((WidgetThemeKey<Object>)key, widgetTheme, widgetThemeHover));
                } else {
                    map.putTheme(key, new WidgetThemeEntry<Object>((WidgetThemeKey<Object>)key, widgetTheme));
                }
            } else {
                map.putTheme(key, new WidgetThemeEntry<Object>((WidgetThemeKey<Object>)key, parent.getWidgetTheme(key).getTheme(), widgetThemeHover));
            }
        }

        private JsonObject getJson(JsonObject json, String key) {
            if (json.has(key)) {
                JsonElement element = json.get(key);
                if (element.isJsonObject()) {
                    return element.getAsJsonObject();
                }
                ModularUI.LOGGER.warn("WidgetTheme '{}' of theme '{}' with parent '{}' was found to have an incorrect data format.", (Object)key, (Object)this.id, (Object)this.parent);
            }
            return null;
        }
    }
}

