/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.theme.ThemeAPI;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetThemeKey<T extends WidgetTheme>
implements Comparable<WidgetThemeKey<?>> {
    private static final Map<String, WidgetThemeKey<?>> KEYS = new Object2ObjectOpenHashMap();
    @Nullable
    private final WidgetThemeKey<T> parent;
    private final Class<T> type;
    private final String name;
    @Nullable
    private final String subName;
    private final T defaultValue;
    private final T defaultHoverValue;
    private final WidgetThemeParser<T> parser;

    @Nullable
    public static WidgetThemeKey<?> getFromFullName(String key) {
        return KEYS.get(key);
    }

    WidgetThemeKey(Class<T> type, String name, T defaultValue, WidgetThemeParser<T> parser) {
        this(type, name, defaultValue, defaultValue, parser);
    }

    WidgetThemeKey(Class<T> type, String name, T defaultValue, T defaultHoverValue, WidgetThemeParser<T> parser) {
        this(null, type, name, null, defaultValue, defaultHoverValue, parser);
    }

    private WidgetThemeKey(@Nullable WidgetThemeKey<T> parent, Class<T> type, String name, @Nullable String subName, T defaultValue, T defaultHoverValue, WidgetThemeParser<T> parser) {
        this.parent = parent;
        this.type = type;
        this.name = name;
        this.subName = subName;
        this.defaultValue = defaultValue;
        this.defaultHoverValue = defaultHoverValue;
        this.parser = parser;
        KEYS.put(this.getFullName(), this);
        ThemeAPI.INSTANCE.registerWidgetThemeKey(this);
    }

    public WidgetThemeKey<T> createSubKey(String subName) {
        return this.createSubKey(subName, null, null);
    }

    public WidgetThemeKey<T> createSubKey(String subName, @Nullable T defaultValue, @Nullable T defaultHoverValue) {
        WidgetThemeKey<?> existing = KEYS.get(this.getName() + ":" + subName);
        if (existing != null) {
            if (existing.type == this.type) {
                return existing;
            }
            throw new IllegalStateException("A widget theme key for id " + this.getName() + ":" + subName + " already exists, but with a different types '" + existing.type.getSimpleName() + "' and '" + this.type.getSimpleName() + "'.");
        }
        return new WidgetThemeKey<T>(this, this.type, this.name, subName, defaultValue != null ? defaultValue : this.getDefaultValue(), defaultHoverValue != null ? defaultHoverValue : this.getDefaultValue(), this.parser);
    }

    @Nullable
    public WidgetThemeKey<T> getParent() {
        return this.parent;
    }

    public Class<T> getWidgetThemeType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSubName() {
        return this.subName;
    }

    public String getFullName() {
        if (this.subName != null) {
            return this.name + ":" + this.subName;
        }
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getDefaultHoverValue() {
        return this.defaultHoverValue;
    }

    public WidgetThemeParser<T> getParser() {
        return this.parser;
    }

    public boolean isSubWidgetTheme() {
        return this.parent != null;
    }

    public boolean isCompatible(WidgetTheme theme) {
        return this.type.isInstance(theme);
    }

    public boolean isExactType(WidgetTheme theme) {
        return theme != null && this.type == theme.getClass();
    }

    public boolean isOfType(Class<? extends WidgetTheme> type) {
        return type.isAssignableFrom(this.type);
    }

    public T cast(WidgetTheme theme) {
        return (T)((WidgetTheme)this.type.cast(theme));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetThemeKey that = (WidgetThemeKey)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.subName, that.subName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.subName);
    }

    @Override
    public int compareTo(@NotNull WidgetThemeKey<?> o) {
        if (o == this) {
            return 0;
        }
        int i = Boolean.compare(this.isSubWidgetTheme(), o.isSubWidgetTheme());
        if (i != 0) {
            return i;
        }
        i = this.isAncestor(o);
        if (i != 0) {
            return i;
        }
        return this.name.compareTo(o.name);
    }

    private int isAncestor(WidgetThemeKey<?> other) {
        WidgetThemeKey<Object> parent;
        for (parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != other) continue;
            return 1;
        }
        for (parent = other.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return -1;
        }
        return 0;
    }
}

