/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.utils.Vector3f;
import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.Camera;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.cleanroommc.modularui.utils.fakeworld.RenderWorld;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.SchemaWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class BaseSchemaRenderer
implements IDrawable {
    private static final Framebuffer FBO = new Framebuffer(1080, 1080, true);
    private final ISchema schema;
    private final IBlockAccess renderWorld;
    private final Framebuffer framebuffer;
    private final Camera camera = new Camera();
    private RayTraceResult lastRayTrace = null;

    public BaseSchemaRenderer(ISchema schema, Framebuffer framebuffer) {
        this.schema = schema;
        this.framebuffer = framebuffer;
        this.renderWorld = new RenderWorld(schema);
    }

    public BaseSchemaRenderer(ISchema schema) {
        this(schema, FBO);
    }

    @Nullable
    public RayTraceResult getLastRayTrace() {
        return this.lastRayTrace;
    }

    public ISchema getSchema() {
        return this.schema;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public SchemaWidget asWidget() {
        return new SchemaWidget(this);
    }

    @Override
    public Icon asIcon() {
        return IDrawable.super.asIcon().size(50);
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.render(x, y, width, height, context.getMouseX(), context.getMouseY());
    }

    protected void render(int x, int y, int width, int height, int mouseX, int mouseY) {
        this.onSetupCamera();
        int lastFbo = this.bindFBO();
        this.setupCamera(this.framebuffer.field_147621_c, this.framebuffer.field_147618_d);
        this.renderWorld();
        if (this.doRayTrace()) {
            RayTraceResult result = null;
            if (Area.isInside(x, y, width, height, mouseX, mouseY)) {
                result = this.rayTrace(mouseX, mouseY, width, height);
            }
            if (result == null) {
                if (this.lastRayTrace != null) {
                    this.onRayTraceFailed();
                }
            } else {
                this.onSuccessfulRayTrace(result);
            }
            this.lastRayTrace = result;
        }
        this.onRendered();
        Platform.setupDrawTex();
        this.resetCamera();
        this.unbindFBO(lastFbo);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        lastFbo = GL11.glGetInteger((int)3553);
        GlStateManager.func_179144_i((int)this.framebuffer.field_147617_g);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> {
            bufferBuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferBuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferBuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferBuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        });
        GlStateManager.func_179144_i((int)lastFbo);
    }

    protected RayTraceResult rayTrace(int mouseX, int mouseY, int width, int height) {
        float halfPI = 1.5707964f;
        Vector3f cameraPos = this.camera.getPos();
        float yaw = this.camera.getYaw();
        float pitch = this.camera.getPitch();
        Vector3f mouseXShift = new Vector3f(1.0f, 0.0f, 0.0f).rotatePitch(pitch).rotateYaw(-yaw + 1.5707964f).scale((float)mouseX - (float)width / 2.0f).scale(0.03125f);
        Vector3f mouseYShift = new Vector3f(0.0f, -1.0f, 0.0f).rotatePitch(pitch).rotateYaw(-yaw + 1.5707964f).scale((float)mouseY - (float)height / 2.0f).scale(0.03125f);
        Vector3f mousePos = Vector3f.add(cameraPos, mouseXShift, mouseYShift, null);
        Vector3f focus = this.camera.getLookAt();
        float perspectiveCompensation = this.isIsometric() ? 1.0f : cameraPos.distanceTo(focus) / 3.0f * (float)width / 100.0f;
        Vector3f underMousePos = focus.add(mouseXShift.scale(perspectiveCompensation), null).add(mouseYShift.scale(perspectiveCompensation));
        Vector3f look = Vector3f.sub(underMousePos, mousePos, null).scale(10.0f);
        Vector3f.add(mousePos, look, underMousePos);
        return this.schema.getWorld().func_72901_a(mousePos.toVec3d(), underMousePos.toVec3d(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderWorld() {
        Minecraft mc = Minecraft.func_71410_x();
        Platform.setupDrawTex();
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_175072_h();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        GlStateManager.func_179140_f();
        Platform.setupDrawGradient();
        List<TileEntity> tesr = null;
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (layer.ordinal() == 0 && this.isTesrEnabled()) {
                    tesr = this.renderBlocksInLayer(mc, layer, true);
                    continue;
                }
                this.renderBlocksInLayer(mc, layer, false);
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        try {
            if (tesr != null && !tesr.isEmpty()) {
                BaseSchemaRenderer.renderTesr(tesr, 0);
                if (!tesr.isEmpty()) {
                    BaseSchemaRenderer.renderTesr(tesr, 1);
                    BaseSchemaRenderer.renderTesr(tesr, 2);
                }
            }
        }
        finally {
            ForgeHooksClient.setRenderPass((int)-1);
        }
        Platform.endDrawGradient();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    private List<TileEntity> renderBlocksInLayer(Minecraft mc, BlockRenderLayer layer, boolean collectTesr) {
        ArrayList<TileEntity> tesr = collectTesr ? new ArrayList<TileEntity>() : null;
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        BaseSchemaRenderer.setDefaultPassRenderState(pass);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
        this.schema.forEach(pair -> {
            TileEntity te;
            BlockPos pos = (BlockPos)pair.getKey();
            IBlockState state = ((BlockInfo)pair.getValue()).getBlockState();
            if (state.func_177230_c().isAir(state, this.renderWorld, pos)) {
                return;
            }
            if (collectTesr && (te = ((BlockInfo)pair.getValue()).getTileEntity()) != null && !te.func_145837_r()) {
                if (!te.func_174877_v().equals((Object)pos)) {
                    te.func_174878_a(pos.func_185334_h());
                }
                if (TileEntityRendererDispatcher.field_147556_a.func_147546_a(te.getClass()) != null) {
                    tesr.add(te);
                }
            }
            if (state.func_177230_c().canRenderInLayer(state, layer)) {
                blockrendererdispatcher.func_175018_a(state, pos, this.renderWorld, buffer);
            }
        });
        Tessellator.func_178181_a().func_78381_a();
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
        return tesr;
    }

    private static void renderTesr(List<TileEntity> tileEntities, int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BaseSchemaRenderer.setDefaultPassRenderState(pass);
        Iterator<TileEntity> iterator = tileEntities.iterator();
        while (iterator.hasNext()) {
            TileEntity tile = iterator.next();
            if (tile == null || tile.func_145837_r()) continue;
            if (!(pass != 0 || tile.shouldRenderInPass(1) && tile.shouldRenderInPass(2))) {
                iterator.remove();
            }
            if (!tile.shouldRenderInPass(pass)) continue;
            BlockPos pos = tile.func_174877_v();
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f);
        }
    }

    private static void setDefaultPassRenderState(int pass) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    protected final void setupCamera(int width, int height) {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
        Color.setGlColor(this.getClearColor());
        GlStateManager.func_179086_m((int)16640);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float near = this.isIsometric() ? 1.0f : 0.1f;
        float far = 10000.0f;
        float fovY = 60.0f;
        float aspect = (float)width / (float)height;
        float top = near * (float)Math.tan(Math.toRadians(fovY) / 2.0);
        float bottom = -top;
        float left = aspect * bottom;
        float right = aspect * top;
        if (this.isIsometric()) {
            GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        } else {
            GL11.glFrustum((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        }
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        if (this.isIsometric()) {
            GlStateManager.func_179139_a((double)0.1, (double)0.1, (double)0.1);
        }
        Vector3f c = this.camera.getPos();
        Vector3f lookAt = this.camera.getLookAt();
        GLU.gluLookAt((float)c.x, (float)c.y, (float)c.z, (float)lookAt.x, (float)lookAt.y, (float)lookAt.z, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected final void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.func_179083_b((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
    }

    private int bindFBO() {
        int lastID = GL11.glGetInteger((int)36006);
        this.framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.framebuffer.func_147614_f();
        this.framebuffer.func_147610_a(true);
        GlStateManager.func_179094_E();
        return lastID;
    }

    private void unbindFBO(int lastID) {
        GlStateManager.func_179121_F();
        this.framebuffer.func_147606_d();
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)lastID);
    }

    @ApiStatus.OverrideOnly
    protected void onSetupCamera() {
    }

    @ApiStatus.OverrideOnly
    protected void onRendered() {
    }

    @ApiStatus.OverrideOnly
    protected void onSuccessfulRayTrace(@NotNull RayTraceResult result) {
    }

    @ApiStatus.OverrideOnly
    protected void onRayTraceFailed() {
    }

    public boolean doRayTrace() {
        return false;
    }

    public int getClearColor() {
        return Color.withAlpha(0, 0.5f);
    }

    public boolean isIsometric() {
        return false;
    }

    public boolean isTesrEnabled() {
        return true;
    }
}

