/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.utils.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class BlockHighlight {
    protected static final float[][] vertices = new float[6][12];
    private int color;
    private boolean allSides;
    private float frameThickness;

    public BlockHighlight(int color) {
        this(color, true, 0.0f);
    }

    public BlockHighlight(int color, float frameThickness) {
        this(color, true, frameThickness);
    }

    public BlockHighlight(int color, boolean allSides) {
        this(color, allSides, 0.0f);
    }

    public BlockHighlight(int color, boolean allSides, float frameThickness) {
        this.color = color;
        this.allSides = allSides;
        this.frameThickness = frameThickness;
    }

    public final void renderHighlight(RayTraceResult result, Vector3f camera) {
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.renderHighlight(result.func_178782_a(), result.field_178784_b, camera);
        }
    }

    public final void renderHighlight(BlockPos pos, EnumFacing side, Vector3f camera) {
        Platform.setupDrawColor();
        GlStateManager.func_179140_f();
        Color.setGlColor(this.color);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        float dist = camera.squareDistanceTo((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        this.doRender(side, dist);
        GlStateManager.func_179121_F();
    }

    protected void doRender(EnumFacing side, float sqDistance) {
        if (this.allSides) {
            side = null;
        }
        if (this.frameThickness >= 0.0f) {
            float d = (float)((double)this.frameThickness * (1.0 + Math.max(0.0, Math.sqrt(sqDistance) - 3.0) / 5.0));
            BlockHighlight.renderFrame(side, d);
        } else {
            BlockHighlight.renderSolid(side);
        }
    }

    public float getFrameThickness() {
        return this.frameThickness;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isAllSides() {
        return this.allSides;
    }

    public void setFrameThickness(float frameThickness) {
        this.frameThickness = frameThickness;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setAllSides(boolean allSides) {
        this.allSides = allSides;
    }

    protected static void renderSolid(@Nullable EnumFacing side) {
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS, builder -> {
            if (side == null) {
                for (int i = 0; i < 6; ++i) {
                    BlockHighlight.buildFace(builder, EnumFacing.field_82609_l[i]);
                }
            } else {
                BlockHighlight.buildFace(builder, side);
            }
        });
    }

    protected static void renderFrame(@Nullable EnumFacing side, float d) {
        if (side == null) {
            for (int i = 0; i < 6; ++i) {
                BlockHighlight.buildFrameFace(EnumFacing.field_82609_l[i], d);
            }
        } else {
            BlockHighlight.buildFrameFace(side, d);
        }
    }

    protected static void buildFrameFace(EnumFacing facing, float d) {
        float[] vert = vertices[facing.func_176745_a()];
        Platform.startDrawing(Platform.DrawMode.TRIANGLE_STRIP, Platform.VertexFormat.POS, builder -> {
            BlockHighlight.buildVertex(builder, vert, 9);
            BlockHighlight.buildInnerVertex(builder, vert, 9, facing, d);
            BlockHighlight.buildVertex(builder, vert, 6);
            BlockHighlight.buildInnerVertex(builder, vert, 6, facing, d);
            BlockHighlight.buildVertex(builder, vert, 3);
            BlockHighlight.buildInnerVertex(builder, vert, 3, facing, d);
            BlockHighlight.buildVertex(builder, vert, 0);
            BlockHighlight.buildInnerVertex(builder, vert, 0, facing, d);
            BlockHighlight.buildVertex(builder, vert, 9);
            BlockHighlight.buildInnerVertex(builder, vert, 9, facing, d);
        });
    }

    protected static void buildFace(BufferBuilder builder, EnumFacing facing) {
        float[] vert = vertices[facing.func_176745_a()];
        BlockHighlight.buildVertex(builder, vert, 0);
        BlockHighlight.buildVertex(builder, vert, 3);
        BlockHighlight.buildVertex(builder, vert, 6);
        BlockHighlight.buildVertex(builder, vert, 9);
    }

    protected static void buildVertex(BufferBuilder builder, float[] vertices, int i) {
        float x = vertices[i];
        float y = vertices[i + 1];
        float z = vertices[i + 2];
        builder.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
    }

    private static void buildInnerVertex(BufferBuilder builder, float[] vertices, int i, EnumFacing side, float d) {
        float x = vertices[i];
        float y = vertices[i + 1];
        float z = vertices[i + 2];
        if (side.func_176740_k() != EnumFacing.Axis.X) {
            x = x >= 1.0f ? (x -= d) : (x += d);
        }
        if (side.func_176740_k() != EnumFacing.Axis.Y) {
            y = y >= 1.0f ? (y -= d) : (y += d);
        }
        if (side.func_176740_k() != EnumFacing.Axis.Z) {
            z = z >= 1.0f ? (z -= d) : (z += d);
        }
        builder.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
    }

    static {
        int[][] intVertices = new int[][]{{1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0}, {1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0}};
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 12; ++j) {
                int v = intVertices[i][j];
                BlockHighlight.vertices[i][j] = v == 1 ? 1.005f : -0.005f;
            }
        }
    }
}

