/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.utils.Vector3f;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.Nullable;

public class Camera {
    private final Vector3f pos = new Vector3f();
    private final Vector3f lookAt = new Vector3f();
    private final Vector3f temp = new Vector3f();
    private float yaw;
    private float pitch;
    private float dist;

    public Camera setPosAndLookAt(Vector3f pos, Vector3f lookAt) {
        return this.setPosAndLookAt(pos.x, pos.y, pos.z, lookAt.x, lookAt.y, lookAt.z);
    }

    public Camera setPosAndLookAt(float xPos, float yPos, float zPos, Vector3f lookAt) {
        return this.setPosAndLookAt(xPos, yPos, zPos, lookAt.x, lookAt.y, lookAt.z);
    }

    public Camera setPosAndLookAt(Vector3f pos, float xLook, float yLook, float zLook) {
        return this.setPosAndLookAt(pos.x, pos.y, pos.z, xLook, yLook, zLook);
    }

    public Camera setPosAndLookAt(float xPos, float yPos, float zPos, float xLook, float yLook, float zLook) {
        this.pos.set(xPos, yPos, zPos);
        this.lookAt.set(xLook, yLook, zLook);
        Vector3f look = this.getLookVec(this.temp);
        Vector3f.resetUnitVectors();
        this.pitch = Vector3f.angle(look, Vector3f.UNIT_Y) + 1.5707964f;
        look.setY(0.0f);
        this.yaw = Vector3f.angle(look, Vector3f.UNIT_X);
        this.dist = this.pos.distanceTo(this.lookAt);
        return this;
    }

    public Camera setLookAtKeepPos(float x, float y, float z) {
        this.setPosAndLookAt(this.pos, x, y, z);
        return this;
    }

    public Camera setLookAtKeepAngle(float x, float y, float z) {
        this.temp.set(x, y, z);
        Vector3f.sub(this.temp, this.lookAt, this.temp);
        this.pos.add(this.temp);
        this.lookAt.set(this.temp);
        return this;
    }

    public Camera setPosKeepLookAt(float x, float y, float z) {
        return this.setPosAndLookAt(x, y, z, this.lookAt);
    }

    public Camera setPosKeepAngle(float x, float y, float z) {
        this.temp.set(x, y, z);
        Vector3f.sub(this.temp, this.pos, this.temp);
        this.lookAt.add(this.temp);
        this.pos.set(this.temp);
        return this;
    }

    public Camera setAngleKeepLookAt(float radius, float yaw, float pitch) {
        return this.setLookAtAndAngle(this.lookAt, radius, yaw, pitch);
    }

    public Camera setLookAtAndAngle(Vector3f lookAt, float radius, float yaw, float pitch) {
        return this.setLookAtAndAngle(lookAt.x, lookAt.y, lookAt.z, radius, yaw, pitch);
    }

    public Camera setLookAtAndAngle(Vec3i lookAt, float radius, float yaw, float pitch) {
        return this.setLookAtAndAngle(lookAt.func_177958_n(), lookAt.func_177956_o(), lookAt.func_177952_p(), radius, yaw, pitch);
    }

    public Camera setLookAtAndAngle(float lookAtX, float lookAtY, float lookAtZ, float dist, float yaw, float pitch) {
        this.lookAt.set(lookAtX, lookAtY, lookAtZ);
        this.yaw = yaw;
        this.pitch = pitch;
        this.dist = dist;
        Vector3f v = this.temp;
        v.set(MathUtils.cos(yaw), 0.0f, MathUtils.sin(yaw));
        v.y = MathUtils.tan(pitch) * v.length();
        v.normalise().scale(dist);
        this.pos.set(v.translate(lookAtX, lookAtY, lookAtZ));
        return this;
    }

    public Camera setPosAndAngle(float posX, float posY, float posZ, float dist, float yaw, float pitch) {
        this.pos.set(posX, posY, posZ);
        this.yaw = yaw;
        this.pitch = pitch;
        this.dist = dist;
        Vector3f v = this.temp;
        v.set(MathUtils.cos(1.5707964f - yaw), 0.0f, MathUtils.sin(1.5707964f - yaw));
        v.y = MathUtils.tan(1.5707964f - pitch) * v.length();
        v.normalise().scale(dist);
        this.lookAt.set(v).add(this.pos);
        return this;
    }

    public void setDistanceKeepLookAt(float dist) {
        if (dist == this.dist) {
            return;
        }
        this.dist = dist;
        Vector3f.sub(this.pos, this.lookAt, this.temp);
        this.temp.normalise().scale(dist);
        Vector3f.add(this.lookAt, this.temp, this.pos);
    }

    public void scaleDistanceKeepLookAt(float dist) {
        if (dist == 1.0f) {
            return;
        }
        this.dist *= dist;
        Vector3f.sub(this.pos, this.lookAt, this.temp);
        this.temp.scale(dist);
        Vector3f.add(this.lookAt, this.temp, this.pos);
    }

    public Vector3f getPos() {
        return this.pos.copy();
    }

    public Vector3f getLookAt() {
        return this.lookAt.copy();
    }

    public Vector3f getLookVec() {
        return this.getLookVec(null);
    }

    public Vector3f getLookVec(@Nullable Vector3f dest) {
        return Vector3f.sub(this.lookAt, this.pos, dest);
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getDist() {
        return this.dist;
    }
}

