/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.BlockPosUtil;
import com.cleanroommc.modularui.utils.fakeworld.DummyWorld;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaWorld
extends DummyWorld
implements ISchema {
    private final ObjectLinkedOpenHashSet<BlockPos> blocks = new ObjectLinkedOpenHashSet();
    private BiPredicate<BlockPos, BlockInfo> renderFilter;
    private final BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos();

    public SchemaWorld() {
        this((blockPos, blockInfo) -> true);
    }

    public SchemaWorld(BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    public void setRenderFilter(@Nullable BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Nullable
    public BiPredicate<BlockPos, BlockInfo> getRenderFilter() {
        return this.renderFilter;
    }

    public boolean func_180501_a(@NotNull BlockPos pos, @NotNull IBlockState newState, int flags) {
        boolean state;
        boolean renderTest;
        if (this.renderFilter == null || this.renderFilter.test(pos, BlockInfo.of((IBlockAccess)this, pos))) {
            renderTest = true;
            state = super.func_180501_a(pos, newState, flags);
        } else {
            state = false;
            renderTest = false;
        }
        if (newState.func_177230_c().isAir(newState, (IBlockAccess)this, pos)) {
            if (this.blocks.remove((Object)pos) && BlockPosUtil.isOnBorder((BlockPos)this.min, (BlockPos)this.max, pos)) {
                if (this.blocks.isEmpty()) {
                    this.min.func_181079_c(0, 0, 0);
                    this.max.func_181079_c(0, 0, 0);
                } else {
                    this.min.func_189533_g((Vec3i)BlockPosUtil.MAX);
                    this.max.func_189533_g((Vec3i)BlockPosUtil.MIN);
                    for (BlockPos pos1 : this.blocks) {
                        BlockPosUtil.setMin(this.min, pos1);
                        BlockPosUtil.setMax(this.max, pos1);
                    }
                }
            }
        } else if (this.blocks.isEmpty()) {
            if (!renderTest) {
                return false;
            }
            this.blocks.add((Object)pos);
            this.min.func_189533_g((Vec3i)pos);
            this.max.func_189533_g((Vec3i)pos);
        } else if (renderTest && this.blocks.add((Object)pos)) {
            BlockPosUtil.setMin(this.min, pos);
            BlockPosUtil.setMax(this.max, pos);
        }
        return renderTest && state;
    }

    @Override
    public World getWorld() {
        return this;
    }

    @Override
    public Vec3d getFocus() {
        return BlockPosUtil.getCenterD((BlockPos)this.min, (BlockPos)this.max);
    }

    @Override
    public BlockPos getOrigin() {
        return this.min;
    }

    @Override
    @NotNull
    public Iterator<Pair<BlockPos, BlockInfo>> iterator() {
        return new AbstractIterator<Pair<BlockPos, BlockInfo>>(){
            private final ObjectListIterator<BlockPos> it;
            private final BlockInfo.Mut info;
            private final MutablePair<BlockPos, BlockInfo> pair;
            {
                this.it = SchemaWorld.this.blocks.iterator();
                this.info = new BlockInfo.Mut();
                this.pair = new MutablePair(null, (Object)this.info);
            }

            protected Pair<BlockPos, BlockInfo> computeNext() {
                while (this.it.hasNext()) {
                    BlockPos pos = (BlockPos)this.it.next();
                    this.info.set((IBlockAccess)SchemaWorld.this, pos);
                    this.pair.setLeft((Object)pos);
                    if (SchemaWorld.this.renderFilter != null && !SchemaWorld.this.renderFilter.test(pos, this.info)) continue;
                    return this.pair;
                }
                return (Pair)this.endOfData();
            }
        };
    }
}

