/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.PlayerSlotType;
import java.io.IOException;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ItemSlotSH
extends SyncHandler {
    public static final int SYNC_ITEM = 1;
    public static final int SYNC_ENABLED = 2;
    private final ModularSlot slot;
    private final PlayerSlotType playerSlotType;
    private ItemStack lastStoredItem;
    private boolean registered = false;

    public ItemSlotSH(ModularSlot slot) {
        this.slot = slot;
        this.playerSlotType = PlayerSlotType.getPlayerSlotType((Slot)slot);
    }

    @Override
    public void init(String key, PanelSyncManager syncHandler) {
        super.init(key, syncHandler);
        if (!this.registered) {
            this.slot.initialize(this, this.isPhantom());
            this.getSyncManager().getContainer().registerSlot(this.getSyncManager().getPanelName(), this.slot);
            this.registered = true;
        }
        this.lastStoredItem = this.getSlot().func_75211_c().func_77946_l();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.slot.dispose();
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        ItemStack itemStack = this.getSlot().func_75211_c();
        if (itemStack.func_190926_b() && this.lastStoredItem.func_190926_b()) {
            return;
        }
        boolean onlyAmountChanged = false;
        if (init || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastStoredItem, (ItemStack)itemStack) || (onlyAmountChanged = itemStack.func_190916_E() != this.lastStoredItem.func_190916_E())) {
            this.onSlotUpdate(itemStack, onlyAmountChanged, false, init);
            if (onlyAmountChanged) {
                this.lastStoredItem.func_190920_e(itemStack.func_190916_E());
            } else {
                this.lastStoredItem = itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l();
            }
            boolean finalOnlyAmountChanged = onlyAmountChanged;
            boolean forceSync = false;
            this.syncToClient(1, buffer -> {
                buffer.writeBoolean(finalOnlyAmountChanged);
                buffer.func_150788_a(itemStack);
                buffer.writeBoolean(init);
                buffer.writeBoolean(false);
            });
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 1) {
            boolean onlyAmountChanged = buf.readBoolean();
            this.lastStoredItem = NetworkUtils.readItemStack(buf);
            this.onSlotUpdate(this.lastStoredItem, onlyAmountChanged, true, buf.readBoolean());
            if (buf.readBoolean()) {
                this.slot.func_75215_d(this.lastStoredItem);
            }
        } else if (id == 2) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 2) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    protected void onSlotUpdate(ItemStack stack, boolean onlyAmountChanged, boolean client, boolean init) {
        this.getSlot().onSlotChangedReal(stack, onlyAmountChanged, client, init);
    }

    public void setEnabled(boolean enabled, boolean sync) {
        this.slot.setEnabled(enabled);
        if (sync) {
            this.sync(2, buffer -> buffer.writeBoolean(enabled));
        }
    }

    public void forceSyncItem() {
        boolean onlyAmountChanged = false;
        ItemStack stack = this.slot.func_75211_c();
        boolean init = false;
        boolean forceSync = true;
        this.onSlotUpdate(stack, onlyAmountChanged, this.getSyncManager().isClient(), init);
        this.lastStoredItem = stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        this.syncToClient(1, buffer -> {
            buffer.writeBoolean(onlyAmountChanged);
            buffer.func_150788_a(stack);
            buffer.writeBoolean(init);
            buffer.writeBoolean(forceSync);
        });
    }

    public ModularSlot getSlot() {
        return this.slot;
    }

    public boolean isItemValid(ItemStack itemStack) {
        return this.getSlot().func_75214_a(itemStack);
    }

    public boolean isPhantom() {
        return false;
    }

    @Nullable
    public PlayerSlotType getPlayerSlotType() {
        return this.playerSlotType;
    }

    public boolean isPlayerSlot() {
        return this.playerSlotType != null;
    }

    @Nullable
    public String getSlotGroup() {
        return this.slot.getSlotGroupName();
    }
}

