/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;

public class PhantomItemSlotSH
extends ItemSlotSH {
    public static final int SYNC_CLICK = 100;
    public static final int SYNC_SCROLL = 101;
    public static final int SYNC_ITEM_SIMPLE = 102;
    private ItemStack lastStoredPhantomItem = ItemStack.field_190927_a;

    @ApiStatus.Internal
    public PhantomItemSlotSH(ModularSlot slot) {
        super(slot);
    }

    @Override
    public void init(String key, PanelSyncManager syncHandler) {
        super.init(key, syncHandler);
        if (this.isPhantom() && !this.getSlot().func_75211_c().func_190926_b()) {
            this.lastStoredPhantomItem = this.getSlot().func_75211_c().func_77946_l();
            this.lastStoredPhantomItem.func_190920_e(1);
        }
    }

    @Override
    protected void onSlotUpdate(ItemStack stack, boolean onlyAmountChanged, boolean client, boolean init) {
        this.getSlot().func_75215_d(stack);
        if (!onlyAmountChanged && !stack.func_190926_b()) {
            this.lastStoredPhantomItem = stack.func_77946_l();
            this.lastStoredPhantomItem.func_190920_e(1);
        }
        super.onSlotUpdate(stack, onlyAmountChanged, client, init);
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        super.readOnServer(id, buf);
        if (id == 100) {
            this.phantomClick(MouseData.readPacket(buf));
        } else if (id == 101) {
            this.phantomScroll(MouseData.readPacket(buf));
        } else if (id == 102) {
            if (!this.isPhantom()) {
                return;
            }
            this.phantomClick(new MouseData(Side.SERVER, 0, false, false, false), buf.func_150791_c());
        }
    }

    public void updateFromClient(ItemStack stack) {
        this.syncToServer(102, buf -> buf.func_150788_a(stack));
    }

    protected void phantomClick(MouseData mouseData) {
        this.phantomClick(mouseData, this.getSyncManager().getCursorItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(MouseData mouseData, ItemStack cursorStack) {
        ItemStack slotStack = this.getSlot().func_75211_c();
        if (!(cursorStack.func_190926_b() || slotStack.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)cursorStack, (ItemStack)slotStack))) {
            if (!this.isItemValid(cursorStack)) {
                return;
            }
            ItemStack stackToPut = cursorStack.func_77946_l();
            if (mouseData.mouseButton == 1) {
                stackToPut.func_190920_e(1);
            }
            stackToPut.func_190920_e(Math.min(stackToPut.func_190916_E(), this.getSlot().func_178170_b(stackToPut)));
            this.getSlot().func_75215_d(stackToPut);
            this.lastStoredPhantomItem = stackToPut.func_77946_l();
            return;
        } else if (slotStack.func_190926_b()) {
            ItemStack stackToPut;
            if (cursorStack.func_190926_b()) {
                if (mouseData.mouseButton != 1 || this.lastStoredPhantomItem.func_190926_b()) return;
                stackToPut = this.lastStoredPhantomItem.func_77946_l();
            } else {
                if (!this.isItemValid(cursorStack)) {
                    return;
                }
                stackToPut = cursorStack.func_77946_l();
            }
            if (mouseData.mouseButton == 1) {
                stackToPut.func_190920_e(1);
            }
            stackToPut.func_190920_e(Math.min(stackToPut.func_190916_E(), this.getSlot().func_178170_b(stackToPut)));
            this.getSlot().func_75215_d(stackToPut);
            this.lastStoredPhantomItem = stackToPut.func_77946_l();
            return;
        } else if (mouseData.mouseButton == 0) {
            if (mouseData.shift) {
                this.getSlot().func_75215_d(ItemStack.field_190927_a);
                return;
            } else {
                this.incrementStackCount(-1);
            }
            return;
        } else {
            if (mouseData.mouseButton != 1) return;
            this.incrementStackCount(1);
        }
    }

    protected void phantomScroll(MouseData mouseData) {
        ItemStack currentItem = this.getSlot().func_75211_c();
        int amount = mouseData.mouseButton;
        if (mouseData.shift) {
            amount *= 4;
        }
        if (mouseData.ctrl) {
            amount *= 16;
        }
        if (mouseData.alt) {
            amount *= 64;
        }
        if (amount > 0 && currentItem.func_190926_b() && !this.lastStoredPhantomItem.func_190926_b()) {
            ItemStack stackToPut = this.lastStoredPhantomItem.func_77946_l();
            stackToPut.func_190920_e(amount);
            this.getSlot().func_75215_d(stackToPut);
        } else {
            this.incrementStackCount(amount);
        }
    }

    public void incrementStackCount(int amount) {
        ItemStack stack = this.getSlot().func_75211_c();
        if (stack.func_190926_b()) {
            return;
        }
        int oldAmount = stack.func_190916_E();
        if (amount < 0) {
            amount = Math.max(0, oldAmount + amount);
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            int maxSize = this.getSlot().func_75219_a();
            if (!this.getSlot().isIgnoreMaxStackSize() && stack.func_77976_d() < maxSize) {
                maxSize = stack.func_77976_d();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack = stack.func_77946_l();
            stack.func_190920_e(amount);
            this.getSlot().func_75215_d(stack);
        }
    }

    @Override
    public boolean isPhantom() {
        return true;
    }
}

