/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.ScrollData;

public class VerticalScrollData
extends ScrollData {
    public VerticalScrollData() {
        this(false, -1);
    }

    public VerticalScrollData(boolean leftAlignment) {
        this(leftAlignment, -1);
    }

    public VerticalScrollData(boolean leftAlignment, int thickness) {
        super(GuiAxis.Y, leftAlignment, thickness);
    }

    public VerticalScrollData cancelScrollEdge(boolean cancelScrollEdge) {
        this.setCancelScrollEdge(cancelScrollEdge);
        return this;
    }

    @Override
    protected int getFallbackThickness(WidgetTheme widgetTheme) {
        return widgetTheme.getDefaultWidth();
    }

    @Override
    public HorizontalScrollData getOtherScrollData(ScrollArea area) {
        return area.getScrollX();
    }

    @Override
    public boolean isInsideScrollbarArea(ScrollArea area, int x, int y) {
        if (!this.isScrollBarActive(area)) {
            return false;
        }
        int scrollbar = this.getThickness();
        HorizontalScrollData data = this.getOtherScrollData(area);
        if (data != null && this.isOtherScrollBarActive(area, true)) {
            int thickness = data.getThickness();
            if (data.isOnAxisStart() ? y < thickness : y >= area.h() - thickness) {
                return false;
            }
        }
        return this.isOnAxisStart() ? x >= 0 && x < scrollbar : x >= area.w() - scrollbar && x < area.w();
    }

    @Override
    public void drawScrollbar(ScrollArea area, ModularGuiContext context, WidgetTheme widgetTheme) {
        boolean isOtherActive = this.isOtherScrollBarActive(area, true);
        int l = this.getScrollBarLength(area);
        int x = this.isOnAxisStart() ? 0 : area.w() - this.getThickness();
        int y = 0;
        int w = this.getThickness();
        int h = area.height;
        GuiDraw.drawRect(x, y, w, h, area.getScrollBarBackgroundColor());
        y = this.getScrollBarStart(area, l, isOtherActive);
        HorizontalScrollData data2 = this.getOtherScrollData(area);
        if (data2 != null && isOtherActive && data2.isOnAxisStart()) {
            y += data2.getThickness();
        }
        h = l;
        this.drawScrollBar(context, x, y, w, h, widgetTheme);
    }
}

