/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.value.sync.DynamicSyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DynamicSyncedWidget<W extends DynamicSyncedWidget<W>>
extends Widget<W> {
    private DynamicSyncHandler syncHandler;
    private IWidget child;

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof DynamicSyncHandler) {
            DynamicSyncHandler dynamicSyncHandler;
            this.syncHandler = dynamicSyncHandler = (DynamicSyncHandler)syncHandler;
            dynamicSyncHandler.onWidgetUpdate(this::updateChild);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        if (this.child == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.child);
    }

    private void updateChild(IWidget widget) {
        this.child = widget;
        if (this.isValid()) {
            this.child.initialise(this, true);
            this.scheduleResize();
        }
    }

    public W syncHandler(DynamicSyncHandler syncHandler) {
        this.syncHandler = syncHandler;
        this.setSyncHandler(syncHandler);
        syncHandler.onWidgetUpdate(this::updateChild);
        return (W)((DynamicSyncedWidget)this.getThis());
    }
}

