/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.UpOrDown;
import com.cleanroommc.modularui.api.drawable.IHoverable;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.widget.Widget;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichTextWidget
extends Widget<RichTextWidget>
implements IRichTextBuilder<RichTextWidget>,
Interactable {
    private final RichText text = new RichText();
    private Consumer<RichText> builder;
    private boolean dirty = false;
    private boolean autoUpdate = false;

    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        super.draw(context, widgetTheme);
        if (this.autoUpdate || this.dirty) {
            if (this.builder != null) {
                this.text.clearText();
                this.builder.accept(this.text);
            }
            this.dirty = false;
        }
        this.text.drawAtZero(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        super.drawForeground(context);
        Object object = this.getHoveredElement(context);
        if (object instanceof IHoverable) {
            IHoverable hoverable = (IHoverable)object;
            hoverable.onHover();
            RichTooltip tooltip = hoverable.getTooltip();
            if (tooltip != null) {
                tooltip.draw(context);
            }
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMousePressed(mouseButton);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseRelease(mouseButton);
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(int mouseButton) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseTapped(mouseButton);
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char typedChar, int keyCode) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onKeyPressed(typedChar, keyCode);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onKeyRelease(char typedChar, int keyCode) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onKeyRelease(typedChar, keyCode);
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyTapped(char typedChar, int keyCode) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onKeyTapped(typedChar, keyCode);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseScroll(UpOrDown scrollDirection, int amount) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseScroll(scrollDirection, amount);
        }
        return false;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            interactable.onMouseDrag(mouseButton, timeSinceClick);
        }
    }

    @Nullable
    public Object getHoveredElement() {
        return this.getHoveredElement(this.getContext());
    }

    @Nullable
    public Object getHoveredElement(ModularGuiContext context) {
        if (!this.isHovering()) {
            return null;
        }
        return this.text.getHoveringElement(context);
    }

    @Override
    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public RichTextWidget autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public RichTextWidget textBuilder(Consumer<RichText> builder) {
        this.builder = builder;
        this.markDirty();
        return this;
    }
}

