/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.ArgumentParameter;
import org.mariuszgromada.math.mxparser.CalcStepRecord;
import org.mariuszgromada.math.mxparser.CalcStepsRegister;
import org.mariuszgromada.math.mxparser.CloneCache;
import org.mariuszgromada.math.mxparser.CompilationDetails;
import org.mariuszgromada.math.mxparser.CompiledElement;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.DescKwLenComparator;
import org.mariuszgromada.math.mxparser.ExpressionUtils;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.FunctionParameter;
import org.mariuszgromada.math.mxparser.IterativeOperatorParameters;
import org.mariuszgromada.math.mxparser.KwStrComparator;
import org.mariuszgromada.math.mxparser.License;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.SerializationUtils;
import org.mariuszgromada.math.mxparser.StringInvariant;
import org.mariuszgromada.math.mxparser.StringModel;
import org.mariuszgromada.math.mxparser.StringUtils;
import org.mariuszgromada.math.mxparser.SyntaxStackElement;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.TokenPart;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.BooleanAlgebra;
import org.mariuszgromada.math.mxparser.mathcollection.Calculus;
import org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.Statistics;
import org.mariuszgromada.math.mxparser.mathcollection.Units;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;
import org.mariuszgromada.math.mxparser.syntaxchecker.SyntaxChecker;

public class Expression
extends PrimitiveElement
implements Serializable {
    private static final int serialClassID = 6;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(6);
    public static final int TYPE_ID = 100;
    public static String TYPE_DESC = "<NA>";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    static final boolean INTERNAL = true;
    private static final boolean WITH_EXP_STR = true;
    private static final boolean NO_EXP_STR = false;
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR = false;
    @Deprecated
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    private static final boolean SYNTAX_STATUS_UNKNOWN = false;
    String expressionString = "";
    private String expressionStringCleaned = "";
    private String description = "";
    List<Argument> argumentsList = null;
    List<Function> functionsList = null;
    List<Constant> constantsList = null;
    private List<KeyWord> keyWordsList = null;
    List<Token> initialTokens = null;
    private CompilationDetails initialCompilationDetails = null;
    private Set<String> neverParseForImpliedMultiplication = null;
    private List<Token> tokensList = null;
    private CompilationDetails compilationDetails = null;
    List<Expression> relatedExpressionsList = null;
    double computingTime = 0.0;
    boolean expressionWasModified = false;
    boolean recursiveMode = false;
    private boolean verboseMode = false;
    private boolean impliedMultiplicationMode = mXparser.impliedMultiplicationMode;
    private boolean impliedMultiplicationError = false;
    boolean disableRounding = false;
    static final boolean DISABLE_ROUNDING = true;
    static final boolean KEEP_ROUNDING_SETTINGS = false;
    private boolean syntaxStatus = false;
    private boolean isFullyCompiled = false;
    private String errorMessage = "";
    private String errorMessageCalculate = "";
    private static final int ERROR_MESSAGE_CALCULATE_MAXIMUM_LENGTH = 2000;
    private boolean recursionCallPending = false;
    private int recursionCallsCounter = 0;
    private boolean parserKeyWordsOnly = false;
    private boolean unicodeKeyWordsEnabled = mXparser.unicodeKeyWordsEnabled;
    private boolean attemptToFixExpStrEnabled = mXparser.attemptToFixExpStrEnabled;
    boolean UDFExpression = false;
    List<Double> UDFVariadicParamsAtRunTime = null;
    private boolean internalClone = false;
    private boolean forwardErrorMessage = true;
    private int optionsChangesetNumber = -1;
    private static final double PP = Math.round(3.141592653589793E8);
    private static final double EE = Math.round(2.718281828459045E8);
    private static final double GG = Math.round(1.6180339887498948E8);

    void addRelatedExpression(Expression expression) {
        if (expression == null || expression == this) {
            return;
        }
        if (!this.relatedExpressionsList.contains(expression)) {
            this.relatedExpressionsList.add(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        this.relatedExpressionsList.remove(expression);
    }

    void showRelatedExpressions() {
        mXparser.consolePrintln();
        mXparser.consolePrintln(this.description + " = " + this.expressionString + ":");
        for (Expression e : this.relatedExpressionsList) {
            mXparser.consolePrintln("-> " + e.description + " = " + e.expressionString);
        }
    }

    public String getErrorMessage() {
        return StringUtils.cleanNewLineAtTheEnd(this.errorMessage);
    }

    public boolean getSyntaxStatus() {
        return this.syntaxStatus;
    }

    void setSyntaxStatus(boolean syntaxStatus, String errorMessage) {
        this.syntaxStatus = syntaxStatus;
        this.errorMessage = errorMessage;
        this.expressionWasModified = false;
        this.markAsNotFullyCompiled();
    }

    void markAsNotFullyCompiled() {
        this.isFullyCompiled = false;
        this.initialCompilationDetails = null;
    }

    void setExpressionModifiedFlag() {
        if (this.recursionCallPending) {
            return;
        }
        this.recursionCallPending = true;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.expressionWasModified = true;
        this.syntaxStatus = false;
        this.markAsNotFullyCompiled();
        this.errorMessage = "";
        for (Expression e : this.relatedExpressionsList) {
            e.setExpressionModifiedFlag();
        }
        this.recursionCallPending = false;
    }

    private void expressionInternalVarsInit() {
        this.description = "";
        this.errorMessage = "";
        this.errorMessageCalculate = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.forwardErrorMessage = true;
        this.parserKeyWordsOnly = false;
        this.verboseMode = false;
        this.syntaxStatus = false;
        this.isFullyCompiled = false;
        this.impliedMultiplicationMode = mXparser.impliedMultiplicationMode;
        this.unicodeKeyWordsEnabled = mXparser.unicodeKeyWordsEnabled;
        this.attemptToFixExpStrEnabled = mXparser.attemptToFixExpStrEnabled;
        this.disableRounding = false;
    }

    private void expressionInit() {
        this.argumentsList = new ArrayList<Argument>();
        this.functionsList = new ArrayList<Function>();
        this.constantsList = new ArrayList<Constant>();
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.expressionInternalVarsInit();
    }

    public Expression(PrimitiveElement ... elements) {
        super(100);
        this.expressionString = "";
        this.expressionInit();
        this.setExpressionModifiedFlag();
        this.addDefinitions(elements);
    }

    public Expression(String expressionString, PrimitiveElement ... elements) {
        super(100);
        this.expressionInit();
        this.expressionString = expressionString;
        this.setExpressionModifiedFlag();
        this.addDefinitions(elements);
    }

    Expression(String expressionString, boolean parserKeyWordsOnly) {
        super(100);
        this.expressionInit();
        this.expressionString = expressionString;
        this.setExpressionModifiedFlag();
        this.parserKeyWordsOnly = parserKeyWordsOnly;
    }

    Expression(String expressionString, List<Token> initialTokens, List<Argument> argumentsList, List<Function> functionsList, List<Constant> constantsList, boolean disableUlpRounding, boolean UDFExpression, List<Double> UDFVariadicParamsAtRunTime) {
        super(100);
        this.expressionString = expressionString;
        this.initialTokens = initialTokens;
        this.argumentsList = argumentsList;
        this.functionsList = functionsList;
        this.constantsList = constantsList;
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.expressionWasModified = false;
        this.syntaxStatus = true;
        this.isFullyCompiled = false;
        this.description = "{internal}";
        this.errorMessage = "";
        this.errorMessageCalculate = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.forwardErrorMessage = true;
        this.parserKeyWordsOnly = false;
        this.verboseMode = false;
        this.impliedMultiplicationMode = mXparser.impliedMultiplicationMode;
        this.unicodeKeyWordsEnabled = mXparser.unicodeKeyWordsEnabled;
        this.attemptToFixExpStrEnabled = mXparser.attemptToFixExpStrEnabled;
        this.UDFExpression = UDFExpression;
        this.UDFVariadicParamsAtRunTime = UDFVariadicParamsAtRunTime;
        this.disableRounding = disableUlpRounding;
        this.setSilentMode();
        this.disableRecursiveMode();
    }

    Expression(String expressionString, List<Argument> argumentsList, List<Function> functionsList, List<Constant> constantsList, boolean internal, boolean UDFExpression, List<Double> UDFVariadicParamsAtRunTime) {
        super(100);
        this.expressionString = expressionString;
        this.expressionInternalVarsInit();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.argumentsList = argumentsList;
        this.functionsList = functionsList;
        this.constantsList = constantsList;
        this.UDFExpression = UDFExpression;
        this.UDFVariadicParamsAtRunTime = UDFVariadicParamsAtRunTime;
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.setExpressionModifiedFlag();
    }

    private Expression(Expression expressionToClone, boolean isThreadSafeClone, CloneCache cloneCache) {
        super(100);
        this.expressionString = expressionToClone.expressionString;
        this.expressionStringCleaned = expressionToClone.expressionStringCleaned;
        this.description = expressionToClone.description;
        this.computingTime = expressionToClone.computingTime;
        this.expressionWasModified = expressionToClone.expressionWasModified;
        this.recursiveMode = expressionToClone.recursiveMode;
        this.verboseMode = expressionToClone.verboseMode;
        this.impliedMultiplicationMode = expressionToClone.impliedMultiplicationMode;
        this.impliedMultiplicationError = expressionToClone.impliedMultiplicationError;
        this.disableRounding = expressionToClone.disableRounding;
        this.syntaxStatus = expressionToClone.syntaxStatus;
        this.isFullyCompiled = expressionToClone.isFullyCompiled;
        this.errorMessage = expressionToClone.errorMessage;
        this.errorMessageCalculate = expressionToClone.errorMessageCalculate;
        this.recursionCallPending = expressionToClone.recursionCallPending;
        this.recursionCallsCounter = expressionToClone.recursionCallsCounter;
        this.parserKeyWordsOnly = expressionToClone.parserKeyWordsOnly;
        this.unicodeKeyWordsEnabled = expressionToClone.unicodeKeyWordsEnabled;
        this.attemptToFixExpStrEnabled = expressionToClone.attemptToFixExpStrEnabled;
        this.UDFExpression = expressionToClone.UDFExpression;
        this.forwardErrorMessage = expressionToClone.forwardErrorMessage;
        this.optionsChangesetNumber = expressionToClone.optionsChangesetNumber;
        this.keyWordsList = expressionToClone.keyWordsList;
        this.UDFVariadicParamsAtRunTime = expressionToClone.UDFVariadicParamsAtRunTime;
        this.neverParseForImpliedMultiplication = expressionToClone.neverParseForImpliedMultiplication;
        if (isThreadSafeClone) {
            this.internalClone = expressionToClone.internalClone;
            this.relatedExpressionsList = new ArrayList<Expression>();
            this.argumentsList = ExpressionUtils.cloneForThreadSafeArgumenstList(this, expressionToClone.argumentsList, cloneCache);
            this.functionsList = ExpressionUtils.cloneForThreadSafeFunctionsList(this, expressionToClone.functionsList, cloneCache);
            this.constantsList = ExpressionUtils.cloneForThreadSafeConstantsList(this, expressionToClone.constantsList, cloneCache);
            return;
        }
        this.internalClone = true;
        this.argumentsList = expressionToClone.argumentsList;
        this.functionsList = expressionToClone.functionsList;
        this.constantsList = expressionToClone.constantsList;
        this.relatedExpressionsList = expressionToClone.relatedExpressionsList;
    }

    public void setExpressionString(String expressionString) {
        this.expressionString = expressionString;
        this.expressionStringCleaned = "";
        this.setExpressionModifiedFlag();
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public String getCanonicalExpressionString() {
        StringBuilder canonicalExpression = new StringBuilder();
        for (Token t : this.getCopyOfInitialTokens()) {
            canonicalExpression.append(t.tokenStr);
        }
        return canonicalExpression.toString();
    }

    public void clearExpressionString() {
        this.expressionString = "";
        this.expressionStringCleaned = "";
        this.setExpressionModifiedFlag();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void clearDescription() {
        this.description = "";
    }

    public void setVerboseMode() {
        this.verboseMode = true;
    }

    public void setSilentMode() {
        this.verboseMode = false;
    }

    public boolean getVerboseMode() {
        return this.verboseMode;
    }

    public void enableImpliedMultiplicationMode() {
        if (this.impliedMultiplicationMode) {
            return;
        }
        this.impliedMultiplicationMode = true;
        this.setExpressionModifiedFlag();
    }

    public void disableImpliedMultiplicationMode() {
        if (!this.impliedMultiplicationMode) {
            return;
        }
        this.impliedMultiplicationMode = false;
        this.setExpressionModifiedFlag();
    }

    public boolean checkIfImpliedMultiplicationMode() {
        return this.impliedMultiplicationMode;
    }

    public void enableUnicodeBuiltinKeyWordsMode() {
        if (this.unicodeKeyWordsEnabled) {
            return;
        }
        this.unicodeKeyWordsEnabled = true;
        this.setExpressionModifiedFlag();
    }

    public void disableUnicodeBuiltinKeyWordsMode() {
        if (!this.unicodeKeyWordsEnabled) {
            return;
        }
        this.unicodeKeyWordsEnabled = false;
        this.setExpressionModifiedFlag();
    }

    public boolean checkIfUnicodeBuiltinKeyWordsMode() {
        return this.unicodeKeyWordsEnabled;
    }

    public void enableAttemptToFixExpStrMode() {
        if (this.attemptToFixExpStrEnabled) {
            return;
        }
        this.attemptToFixExpStrEnabled = true;
        this.setExpressionModifiedFlag();
    }

    public void disableAttemptToFixExpStrMode() {
        if (!this.attemptToFixExpStrEnabled) {
            return;
        }
        this.attemptToFixExpStrEnabled = false;
        this.setExpressionModifiedFlag();
    }

    public boolean checkIfAttemptToFixExpStrMode() {
        return this.attemptToFixExpStrEnabled;
    }

    void setRecursiveMode() {
        this.recursiveMode = true;
    }

    void disableRecursiveMode() {
        this.recursiveMode = false;
    }

    public boolean getRecursiveMode() {
        return this.recursiveMode;
    }

    void setForwardErrorMessage(boolean forward) {
        if (forward == this.forwardErrorMessage) {
            return;
        }
        this.errorMessage = "";
        this.errorMessageCalculate = "";
        this.forwardErrorMessage = forward;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        block5: for (PrimitiveElement e : elements) {
            if (e == null) continue;
            switch (e.getMyTypeId()) {
                case 101: 
                case 102: {
                    this.addArguments((Argument)e);
                    continue block5;
                }
                case 104: {
                    this.addConstants((Constant)e);
                    continue block5;
                }
                case 103: {
                    this.addFunctions((Function)e);
                }
            }
        }
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        block5: for (PrimitiveElement e : elements) {
            if (e == null) continue;
            switch (e.getMyTypeId()) {
                case 101: 
                case 102: {
                    this.removeArguments((Argument)e);
                    continue block5;
                }
                case 104: {
                    this.removeConstants((Constant)e);
                    continue block5;
                }
                case 103: {
                    this.removeFunctions((Function)e);
                }
            }
        }
    }

    public void addArguments(Argument ... arguments) {
        for (Argument arg : arguments) {
            if (arg == null) continue;
            this.argumentsList.add(arg);
            if (arg.getArgumentBodyType() != 1) continue;
            arg.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArguments(String ... argumentsNames) {
        for (String argName : argumentsNames) {
            Argument arg = new Argument(argName, new PrimitiveElement[0]);
            arg.addRelatedExpression(this);
            this.argumentsList.add(arg);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArgument(String argumentName, double argumentValue) {
        Argument arg = new Argument(argumentName, argumentValue);
        arg.addRelatedExpression(this);
        this.argumentsList.add(arg);
        this.setExpressionModifiedFlag();
    }

    public int getArgumentIndex(String argumentName) {
        int argumentsNumber = this.argumentsList.size();
        if (argumentsNumber == 0) {
            return -1;
        }
        for (int argumentIndex = 0; argumentIndex < argumentsNumber; ++argumentIndex) {
            if (!this.argumentsList.get(argumentIndex).getArgumentName().equals(argumentName)) continue;
            return argumentIndex;
        }
        return -1;
    }

    public Argument getArgument(String argumentName) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex == -1) {
            return null;
        }
        return this.argumentsList.get(argumentIndex);
    }

    public Argument getArgument(int argumentIndex) {
        if (argumentIndex < 0 || argumentIndex >= this.argumentsList.size()) {
            return null;
        }
        return this.argumentsList.get(argumentIndex);
    }

    public int getArgumentsNumber() {
        return this.argumentsList.size();
    }

    public void setArgumentValue(String argumentName, double argumentValue) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex != -1) {
            this.argumentsList.get(argumentIndex).setArgumentValue(argumentValue);
        }
    }

    public double getArgumentValue(String argumentName) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex == -1) {
            return Double.NaN;
        }
        return this.argumentsList.get(argumentIndex).getArgumentValue();
    }

    public void removeArguments(String ... argumentsNames) {
        for (String argumentName : argumentsNames) {
            int argumentIndex = this.getArgumentIndex(argumentName);
            if (argumentIndex == -1) continue;
            Argument arg = this.argumentsList.get(argumentIndex);
            arg.removeRelatedExpression(this);
            this.argumentsList.remove(argumentIndex);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeArguments(Argument ... arguments) {
        for (Argument argument : arguments) {
            if (argument == null) continue;
            this.argumentsList.remove(argument);
            argument.removeRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllArguments() {
        for (Argument arg : this.argumentsList) {
            arg.removeRelatedExpression(this);
        }
        this.argumentsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addConstants(Constant ... constants) {
        for (Constant constant : constants) {
            if (constant == null) continue;
            this.constantsList.add(constant);
            constant.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void addConstants(List<Constant> constantsList) {
        for (Constant c : constantsList) {
            this.constantsList.add(c);
            c.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineConstant(String constantName, double constantValue) {
        Constant c = new Constant(constantName, constantValue);
        c.addRelatedExpression(this);
        this.constantsList.add(c);
        this.setExpressionModifiedFlag();
    }

    public int getConstantIndex(String constantName) {
        int constantsNumber = this.constantsList.size();
        if (constantsNumber == 0) {
            return -1;
        }
        for (int constantIndex = 0; constantIndex < constantsNumber; ++constantIndex) {
            if (!this.constantsList.get(constantIndex).getConstantName().equals(constantName)) continue;
            return constantIndex;
        }
        return -1;
    }

    public Constant getConstant(String constantName) {
        int constantIndex = this.getConstantIndex(constantName);
        if (constantIndex == -1) {
            return null;
        }
        return this.constantsList.get(constantIndex);
    }

    public Constant getConstant(int constantIndex) {
        if (constantIndex < 0 || constantIndex >= this.constantsList.size()) {
            return null;
        }
        return this.constantsList.get(constantIndex);
    }

    public int getConstantsNumber() {
        return this.constantsList.size();
    }

    public void removeConstants(String ... constantsNames) {
        for (String constantName : constantsNames) {
            int constantIndex = this.getConstantIndex(constantName);
            if (constantIndex == -1) continue;
            Constant c = this.constantsList.get(constantIndex);
            c.removeRelatedExpression(this);
            this.constantsList.remove(constantIndex);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeConstants(Constant ... constants) {
        for (Constant constant : constants) {
            if (constant == null) continue;
            this.constantsList.remove(constant);
            constant.removeRelatedExpression(this);
            this.setExpressionModifiedFlag();
        }
    }

    public void removeAllConstants() {
        for (Constant c : this.constantsList) {
            c.removeRelatedExpression(this);
        }
        this.constantsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addFunctions(Function ... functions) {
        for (Function f : functions) {
            if (f == null) continue;
            this.functionsList.add(f);
            if (f.getFunctionBodyType() != 1) continue;
            f.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        Function f = new Function(functionName, functionExpressionString, argumentsNames);
        this.functionsList.add(f);
        f.addRelatedExpression(this);
        this.setExpressionModifiedFlag();
    }

    public int getFunctionIndex(String functionName) {
        int functionsNumber = this.functionsList.size();
        if (functionsNumber == 0) {
            return -1;
        }
        for (int functionIndex = 0; functionIndex < functionsNumber; ++functionIndex) {
            if (!this.functionsList.get(functionIndex).getFunctionName().equals(functionName)) continue;
            return functionIndex;
        }
        return -1;
    }

    public Function getFunction(String functionName) {
        int functionIndex = this.getFunctionIndex(functionName);
        if (functionIndex == -1) {
            return null;
        }
        return this.functionsList.get(functionIndex);
    }

    public Function getFunction(int functionIndex) {
        if (functionIndex < 0 || functionIndex >= this.functionsList.size()) {
            return null;
        }
        return this.functionsList.get(functionIndex);
    }

    public int getFunctionsNumber() {
        return this.functionsList.size();
    }

    public void removeFunctions(String ... functionsNames) {
        for (String functionName : functionsNames) {
            int functionIndex = this.getFunctionIndex(functionName);
            if (functionIndex == -1) continue;
            Function f = this.functionsList.get(functionIndex);
            f.removeRelatedExpression(this);
            this.functionsList.remove(f);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeFunctions(Function ... functions) {
        for (Function function : functions) {
            if (function == null) continue;
            function.removeRelatedExpression(this);
            this.functionsList.remove(function);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllFunctions() {
        for (Function f : this.functionsList) {
            f.removeRelatedExpression(this);
        }
        this.functionsList.clear();
        this.setExpressionModifiedFlag();
    }

    private void setToNumber(int pos, double number, boolean ulpRound) {
        Token token = this.tokensList.get(pos);
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.keyWord = "_num_";
        if (!mXparser.ulpRounding || this.disableRounding || !ulpRound) {
            token.tokenValue = number;
            return;
        }
        if (Double.isNaN(number) || Double.isInfinite(number)) {
            token.tokenValue = number;
            return;
        }
        int precision = MathFunctions.ulpDecimalDigitsBefore(number);
        token.tokenValue = precision >= 0 ? MathFunctions.round(number, precision) : number;
    }

    private void setToNumber(int pos, double number) {
        this.setToNumber(pos, number, false);
    }

    private void f1SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 1);
    }

    private void f1SetDecreaseRemove(int pos, double result) {
        this.f1SetDecreaseRemove(pos, result, false);
    }

    private void f2SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 2);
        this.tokensList.remove(pos + 1);
    }

    private void f2SetDecreaseRemove(int pos, double result) {
        this.f2SetDecreaseRemove(pos, result, false);
    }

    private void f3SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 3);
        this.tokensList.remove(pos + 2);
        this.tokensList.remove(pos + 1);
    }

    private void f3SetDecreaseRemove(int pos, double result) {
        this.f3SetDecreaseRemove(pos, result, false);
    }

    private void opSetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        this.tokensList.remove(pos + 1);
        this.tokensList.remove(pos - 1);
    }

    private void opSetDecreaseRemove(int pos, double result) {
        this.opSetDecreaseRemove(pos, result, false);
    }

    private void calcSetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        int lPos = pos + 1;
        int rPos = lPos + 1;
        while (this.tokensList.get((int)rPos).tokenTypeId != 20 || this.tokensList.get((int)rPos).tokenId != 2 || this.tokensList.get((int)rPos).tokenLevel != this.tokensList.get((int)lPos).tokenLevel) {
            ++rPos;
        }
        this.tokensList.subList(lPos, rPos + 1).clear();
    }

    private void calcSetDecreaseRemove(int pos, double result) {
        this.calcSetDecreaseRemove(pos, result, false);
    }

    private void variadicSetDecreaseRemove(int pos, double value, int length, boolean ulpRound) {
        this.setToNumber(pos, value, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.subList(pos + 1, pos + length + 1).clear();
    }

    private void variadicSetDecreaseRemove(int pos, double value, int length) {
        this.variadicSetDecreaseRemove(pos, value, length, false);
    }

    private void ifSetRemove(int pos, double ifCondition, boolean ulpRound) {
        int lPos = pos + 1;
        int ifLevel = this.tokensList.get((int)lPos).tokenLevel;
        int c1Pos = lPos + 1;
        while (this.tokensList.get((int)c1Pos).tokenTypeId != 20 || this.tokensList.get((int)c1Pos).tokenId != 3 || this.tokensList.get((int)c1Pos).tokenLevel != ifLevel) {
            ++c1Pos;
        }
        int c2Pos = c1Pos + 1;
        while (this.tokensList.get((int)c2Pos).tokenTypeId != 20 || this.tokensList.get((int)c2Pos).tokenId != 3 || this.tokensList.get((int)c2Pos).tokenLevel != ifLevel) {
            ++c2Pos;
        }
        int rPos = c2Pos + 1;
        while (this.tokensList.get((int)rPos).tokenTypeId != 20 || this.tokensList.get((int)rPos).tokenId != 2 || this.tokensList.get((int)rPos).tokenLevel != ifLevel) {
            ++rPos;
        }
        if (!Double.isNaN(ifCondition)) {
            if (ifCondition != 0.0) {
                this.setToNumber(c2Pos + 1, Double.NaN);
                this.tokensList.get((int)(c2Pos + 1)).tokenLevel = ifLevel;
                this.removeTokens(c2Pos + 2, rPos - 1);
            } else {
                this.setToNumber(c1Pos + 1, Double.NaN);
                this.tokensList.get((int)(c1Pos + 1)).tokenLevel = ifLevel;
                this.removeTokens(c1Pos + 2, c2Pos - 1);
            }
        } else {
            this.setToNumber(c1Pos + 1, Double.NaN);
            this.setToNumber(c2Pos + 1, Double.NaN);
            this.tokensList.get((int)(c1Pos + 1)).tokenLevel = ifLevel;
            this.tokensList.get((int)(c2Pos + 1)).tokenLevel = ifLevel;
            this.removeTokens(c2Pos + 2, rPos - 1);
            this.removeTokens(c1Pos + 2, c2Pos - 1);
        }
        this.setToNumber(lPos + 1, ifCondition, ulpRound);
        this.tokensList.get((int)(lPos + 1)).tokenLevel = ifLevel;
        this.removeTokens(lPos + 2, c1Pos - 1);
        this.tokensList.get((int)pos).tokenId = 2;
    }

    private void removeTokens(int from, int to) {
        if (from < to) {
            this.tokensList.subList(from, to + 1).clear();
        } else if (from == to) {
            this.tokensList.remove(from);
        }
    }

    private void ifSetRemove(int pos, double ifCondition) {
        this.ifSetRemove(pos, ifCondition, false);
    }

    private static List<Token> createInitialTokens(int startPos, int endPos, List<Token> tokensList) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int p = startPos; p <= endPos; ++p) {
            Token t = tokensList.get(p).clone();
            tokens.add(t);
        }
        return tokens;
    }

    private int getParametersNumber(int pos) {
        int lPpos = pos + 1;
        if (lPpos == this.initialTokens.size()) {
            return -1;
        }
        if (this.initialTokens.get((int)lPpos).tokenTypeId != 20 || this.initialTokens.get((int)lPpos).tokenId != 1) {
            return -1;
        }
        int tokenLevel = this.initialTokens.get((int)lPpos).tokenLevel;
        int endPos = lPpos + 1;
        while (this.initialTokens.get((int)endPos).tokenTypeId != 20 || this.initialTokens.get((int)endPos).tokenId != 2 || this.initialTokens.get((int)endPos).tokenLevel != tokenLevel) {
            ++endPos;
        }
        if (endPos == lPpos + 1) {
            return 0;
        }
        int numberOfCommas = 0;
        for (int p = lPpos; p < endPos; ++p) {
            Token token = this.initialTokens.get(p);
            if (token.tokenTypeId != 20 || token.tokenId != 3 || token.tokenLevel != tokenLevel) continue;
            ++numberOfCommas;
        }
        return numberOfCommas + 1;
    }

    private ArgumentParameter getParamArgument(String argumentName) {
        ArgumentParameter argParam = new ArgumentParameter();
        argParam.index = this.getArgumentIndex(argumentName);
        argParam.argument = this.getArgument(argParam.index);
        argParam.presence = 0;
        if (argParam.argument == null) {
            argParam.argument = new Argument(argumentName, new PrimitiveElement[0]);
            this.argumentsList.add(argParam.argument);
            argParam.index = this.argumentsList.size() - 1;
            argParam.presence = -1;
            return argParam;
        }
        argParam.initialValue = argParam.argument.argumentValue;
        argParam.initialType = argParam.argument.argumentType;
        argParam.argument.argumentValue = argParam.argument.getArgumentValue();
        argParam.argument.argumentType = 1;
        return argParam;
    }

    private void clearParamArgument(ArgumentParameter argParam) {
        if (argParam.presence == -1) {
            this.argumentsList.remove(argParam.index);
            return;
        }
        argParam.argument.argumentValue = argParam.initialValue;
        argParam.argument.argumentType = argParam.initialType;
    }

    private void FREE_ARGUMENT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.FREE_ARGUMENT, pos);
        }
        Argument argument = this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        this.setToNumber(pos, argument.getArgumentValue());
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void DEPENDENT_ARGUMENT(int pos, CalcStepsRegister calcStepsRegister) {
        int tokensListSizeAfter;
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.DEPENDENT_ARGUMENT, pos);
        }
        Argument argument = this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        int tokensListSizeBefore = this.tokensList.size();
        Token tokenBefore = this.tokensList.get(pos);
        double argumentValue = argument.getArgumentValue(calcStepsRegister);
        if (this.forwardErrorMessage && this != argument.argumentExpression) {
            this.errorMessageCalculate = StringUtils.stringConcatenateMaxLength(this.errorMessageCalculate, argument.argumentExpression.errorMessageCalculate, 2000);
            this.errorMessage = StringUtils.stringConcatenateMaxLength(this.errorMessage, argument.argumentExpression.errorMessageCalculate, 10000);
        }
        if (tokensListSizeBefore == (tokensListSizeAfter = this.tokensList.size())) {
            Token tokenAfter = this.tokensList.get(pos);
            if (tokenBefore.tokenTypeId == tokenAfter.tokenTypeId && tokenBefore.tokenId == tokenAfter.tokenId) {
                this.setToNumber(pos, argumentValue);
            }
        }
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void USER_FUNCTION(int pos, CalcStepsRegister calcStepsRegister) {
        int tokensListSizeAfter;
        double value;
        Function function;
        Function fun;
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.USER_FUNCTION, pos);
        }
        if ((fun = this.functionsList.get(this.tokensList.get((int)pos).tokenId)).getRecursiveMode()) {
            function = fun.clone();
            function.functionExpression.recursionCallsCounter = this.recursionCallsCounter;
        } else {
            function = fun;
        }
        function.functionExpression.UDFVariadicParamsAtRunTime = this.getNumbers(pos);
        int argsNumber = function.getParametersNumber();
        if (!function.isVariadic) {
            for (int argIdx = 0; argIdx < argsNumber; ++argIdx) {
                function.setArgumentValue(argIdx, this.tokensList.get((int)(pos + argIdx + 1)).tokenValue);
            }
        }
        boolean functionVerboseMode = function.getVerboseMode();
        if (this.verboseMode) {
            function.setVerboseMode();
        }
        int tokensListSizeBefore = this.tokensList.size();
        Token tokenBefore = this.tokensList.get(pos);
        try {
            value = function.calculate(calcStepsRegister);
        }
        catch (StackOverflowError soe) {
            value = Double.NaN;
            this.errorMessage = StringUtils.trimNotNull(soe.getMessage());
        }
        if (this.forwardErrorMessage && this != function.functionExpression) {
            this.errorMessageCalculate = StringUtils.stringConcatenateMaxLength(this.errorMessageCalculate, function.functionExpression.errorMessageCalculate, 2000);
            this.errorMessage = StringUtils.stringConcatenateMaxLength(this.errorMessage, function.functionExpression.errorMessageCalculate, 10000);
        }
        if (tokensListSizeBefore == (tokensListSizeAfter = this.tokensList.size())) {
            Token tokenAfter = this.tokensList.get(pos);
            if (tokenBefore.tokenTypeId == tokenAfter.tokenTypeId && tokenBefore.tokenId == tokenAfter.tokenId) {
                this.setToNumber(pos, value);
                --this.tokensList.get((int)pos).tokenLevel;
                for (int argIdx = argsNumber; argIdx > 0; --argIdx) {
                    this.tokensList.remove(pos + argIdx);
                }
            }
        }
        if (!functionVerboseMode) {
            function.setSilentMode();
        }
    }

    private void USER_CONSTANT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.USER_CONSTANT, pos);
        }
        Constant constant = this.constantsList.get(this.tokensList.get((int)pos).tokenId);
        this.setToNumber(pos, constant.getConstantValue());
    }

    private void RECURSIVE_ARGUMENT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.RECURSIVE_ARGUMENT, pos);
        }
        double index = this.tokensList.get((int)(pos + 1)).tokenValue;
        RecursiveArgument argument = (RecursiveArgument)this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        double result = argument.getArgumentValue(index);
        if (this.forwardErrorMessage && this != argument.argumentExpression) {
            this.errorMessageCalculate = StringUtils.stringConcatenateMaxLength(this.errorMessageCalculate, argument.argumentExpression.errorMessageCalculate, 2000);
            this.errorMessage = StringUtils.stringConcatenateMaxLength(this.errorMessage, argument.argumentExpression.errorMessageCalculate, 10000);
        }
        this.f1SetDecreaseRemove(pos, result);
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void CONSTANT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.CONSTANT, pos);
        }
        double constValue = Double.NaN;
        int constantValueId = this.tokensList.get((int)pos).tokenId;
        constValue = constantValueId == 303 ? (double)this.UDFVariadicParamsAtRunTime.size() : MathConstants.getConstantValue(constantValueId);
        this.setToNumber(pos, constValue);
    }

    private void UNIT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.UNIT, pos);
        }
        this.setToNumber(pos, Units.getUnitValue(this.tokensList.get((int)pos).tokenId));
    }

    private void RANDOM_VARIABLE(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.RANDOM_VARIABLE, pos);
        }
        this.setToNumber(pos, ProbabilityDistributions.getRandomVariableValue(this.tokensList.get((int)pos).tokenId));
    }

    private double getTokenValue(int tokenIndex) {
        return this.tokensList.get((int)tokenIndex).tokenValue;
    }

    private void TETRATION(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.TETRATION, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double n = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.tetration(a, n), true);
    }

    private void POWER(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.POWER, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.power(a, b), true);
    }

    private void MODULO(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.MODULO, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.mod(a, b));
    }

    private void DIVIDE(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.DIVIDE, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        if (this.disableRounding) {
            double result = Double.NaN;
            if (b != 0.0) {
                result = a / b;
            }
            this.opSetDecreaseRemove(pos, result, true);
        } else {
            this.opSetDecreaseRemove(pos, MathFunctions.div(a, b), true);
        }
    }

    private void DIVIDE_QUOTIENT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.DIVIDE_QUOTIENT, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.divQuotient(a, b), true);
    }

    private void MULTIPLY(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.MULTIPLY, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        if (this.disableRounding) {
            this.opSetDecreaseRemove(pos, a * b, true);
        } else {
            this.opSetDecreaseRemove(pos, MathFunctions.multiply(a, b), true);
        }
    }

    private void PLUS(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.PLUS, pos);
        }
        Token b = this.tokensList.get(pos + 1);
        if (pos == 0) {
            if (b.tokenTypeId == 0) {
                this.setToNumber(pos, b.tokenValue);
                this.tokensList.remove(pos + 1);
            }
            return;
        }
        Token a = this.tokensList.get(pos - 1);
        if (a.tokenTypeId == 0 && b.tokenTypeId == 0) {
            if (this.disableRounding) {
                this.opSetDecreaseRemove(pos, a.tokenValue + b.tokenValue, true);
            } else {
                this.opSetDecreaseRemove(pos, MathFunctions.plus(a.tokenValue, b.tokenValue), true);
            }
        } else if (b.tokenTypeId == 0) {
            this.setToNumber(pos, b.tokenValue);
            this.tokensList.remove(pos + 1);
        }
    }

    private void MINUS(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.MINUS, pos);
        }
        Token b = this.tokensList.get(pos + 1);
        if (pos == 0) {
            if (b.tokenTypeId == 0) {
                this.setToNumber(pos, -b.tokenValue);
                this.tokensList.remove(pos + 1);
            }
            return;
        }
        Token a = this.tokensList.get(pos - 1);
        if (a.tokenTypeId == 0 && b.tokenTypeId == 0) {
            if (this.disableRounding) {
                this.opSetDecreaseRemove(pos, a.tokenValue - b.tokenValue, true);
            } else {
                this.opSetDecreaseRemove(pos, MathFunctions.minus(a.tokenValue, b.tokenValue), true);
            }
        } else if (b.tokenTypeId == 0) {
            this.setToNumber(pos, -b.tokenValue);
            this.tokensList.remove(pos + 1);
        }
    }

    private void AND(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.and(a, b));
    }

    private void OR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.or(a, b));
    }

    private void NAND(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nand(a, b));
    }

    private void NOR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nor(a, b));
    }

    private void XOR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.xor(a, b));
    }

    private void IMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.imp(a, b));
    }

    private void CIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.cimp(a, b));
    }

    private void NIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nimp(a, b));
    }

    private void CNIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.cnimp(a, b));
    }

    private void EQV(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.eqv(a, b));
    }

    private void NEG(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.NEG, pos);
        }
        double a = this.getTokenValue(pos + 1);
        this.setToNumber(pos, BooleanAlgebra.not(a));
        this.tokensList.remove(pos + 1);
    }

    private void EQ(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.EQ, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.eq(a, b));
    }

    private void NEQ(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.NEQ, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.neq(a, b));
    }

    private void LT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.LT, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.lt(a, b));
    }

    private void GT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.GT, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.gt(a, b));
    }

    private void LEQ(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.LEQ, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.leq(a, b));
    }

    private void GEQ(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.GEQ, pos);
        }
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.geq(a, b));
    }

    private void SQUARE_ROOT_OPERATOR(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.setToNumber(pos, MathFunctions.sqrt(a));
        this.tokensList.remove(pos + 1);
    }

    private void CUBE_ROOT_OPERATOR(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.setToNumber(pos, MathFunctions.root(3.0, a));
        this.tokensList.remove(pos + 1);
    }

    private void FOURTH_ROOT_OPERATOR(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.setToNumber(pos, MathFunctions.root(4.0, a));
        this.tokensList.remove(pos + 1);
    }

    private void BITWISE_COMPL(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.BITWISE_COMPL, pos);
        }
        long a = (long)this.getTokenValue(pos + 1);
        this.setToNumber(pos, a ^ 0xFFFFFFFFFFFFFFFFL);
        this.tokensList.remove(pos + 1);
    }

    private void BITWISE_AND(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a & b);
    }

    private void BITWISE_OR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a | b);
    }

    private void BITWISE_XOR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a ^ b);
    }

    private void BITWISE_NAND(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a & b ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void BITWISE_NOR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, (a | b) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void BITWISE_XNOR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a ^ b ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void BITWISE_LEFT_SHIFT(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a << (int)b);
    }

    private void BITWISE_RIGHT_SHIFT(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a >> (int)b);
    }

    private void SIN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sin(a));
    }

    private void COS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cos(a));
    }

    private void TAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.tan(a));
    }

    private void CTAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ctan(a));
    }

    private void SEC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sec(a));
    }

    private void COSEC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cosec(a));
    }

    private void ASIN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.asin(a));
    }

    private void ACOS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.acos(a));
    }

    private void ATAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.atan(a));
    }

    private void ACTAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.actan(a));
    }

    private void LN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ln(a));
    }

    private void LOG2(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.log2(a));
    }

    private void LOG10(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.log10(a));
    }

    private void RAD(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.rad(a));
    }

    private void EXP(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.exp(a));
    }

    private void SQRT(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sqrt(a));
    }

    private void SINH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sinh(a));
    }

    private void COSH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cosh(a));
    }

    private void TANH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.tanh(a));
    }

    private void COTH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.coth(a));
    }

    private void SECH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sech(a));
    }

    private void CSCH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.csch(a));
    }

    private void DEG(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.deg(a));
    }

    private void ABS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.abs(a));
    }

    private void SGN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sgn(a));
    }

    private void FLOOR(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.floor(a));
    }

    private void CEIL(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ceil(a));
    }

    private void ARSINH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arsinh(a));
    }

    private void ARCOSH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcosh(a));
    }

    private void ARTANH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.artanh(a));
    }

    private void ARCOTH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcoth(a));
    }

    private void ARSECH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arsech(a));
    }

    private void ARCSCH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcsch(a));
    }

    private void SA(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sa(a));
    }

    private void SINC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sinc(a));
    }

    private void BELL_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.bellNumber(n));
    }

    private void LUCAS_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.lucasNumber(n));
    }

    private void FIBONACCI_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.fibonacciNumber(n));
    }

    private void HARMONIC_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.harmonicNumber(n));
    }

    private void IS_PRIME(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.primeTest(n));
    }

    private void PRIME_COUNT(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.primeCount(n));
    }

    private void EXP_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.exponentialIntegralEi(x));
    }

    private void LOG_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.logarithmicIntegralLi(x));
    }

    private void OFF_LOG_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.offsetLogarithmicIntegralLi(x));
    }

    private void FACT(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.FACT, pos);
        }
        double a = this.getTokenValue(pos - 1);
        this.setToNumber(pos, MathFunctions.factorial(a));
        this.tokensList.remove(pos - 1);
    }

    private void PERC(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.PERC, pos);
        }
        double a = this.getTokenValue(pos - 1);
        this.setToNumber(pos, MathFunctions.multiply(a, 0.01));
        this.tokensList.remove(pos - 1);
    }

    private void NOT(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, BooleanAlgebra.not(a));
    }

    private void GAUSS_ERF(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erf(x));
    }

    private void GAUSS_ERFC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfc(x));
    }

    private void GAUSS_ERF_INV(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfInv(x));
    }

    private void GAUSS_ERFC_INV(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfcInv(x));
    }

    private void ULP(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ulp(x));
    }

    private void ISNAN(int pos) {
        double x = this.getTokenValue(pos + 1);
        if (Double.isNaN(x)) {
            this.f1SetDecreaseRemove(pos, 1.0);
        } else {
            this.f1SetDecreaseRemove(pos, 0.0);
        }
    }

    private void NDIG10(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.numberOfDigits(x));
    }

    private void NFACT(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.numberOfPrimeFactors(n));
    }

    private void ARCSEC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.asec(x));
    }

    private void ARCCSC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.acosec(x));
    }

    private void GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.gamma(x));
    }

    private void LAMBERT_W0(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.lambertW(x, 0.0));
    }

    private void LAMBERT_W1(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.lambertW(x, -1.0));
    }

    private void SGN_GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.sgnGamma(x));
    }

    private void LOG_GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.logGamma(x));
    }

    private void DI_GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.diGamma(x));
    }

    private void UDF_PARAM(int pos) {
        double value = Double.NaN;
        if (this.UDFVariadicParamsAtRunTime != null) {
            double x = this.getTokenValue(pos + 1);
            int npar = this.UDFVariadicParamsAtRunTime.size();
            if (!Double.isNaN(x) && x != Double.POSITIVE_INFINITY && x != Double.NEGATIVE_INFINITY) {
                int i = (int)MathFunctions.integerPart(x);
                if (i == 0) {
                    value = npar;
                } else if (Math.abs(i) <= npar) {
                    if (i >= 1) {
                        value = this.UDFVariadicParamsAtRunTime.get(i - 1);
                    } else if (i <= -1) {
                        value = this.UDFVariadicParamsAtRunTime.get(npar + i);
                    }
                }
            }
        }
        this.f1SetDecreaseRemove(pos, value);
    }

    private void RND_STUDENT_T(int pos) {
        double v = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, ProbabilityDistributions.rndStudentT(v));
    }

    private void RND_CHI2(int pos) {
        double k = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, ProbabilityDistributions.rndChiSquared(k));
    }

    private void LOG(int pos) {
        double b = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.log(a, b));
    }

    private List<Double> getNumbers(int pos) {
        ArrayList<Double> numbers = new ArrayList<Double>();
        int pn = pos;
        int lastIndex = this.tokensList.size() - 1;
        boolean end = false;
        do {
            Token t = this.tokensList.get(++pn);
            boolean isNumber = false;
            if (t.tokenTypeId == 0 && t.tokenId == 1) {
                isNumber = true;
                numbers.add(t.tokenValue);
            }
            if (pn != lastIndex && isNumber) continue;
            end = true;
        } while (!end);
        return numbers;
    }

    private void MOD(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.mod(a, b));
    }

    private void BINOM_COEFF(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.binomCoeff(n, k));
    }

    private void PERMUTATIONS(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.numberOfPermutations(n, k));
    }

    private void BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double y = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.beta(x, y));
    }

    private void LOG_BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double y = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.logBeta(x, y));
    }

    private void PDF_STUDENT_T(int pos) {
        double x = this.getTokenValue(pos + 1);
        double v = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.pdfStudentT(x, v));
    }

    private void CDF_STUDENT_T(int pos) {
        double x = this.getTokenValue(pos + 1);
        double v = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.cdfStudentT(x, v));
    }

    private void QNT_STUDENT_T(int pos) {
        double p = this.getTokenValue(pos + 1);
        double v = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.qntStudentT(p, v));
    }

    private void PDF_CHI2(int pos) {
        double x = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.pdfChiSquared(x, k));
    }

    private void CDF_CHI2(int pos) {
        double x = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.cdfChiSquared(x, k));
    }

    private void QNT_CHI2(int pos) {
        double p = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.qntChiSquared(p, k));
    }

    private void BERNOULLI_NUMBER(int pos) {
        double m = this.getTokenValue(pos + 1);
        double n = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.bernoulliNumber(m, n));
    }

    private void STIRLING1_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.Stirling1Number(n, k));
    }

    private void STIRLING2_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.Stirling2Number(n, k));
    }

    private void WORPITZKY_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.worpitzkyNumber(n, k));
    }

    private void EULER_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.eulerNumber(n, k));
    }

    private void KRONECKER_DELTA(int pos) {
        double i = this.getTokenValue(pos + 1);
        double j = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.kroneckerDelta(i, j));
    }

    private void EULER_POLYNOMIAL(int pos) {
        double m = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.eulerPolynomial(m, x));
    }

    private void HARMONIC2_NUMBER(int pos) {
        double x = this.getTokenValue(pos + 1);
        double n = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.harmonicNumber(x, n));
    }

    private void ROUND(int pos) {
        double value = this.getTokenValue(pos + 1);
        int places = (int)this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.round(value, places));
    }

    private void RND_VAR_UNIFORM_CONT(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndUniformContinuous(a, b, ProbabilityDistributions.randomGenerator));
    }

    private void RND_VAR_UNIFORM_DISCR(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndInteger(a, b, ProbabilityDistributions.randomGenerator));
    }

    private void RND_NORMAL(int pos) {
        double mean = this.getTokenValue(pos + 1);
        double stddev = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndNormal(mean, stddev, ProbabilityDistributions.randomGenerator));
    }

    private void RND_F_SNEDECOR(int pos) {
        double d1 = this.getTokenValue(pos + 1);
        double d2 = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndSnedecordF(d1, d2));
    }

    private void NDIG(int pos) {
        double number = this.getTokenValue(pos + 1);
        double numeralSystemBase = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.numberOfDigits(number, numeralSystemBase));
    }

    private void DIGIT10(int pos) {
        double number = this.getTokenValue(pos + 1);
        double position = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.digitAtPosition(number, position));
    }

    private void FACTVAL(int pos) {
        double number = this.getTokenValue(pos + 1);
        double id = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.primeFactorValue(number, id));
    }

    private void FACTEXP(int pos) {
        double number = this.getTokenValue(pos + 1);
        double id = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.primeFactorExponent(number, id));
    }

    private void ROOT(int pos) {
        double n = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.root(n, x));
    }

    private void INC_GAMMA_LOWER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.incompleteGammaLower(s, x));
    }

    private void INC_GAMMA_UPPER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.incompleteGammaUpper(s, x));
    }

    private void REG_GAMMA_LOWER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.regularizedGammaLowerP(s, x));
    }

    private void REG_GAMMA_UPPER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.regularizedGammaUpperQ(s, x));
    }

    private void IF_CONDITION(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.IF_CONDITION, pos);
        }
        List<FunctionParameter> ifParams = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter ifParam = ifParams.get(0);
        Expression ifExp = new Expression(ifParam.paramStr, ifParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            ifExp.setVerboseMode();
        }
        this.ifSetRemove(pos, ifExp.calculate());
    }

    private void IFF(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.IFF, pos);
        }
        List<FunctionParameter> iffParams = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter iffParam = iffParams.get(0);
        int parametersNumber = iffParams.size();
        int paramNumber = 1;
        double iffValue = 0.0;
        boolean iffCon = true;
        do {
            Expression iffExp = new Expression(iffParam.paramStr, iffParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                iffExp.setVerboseMode();
            }
            iffCon = true;
            iffValue = iffExp.calculate();
            if (iffValue != 0.0 && !Double.isNaN(iffValue)) continue;
            iffCon = false;
            if ((paramNumber += 2) >= parametersNumber) continue;
            iffParam = iffParams.get(paramNumber - 1);
        } while (!iffCon && paramNumber < parametersNumber);
        if (iffCon) {
            int p;
            int trueParamNumber = paramNumber + 1;
            int from = pos + 1;
            int to = iffParams.get((int)(parametersNumber - 1)).toIndex + 1;
            --this.tokensList.get((int)from).tokenLevel;
            --this.tokensList.get((int)to).tokenLevel;
            if (trueParamNumber < parametersNumber) {
                to = iffParams.get((int)(parametersNumber - 1)).toIndex;
                from = iffParams.get((int)trueParamNumber).fromIndex - 1;
                for (p = to; p >= from; --p) {
                    this.tokensList.remove(p);
                }
            }
            from = iffParams.get((int)(trueParamNumber - 1)).fromIndex;
            to = iffParams.get((int)(trueParamNumber - 1)).toIndex;
            for (p = from; p <= to; ++p) {
                --this.tokensList.get((int)p).tokenLevel;
            }
            to = from - 1;
            from = pos;
            for (p = to; p >= from; --p) {
                if (p == pos + 1) continue;
                this.tokensList.remove(p);
            }
        } else {
            int to = iffParams.get((int)(parametersNumber - 1)).toIndex + 1;
            int from = pos + 1;
            for (int p = to; p >= from; --p) {
                this.tokensList.remove(p);
            }
            this.setToNumber(pos, Double.NaN);
            --this.tokensList.get((int)pos).tokenLevel;
        }
    }

    private void IF(int pos) {
        double ifFalse;
        double ifCondition = this.tokensList.get((int)(pos + 1)).tokenValue;
        double ifTrue = this.tokensList.get((int)(pos + 2)).tokenValue;
        double result = ifFalse = this.tokensList.get((int)(pos + 3)).tokenValue;
        if (ifCondition != 0.0) {
            result = ifTrue;
        }
        if (Double.isNaN(ifCondition)) {
            result = Double.NaN;
        }
        this.f3SetDecreaseRemove(pos, result);
    }

    private void CHI(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi(x, a, b));
    }

    private void CHI_LR(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_LR(x, a, b));
    }

    private void CHI_L(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_L(x, a, b));
    }

    private void CHI_R(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_R(x, a, b));
    }

    private void PDF_UNIFORM_CONT(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfUniformContinuous(x, a, b));
    }

    private void CDF_UNIFORM_CONT(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfUniformContinuous(x, a, b));
    }

    private void QNT_UNIFORM_CONT(int pos) {
        double q = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntUniformContinuous(q, a, b));
    }

    private void PDF_NORMAL(int pos) {
        double x = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfNormal(x, mean, stddev));
    }

    private void CDF_NORMAL(int pos) {
        double x = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfNormal(x, mean, stddev));
    }

    private void QNT_NORMAL(int pos) {
        double q = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntNormal(q, mean, stddev));
    }

    private void PDF_F_SNEDECOR(int pos) {
        double x = this.getTokenValue(pos + 1);
        double d1 = this.getTokenValue(pos + 2);
        double d2 = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfSnedecordF(x, d1, d2));
    }

    private void CDF_F_SNEDECOR(int pos) {
        double x = this.getTokenValue(pos + 1);
        double d1 = this.getTokenValue(pos + 2);
        double d2 = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfSnedecordF(x, d1, d2));
    }

    private void QNT_F_SNEDECOR(int pos) {
        double p = this.getTokenValue(pos + 1);
        double d1 = this.getTokenValue(pos + 2);
        double d2 = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntSnedecordF(p, d1, d2));
    }

    private void DIGIT(int pos) {
        double number = this.getTokenValue(pos + 1);
        double position = this.getTokenValue(pos + 2);
        double numeralSystemBase = this.getTokenValue(pos + 3);
        double value = number == PP && position == EE && numeralSystemBase == GG ? (double)(1 + License.getUseType() * 10 + 0 + 10000 + 6000000) : NumberTheory.digitAtPosition(number, position, numeralSystemBase);
        this.f3SetDecreaseRemove(pos, value);
    }

    private void INC_BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, SpecialFunctions.incompleteBeta(a, b, x));
    }

    private void REG_BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, SpecialFunctions.regularizedBeta(a, b, x));
    }

    private static void updateMissingTokens(List<Token> tokens, String keyWord, int tokenId, int tokenTypeId) {
        for (Token t : tokens) {
            if (t.tokenTypeId != -1 || !t.tokenStr.equals(keyWord)) continue;
            t.keyWord = keyWord;
            t.tokenId = tokenId;
            t.tokenTypeId = tokenTypeId;
        }
    }

    private static void updateMissingTokens(ArgumentParameter index, IterativeOperatorParameters iterParams) {
        if (index.presence == -1) {
            Expression.updateMissingTokens(iterParams.indexParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            Expression.updateMissingTokens(iterParams.fromParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            Expression.updateMissingTokens(iterParams.toParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            Expression.updateMissingTokens(iterParams.funParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
        }
    }

    private void evalFromToDeltaParameters(ArgumentParameter index, IterativeOperatorParameters iterParams) {
        iterParams.fromExp = new Expression(iterParams.fromParam.paramStr, iterParams.fromParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterParams.toExp = new Expression(iterParams.toParam.paramStr, iterParams.toParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterParams.funExp = new Expression(iterParams.funParam.paramStr, iterParams.funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterParams.deltaExp = null;
        if (this.verboseMode) {
            iterParams.fromExp.setVerboseMode();
            iterParams.toExp.setVerboseMode();
            iterParams.funExp.setVerboseMode();
        }
        iterParams.from = iterParams.fromExp.calculate();
        iterParams.to = iterParams.toExp.calculate();
        iterParams.delta = 1.0;
        if (iterParams.to < iterParams.from) {
            iterParams.delta = -1.0;
        }
        if (iterParams.withDelta) {
            iterParams.deltaExp = new Expression(iterParams.deltaParam.paramStr, iterParams.deltaParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (index.presence == -1) {
                Expression.updateMissingTokens(iterParams.deltaParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            }
            if (this.verboseMode) {
                iterParams.deltaExp.setVerboseMode();
            }
            iterParams.delta = iterParams.deltaExp.calculate();
        }
    }

    private void SUM(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double sigma = NumberTheory.sigmaSummation(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, sigma, true);
    }

    private void PROD(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double product = NumberTheory.piProduct(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, product, true);
    }

    private void MIN(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double min = NumberTheory.min(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, min);
    }

    private void MAX(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double max = NumberTheory.max(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, max);
    }

    private void AVG(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double avg = Statistics.avg(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, avg, true);
    }

    private void VAR(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double var = Statistics.var(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, var, true);
    }

    private void STD(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(ExpressionUtils.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        Expression.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double std = Statistics.std(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, std, true);
    }

    private void DERIVATIVE(int pos, int derivativeType) {
        List<FunctionParameter> derParams = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        double DEF_EPS = 1.0E-8;
        int DEF_MAX_STEPS = 20;
        FunctionParameter funParam = derParams.get(0);
        FunctionParameter xParam = derParams.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            Expression.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double x0 = Double.NaN;
        if (derParams.size() == 2 || derParams.size() == 4) {
            x0 = x.argument.getArgumentValue();
        }
        if (derParams.size() == 3 || derParams.size() == 5) {
            FunctionParameter x0Param = derParams.get(2);
            if (x.presence == -1) {
                Expression.updateMissingTokens(x0Param.tokens, xParam.paramStr, x.index, 101);
            }
            Expression x0Expr = new Expression(x0Param.paramStr, x0Param.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            x0 = x0Expr.calculate();
        }
        double eps = 1.0E-8;
        int maxSteps = 20;
        if (derParams.size() == 4 || derParams.size() == 5) {
            FunctionParameter maxStepsParam;
            FunctionParameter epsParam;
            if (derParams.size() == 4) {
                epsParam = derParams.get(2);
                maxStepsParam = derParams.get(3);
            } else {
                epsParam = derParams.get(3);
                maxStepsParam = derParams.get(4);
            }
            if (x.presence == -1) {
                Expression.updateMissingTokens(epsParam.tokens, xParam.paramStr, x.index, 101);
                Expression.updateMissingTokens(maxStepsParam.tokens, xParam.paramStr, x.index, 101);
            }
            Expression epsExpr = new Expression(epsParam.paramStr, epsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            Expression maxStepsExp = new Expression(maxStepsParam.paramStr, maxStepsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            eps = epsExpr.calculate();
            maxSteps = (int)Math.round(maxStepsExp.calculate());
        }
        if (derivativeType == 3) {
            double general = Calculus.derivative(funExp, x.argument, x0, 3, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, general);
        } else if (derivativeType == 1) {
            double left = Calculus.derivative(funExp, x.argument, x0, 1, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, left);
        } else {
            double right = Calculus.derivative(funExp, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, right);
        }
        this.clearParamArgument(x);
    }

    private void DERIVATIVE_NTH(int pos, int derivativeType) {
        double DEF_EPS = 1.0E-6;
        int DEF_MAX_STEPS = 20;
        List<FunctionParameter> derParams = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = derParams.get(0);
        FunctionParameter nParam = derParams.get(1);
        FunctionParameter xParam = derParams.get(2);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            Expression.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(nParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression nExp = new Expression(nParam.paramStr, nParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double n = nExp.calculate();
        double x0 = x.argument.getArgumentValue();
        double eps = 1.0E-6;
        int maxSteps = 20;
        if (derParams.size() == 5) {
            FunctionParameter epsParam = derParams.get(3);
            FunctionParameter maxStepsParam = derParams.get(4);
            if (x.presence == -1) {
                Expression.updateMissingTokens(epsParam.tokens, xParam.paramStr, x.index, 101);
                Expression.updateMissingTokens(maxStepsParam.tokens, xParam.paramStr, x.index, 101);
            }
            Expression epsExpr = new Expression(epsParam.paramStr, epsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            Expression maxStepsExp = new Expression(maxStepsParam.paramStr, maxStepsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            eps = epsExpr.calculate();
            maxSteps = (int)Math.round(maxStepsExp.calculate());
        }
        if (derivativeType == 3) {
            double left = Calculus.derivativeNth(funExp, n, x.argument, x0, 1, eps, maxSteps);
            double right = Calculus.derivativeNth(funExp, n, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, (left + right) / 2.0);
        } else if (derivativeType == 1) {
            double left = Calculus.derivativeNth(funExp, n, x.argument, x0, 1, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, left);
        } else {
            double right = Calculus.derivativeNth(funExp, n, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, right);
        }
        this.clearParamArgument(x);
    }

    private void INTEGRAL(int pos) {
        double DEF_EPS = 1.0E-6;
        int DEF_MAX_STEPS = 20;
        List<FunctionParameter> intParams = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = intParams.get(0);
        FunctionParameter xParam = intParams.get(1);
        FunctionParameter aParam = intParams.get(2);
        FunctionParameter bParam = intParams.get(3);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            Expression.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(aParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(bParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression aExp = new Expression(aParam.paramStr, aParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression bExp = new Expression(bParam.paramStr, bParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double eps = 1.0E-6;
        int maxSteps = 20;
        this.calcSetDecreaseRemove(pos, Calculus.integralTrapezoid(funExp, x.argument, aExp.calculate(), bExp.calculate(), eps, maxSteps));
        this.clearParamArgument(x);
    }

    private void SOLVE(int pos) {
        double DEF_EPS = 1.0E-9;
        int DEF_MAX_STEPS = 100;
        List<FunctionParameter> intParams = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = intParams.get(0);
        FunctionParameter xParam = intParams.get(1);
        FunctionParameter aParam = intParams.get(2);
        FunctionParameter bParam = intParams.get(3);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            Expression.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(aParam.tokens, xParam.paramStr, x.index, 101);
            Expression.updateMissingTokens(bParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression aExp = new Expression(aParam.paramStr, aParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression bExp = new Expression(bParam.paramStr, bParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double eps = 1.0E-9;
        int maxSteps = 100;
        this.calcSetDecreaseRemove(pos, Calculus.solveBrent(funExp, x.argument, aExp.calculate(), bExp.calculate(), eps, maxSteps));
        this.clearParamArgument(x);
    }

    private void FORWARD_DIFFERENCE(int pos) {
        List<FunctionParameter> params = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = params.get(0);
        FunctionParameter xParam = params.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            funExp.setVerboseMode();
        }
        double h = 1.0;
        if (params.size() == 3) {
            FunctionParameter hParam = params.get(2);
            Expression hExp = new Expression(hParam.paramStr, hParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                hExp.setVerboseMode();
            }
            h = hExp.calculate();
        }
        this.calcSetDecreaseRemove(pos, Calculus.forwardDifference(funExp, h, x.argument));
        this.clearParamArgument(x);
    }

    private void BACKWARD_DIFFERENCE(int pos) {
        List<FunctionParameter> params = ExpressionUtils.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = params.get(0);
        FunctionParameter xParam = params.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            funExp.setVerboseMode();
        }
        double h = 1.0;
        if (params.size() == 3) {
            FunctionParameter hParam = params.get(2);
            Expression hExp = new Expression(hParam.paramStr, hParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                hExp.setVerboseMode();
            }
            h = hExp.calculate();
        }
        this.calcSetDecreaseRemove(pos, Calculus.backwardDifference(funExp, h, x.argument));
        this.clearParamArgument(x);
    }

    private void MIN_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.min(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MAX_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.max(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void SUM_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.sum(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void PROD_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.prod(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void AVG_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.avg(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void VAR_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.var(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void STD_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.std(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void CONTINUED_FRACTION(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.continuedFraction(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void CONTINUED_POLYNOMIAL(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.continuedPolynomial(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void GCD(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.gcd(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void LCM(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.lcm(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void RND_LIST(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        int n = numbers.size();
        int i = ProbabilityDistributions.rndIndex(n, ProbabilityDistributions.randomGenerator);
        this.variadicSetDecreaseRemove(pos, numbers.get(i), numbers.size());
    }

    private void COALESCE(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.coalesce(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void OR_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, BooleanAlgebra.orVariadic(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void AND_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, BooleanAlgebra.andVariadic(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void XOR_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, BooleanAlgebra.xorVariadic(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void ARGMIN_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.argmin(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void ARGMAX_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.argmax(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MEDIAN_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.median(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MODE_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.mode(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void BASE_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.convOthBase2Decimal(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void NDIST_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.numberOfDistValues(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void COMMA(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.COMMA, pos);
        }
        this.tokensList.remove(pos);
    }

    private void PARENTHESES(int lPos, int rPos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.PARENTHESES, lPos, rPos);
        }
        for (int p = lPos; p <= rPos; ++p) {
            --this.tokensList.get((int)p).tokenLevel;
        }
        this.tokensList.remove(rPos);
        this.tokensList.remove(lPos);
    }

    public boolean checkLexSyntax() {
        boolean syntax = true;
        this.recursionCallsCounter = 0;
        this.cleanExpressionString();
        if (this.expressionStringCleaned.isEmpty()) {
            syntax = false;
            this.registerFinalSyntaxExpressionStringIsEmpty("");
            return syntax;
        }
        SyntaxChecker syn = new SyntaxChecker(new ByteArrayInputStream(this.expressionStringCleaned.getBytes()));
        try {
            syn.checkSyntax();
        }
        catch (Throwable e) {
            syntax = false;
            this.registerSyntaxLexicalError("", e);
        }
        this.registerFinalSyntax("", syntax);
        return syntax;
    }

    private void cleanExpressionString() {
        this.expressionStringCleaned = ExpressionUtils.cleanExpressionString(this.expressionString, this.attemptToFixExpStrEnabled);
    }

    public boolean checkSyntax() {
        return this.checkSyntax(ExpressionUtils.createExpressionDescription(this.description, this.expressionString), false);
    }

    private int checkCalculusParameter(String param) {
        int errors = 0;
        for (KeyWord kw : this.keyWordsList) {
            if (kw.wordTypeId == 101 || !param.equals(kw.wordString)) continue;
            ++errors;
        }
        return errors;
    }

    private static boolean checkIfKnownArgument(FunctionParameter param) {
        if (param.tokens.size() > 1) {
            return false;
        }
        Token t = param.tokens.get(0);
        return t.tokenTypeId == 101;
    }

    private static boolean checkIfUnknownToken(FunctionParameter param) {
        if (param.tokens.size() > 1) {
            return false;
        }
        Token t = param.tokens.get(0);
        return t.tokenTypeId == -1;
    }

    private boolean syntaxIsAlreadyCheckedNorErrors() {
        return !this.expressionWasModified && this.syntaxStatus && this.optionsChangesetNumber == mXparser.optionsChangesetNumber;
    }

    private void registerFinalSyntaxAlreadyCheckedNorErrors(String recursionInfoLevel) {
        this.errorMessage = StringModel.startErrorMassage(recursionInfoLevel, StringModel.STRING_RESOURCES.ALREADY_CHECKED_NO_ERRORS);
        this.recursionCallPending = false;
    }

    private void registerFinalSyntaxFunctionWithBodyExtNoErrors(String recursionInfoLevel) {
        this.syntaxStatus = true;
        this.recursionCallPending = false;
        this.expressionWasModified = false;
        this.errorMessage = StringModel.startErrorMassage(recursionInfoLevel, StringModel.STRING_RESOURCES.FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS);
    }

    private void registerFinalSyntaxExpressionStringIsEmpty(String recursionInfoLevel) {
        this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.EXPRESSION_STRING_IS_EMPTY);
        this.syntaxStatus = false;
        this.recursionCallPending = false;
    }

    private void registerSyntaxLexicalError(String recursionInfoLevel, Throwable e) {
        this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.LEXICAL_ERROR_HAS_BEEN_FOUND + " " + StringModel.buildErrorMessageFromException(e));
    }

    private void registerFinalSyntax(String recursionInfoLevel, boolean syntax) {
        if (syntax) {
            this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.NO_ERRORS_DETECTED);
            this.expressionWasModified = false;
        } else {
            this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ERRORS_HAVE_BEEN_FOUND);
            this.expressionWasModified = true;
        }
        this.syntaxStatus = syntax;
        this.recursionCallPending = false;
    }

    private void registerPartialSyntaxStartingSyntaxCheck(String recursionInfoLevel) {
        this.recursionCallPending = true;
        this.errorMessage = StringModel.startErrorMassage(recursionInfoLevel, StringModel.STRING_RESOURCES.STARTING_SYNTAX_CHECK);
    }

    private boolean checkPartialSyntaxImpliedMultiplication(String recursionInfoLevel) {
        if (!this.impliedMultiplicationMode && this.impliedMultiplicationError) {
            this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxDuplicatedKeywords(String recursionInfoLevel) {
        Collections.sort(this.keyWordsList, new KwStrComparator());
        for (int kwId = 1; kwId < this.keyWordsList.size(); ++kwId) {
            String kw1 = this.keyWordsList.get((int)(kwId - 1)).wordString;
            String kw2 = this.keyWordsList.get((int)kwId).wordString;
            if (!kw1.equals(kw2)) continue;
            this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.buildErrorMessageKeyword(StringModel.STRING_RESOURCES.DUPLICATED_KEYWORD, kw1));
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxUserDefinedArgument(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 101) {
            return true;
        }
        Argument arg = this.getArgument(token.tokenId);
        if (this.getParametersNumber(tokenIndex) >= 0) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ARGUMENT_WAS_EXPECTED, tokenInfoMessage);
            return false;
        }
        if (arg.getArgumentBodyType() == 2) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS, tokenInfoMessage);
            return true;
        }
        if (arg.getArgumentType() != 2) {
            return true;
        }
        if (arg.argumentExpression != this && !arg.argumentExpression.recursionCallPending) {
            boolean syntaxRec = arg.argumentExpression.checkSyntax(recursionInfoLevel + "-> " + StringUtils.surroundSquareBrackets(token.tokenStr) + " = " + StringUtils.surroundSquareBracketsAddSpace(arg.argumentExpression.expressionString), false);
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT, tokenInfoMessage, arg.argumentExpression.errorMessage);
            return syntaxRec;
        }
        return true;
    }

    private boolean checkPartialSyntaxUserDefinedRecursiveArgument(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 102) {
            return true;
        }
        Argument arg = this.getArgument(token.tokenId);
        if (this.getParametersNumber(tokenIndex) != 1) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER, tokenInfoMessage);
            return false;
        }
        if (arg.argumentExpression != this && !arg.argumentExpression.recursionCallPending) {
            boolean syntaxRec = arg.argumentExpression.checkSyntax(recursionInfoLevel + "-> " + StringUtils.surroundSquareBrackets(token.tokenStr) + " = " + StringUtils.surroundSquareBracketsAddSpace(arg.argumentExpression.expressionString), false);
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT, tokenInfoMessage, arg.argumentExpression.errorMessage);
            return syntaxRec;
        }
        return true;
    }

    private boolean checkPartialSyntaxInvalidToken(String recursionInfoLevel, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack) {
        if (token.tokenTypeId != -1) {
            return true;
        }
        boolean calculusToken = false;
        for (SyntaxStackElement e : syntaxStack) {
            if (!e.tokenStr.equals(token.tokenStr)) continue;
            calculusToken = true;
        }
        if (!calculusToken) {
            this.errorMessage = !this.impliedMultiplicationMode && StringUtils.regexMatch(token.tokenStr, "((([+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?|([+-]?[bB]1\\.(1)*|[+-]?[bB][2]?\\.[01]([01])*|[+-]?[bB]3\\.[0-2]([0-2])*|[+-]?[bB]4\\.[0-3]([0-3])*|[+-]?[bB]5\\.[0-4]([0-4])*|[+-]?[bB]6\\.[0-5]([0-5])*|[+-]?[bB]7\\.[0-6]([0-6])*|[+-]?([bB]8|[oO])\\.[0-7]([0-7])*|[+-]?[bB]9\\.[0-8]([0-8])*|[+-]?[bB]10\\.[0-9]([0-9])*|[+-]?[bB]11\\.[0-9aA]([0-9aA])*|[+-]?[bB]12\\.[0-9a-bA-B]([0-9a-bA-B])*|[+-]?[bB]13\\.[0-9a-cA-C]([0-9a-cA-C])*|[+-]?[bB]14\\.[0-9a-dA-D]([0-9a-dA-D])*|[+-]?[bB]15\\.[0-9a-eA-E]([0-9a-eA-E])*|[+-]?([bB]16|[hH])\\.[0-9a-fA-F]([0-9a-fA-F])*|[+-]?[bB]17\\.[0-9a-gA-G]([0-9a-gA-G])*|[+-]?[bB]18\\.[0-9a-hA-H]([0-9a-hA-H])*|[+-]?[bB]19\\.[0-9a-iA-I]([0-9a-iA-I])*|[+-]?[bB]20\\.[0-9a-jA-J]([0-9a-jA-J])*|[+-]?[bB]21\\.[0-9a-kA-K]([0-9a-kA-K])*|[+-]?[bB]22\\.[0-9a-lA-L]([0-9a-lA-L])*|[+-]?[bB]23\\.[0-9a-mA-M]([0-9a-mA-M])*|[+-]?[bB]24\\.[0-9a-nA-N]([0-9a-nA-N])*|[+-]?[bB]25\\.[0-9a-oA-O]([0-9a-oA-O])*|[+-]?[bB]26\\.[0-9a-pA-P]([0-9a-pA-P])*|[+-]?[bB]27\\.[0-9a-qA-Q]([0-9a-qA-Q])*|[+-]?[bB]28\\.[0-9a-rA-R]([0-9a-rA-R])*|[+-]?[bB]29\\.[0-9a-sA-S]([0-9a-sA-S])*|[+-]?[bB]30\\.[0-9a-tA-T]([0-9a-tA-T])*|[+-]?[bB]31\\.[0-9a-uA-U]([0-9a-uA-U])*|[+-]?[bB]32\\.[0-9a-vA-V]([0-9a-vA-V])*|[+-]?[bB]33\\.[0-9a-wA-W]([0-9a-wA-W])*|[+-]?[bB]34\\.[0-9a-xA-X]([0-9a-xA-X])*|[+-]?[bB]35\\.[0-9a-yA-Y]([0-9a-yA-Y])*|[+-]?[bB]36\\.[0-9a-zA-Z]([0-9a-zA-Z])*)|([0-9]([0-9])*_)?[0-9]([0-9])*_[0-9]([0-9])*)((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\]))+(([+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?|([+-]?[bB]1\\.(1)*|[+-]?[bB][2]?\\.[01]([01])*|[+-]?[bB]3\\.[0-2]([0-2])*|[+-]?[bB]4\\.[0-3]([0-3])*|[+-]?[bB]5\\.[0-4]([0-4])*|[+-]?[bB]6\\.[0-5]([0-5])*|[+-]?[bB]7\\.[0-6]([0-6])*|[+-]?([bB]8|[oO])\\.[0-7]([0-7])*|[+-]?[bB]9\\.[0-8]([0-8])*|[+-]?[bB]10\\.[0-9]([0-9])*|[+-]?[bB]11\\.[0-9aA]([0-9aA])*|[+-]?[bB]12\\.[0-9a-bA-B]([0-9a-bA-B])*|[+-]?[bB]13\\.[0-9a-cA-C]([0-9a-cA-C])*|[+-]?[bB]14\\.[0-9a-dA-D]([0-9a-dA-D])*|[+-]?[bB]15\\.[0-9a-eA-E]([0-9a-eA-E])*|[+-]?([bB]16|[hH])\\.[0-9a-fA-F]([0-9a-fA-F])*|[+-]?[bB]17\\.[0-9a-gA-G]([0-9a-gA-G])*|[+-]?[bB]18\\.[0-9a-hA-H]([0-9a-hA-H])*|[+-]?[bB]19\\.[0-9a-iA-I]([0-9a-iA-I])*|[+-]?[bB]20\\.[0-9a-jA-J]([0-9a-jA-J])*|[+-]?[bB]21\\.[0-9a-kA-K]([0-9a-kA-K])*|[+-]?[bB]22\\.[0-9a-lA-L]([0-9a-lA-L])*|[+-]?[bB]23\\.[0-9a-mA-M]([0-9a-mA-M])*|[+-]?[bB]24\\.[0-9a-nA-N]([0-9a-nA-N])*|[+-]?[bB]25\\.[0-9a-oA-O]([0-9a-oA-O])*|[+-]?[bB]26\\.[0-9a-pA-P]([0-9a-pA-P])*|[+-]?[bB]27\\.[0-9a-qA-Q]([0-9a-qA-Q])*|[+-]?[bB]28\\.[0-9a-rA-R]([0-9a-rA-R])*|[+-]?[bB]29\\.[0-9a-sA-S]([0-9a-sA-S])*|[+-]?[bB]30\\.[0-9a-tA-T]([0-9a-tA-T])*|[+-]?[bB]31\\.[0-9a-uA-U]([0-9a-uA-U])*|[+-]?[bB]32\\.[0-9a-vA-V]([0-9a-vA-V])*|[+-]?[bB]33\\.[0-9a-wA-W]([0-9a-wA-W])*|[+-]?[bB]34\\.[0-9a-xA-X]([0-9a-xA-X])*|[+-]?[bB]35\\.[0-9a-yA-Y]([0-9a-yA-Y])*|[+-]?[bB]36\\.[0-9a-zA-Z]([0-9a-zA-Z])*)|([0-9]([0-9])*_)?[0-9]([0-9])*_[0-9]([0-9])*))?|(((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\])([+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?|([+-]?[bB]1\\.(1)*|[+-]?[bB][2]?\\.[01]([01])*|[+-]?[bB]3\\.[0-2]([0-2])*|[+-]?[bB]4\\.[0-3]([0-3])*|[+-]?[bB]5\\.[0-4]([0-4])*|[+-]?[bB]6\\.[0-5]([0-5])*|[+-]?[bB]7\\.[0-6]([0-6])*|[+-]?([bB]8|[oO])\\.[0-7]([0-7])*|[+-]?[bB]9\\.[0-8]([0-8])*|[+-]?[bB]10\\.[0-9]([0-9])*|[+-]?[bB]11\\.[0-9aA]([0-9aA])*|[+-]?[bB]12\\.[0-9a-bA-B]([0-9a-bA-B])*|[+-]?[bB]13\\.[0-9a-cA-C]([0-9a-cA-C])*|[+-]?[bB]14\\.[0-9a-dA-D]([0-9a-dA-D])*|[+-]?[bB]15\\.[0-9a-eA-E]([0-9a-eA-E])*|[+-]?([bB]16|[hH])\\.[0-9a-fA-F]([0-9a-fA-F])*|[+-]?[bB]17\\.[0-9a-gA-G]([0-9a-gA-G])*|[+-]?[bB]18\\.[0-9a-hA-H]([0-9a-hA-H])*|[+-]?[bB]19\\.[0-9a-iA-I]([0-9a-iA-I])*|[+-]?[bB]20\\.[0-9a-jA-J]([0-9a-jA-J])*|[+-]?[bB]21\\.[0-9a-kA-K]([0-9a-kA-K])*|[+-]?[bB]22\\.[0-9a-lA-L]([0-9a-lA-L])*|[+-]?[bB]23\\.[0-9a-mA-M]([0-9a-mA-M])*|[+-]?[bB]24\\.[0-9a-nA-N]([0-9a-nA-N])*|[+-]?[bB]25\\.[0-9a-oA-O]([0-9a-oA-O])*|[+-]?[bB]26\\.[0-9a-pA-P]([0-9a-pA-P])*|[+-]?[bB]27\\.[0-9a-qA-Q]([0-9a-qA-Q])*|[+-]?[bB]28\\.[0-9a-rA-R]([0-9a-rA-R])*|[+-]?[bB]29\\.[0-9a-sA-S]([0-9a-sA-S])*|[+-]?[bB]30\\.[0-9a-tA-T]([0-9a-tA-T])*|[+-]?[bB]31\\.[0-9a-uA-U]([0-9a-uA-U])*|[+-]?[bB]32\\.[0-9a-vA-V]([0-9a-vA-V])*|[+-]?[bB]33\\.[0-9a-wA-W]([0-9a-wA-W])*|[+-]?[bB]34\\.[0-9a-xA-X]([0-9a-xA-X])*|[+-]?[bB]35\\.[0-9a-yA-Y]([0-9a-yA-Y])*|[+-]?[bB]36\\.[0-9a-zA-Z]([0-9a-zA-Z])*)|([0-9]([0-9])*_)?[0-9]([0-9])*_[0-9]([0-9])*))+(((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\]))?)") ? StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR, tokenInfoMessage) : StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.INVALID_TOKEN, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxUserDefinedFunction(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 103) {
            return true;
        }
        Function fun = this.getFunction(token.tokenId);
        fun.checkRecursiveMode();
        int npar = this.getParametersNumber(tokenIndex);
        int fpar = fun.getParametersNumber();
        if (npar <= 0) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT, tokenInfoMessage);
            return false;
        }
        if (!fun.isVariadic && fpar != npar) {
            this.errorMessage = StringModel.addErrorMassage(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION, fpar, npar, tokenInfoMessage);
            return false;
        }
        if (fun.functionExpression != this && !fun.functionExpression.recursionCallPending) {
            boolean syntaxRec = fun.getFunctionBodyType() == 1 ? fun.functionExpression.checkSyntax(recursionInfoLevel + "-> " + StringUtils.surroundSquareBrackets(token.tokenStr) + " = " + StringUtils.surroundSquareBracketsAddSpace(fun.functionExpression.expressionString), false) : fun.functionExpression.checkSyntax(recursionInfoLevel + "-> " + StringUtils.surroundSquareBrackets(token.tokenStr) + " = " + StringUtils.surroundSquareBracketsAddSpace(fun.functionExpression.expressionString), true);
            this.errorMessage = fun.isVariadic ? StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION, tokenInfoMessage, fun.functionExpression.errorMessage) : StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION, tokenInfoMessage, fun.functionExpression.errorMessage);
            return syntaxRec;
        }
        return true;
    }

    private boolean checkPartialSyntaxBuiltinConstant(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 9) {
            return true;
        }
        if (this.getParametersNumber(tokenIndex) >= 0) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.CONSTANT_WAS_EXPECTED, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxUserDefinedConstant(String recursionInfoLevel, int tokenIndex, Token token, String tokenStr) {
        if (token.tokenTypeId != 104) {
            return true;
        }
        if (this.getParametersNumber(tokenIndex) >= 0) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.USER_CONSTANT_WAS_EXPECTED, tokenStr);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxUnaryFunction(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 4) {
            return true;
        }
        if (this.getParametersNumber(tokenIndex) != 1) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.UNARY_FUNCTION_EXPECTS_1_PARAMETER, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxBinaryFunction(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 5) {
            return true;
        }
        if (this.getParametersNumber(tokenIndex) != 2) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.BINARY_FUNCTION_EXPECTS_2_PARAMETERS, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxTernaryFunction(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 6) {
            return true;
        }
        if (this.getParametersNumber(tokenIndex) != 3) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.TERNARY_FUNCTION_EXPECTS_3_PARAMETERS, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkInternalSyntaxCalculusOperatorDerivative(String recursionInfoLevel, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack, int paramsNumber, List<FunctionParameter> funParams) {
        if (token.tokenId != 6 && token.tokenId != 7 && token.tokenId != 8) {
            return true;
        }
        if (paramsNumber < 2 || paramsNumber > 5) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS, tokenInfoMessage);
            return false;
        }
        if (paramsNumber == 2 || paramsNumber == 4) {
            FunctionParameter argParam = funParams.get(1);
            if (!Expression.checkIfKnownArgument(argParam)) {
                this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION, tokenInfoMessage);
                return false;
            }
        } else {
            FunctionParameter argParam = funParams.get(1);
            SyntaxStackElement stackElement = new SyntaxStackElement(argParam.paramStr, token.tokenLevel + 1);
            syntaxStack.push(stackElement);
            int errors = this.checkCalculusParameter(stackElement.tokenStr);
            if (errors > 0) {
                this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION, tokenInfoMessage);
                return false;
            }
            if (!Expression.checkIfKnownArgument(argParam) && !Expression.checkIfUnknownToken(argParam)) {
                this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION, tokenInfoMessage);
                return false;
            }
        }
        return true;
    }

    private boolean checkInternalSyntaxCalculusOperatorDerivativeNth(String recursionInfoLevel, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack, int paramsNumber, List<FunctionParameter> funParams) {
        if (token.tokenId != 9) {
            return true;
        }
        if (paramsNumber != 3 && paramsNumber != 5) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS, tokenInfoMessage);
            return false;
        }
        FunctionParameter argParam = funParams.get(2);
        if (!Expression.checkIfKnownArgument(argParam)) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkInternalSyntaxCalculusOperatorIntegralSolve(String recursionInfoLevel, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack, int paramsNumber, List<FunctionParameter> funParams) {
        if (token.tokenId != 5 && token.tokenId != 17) {
            return true;
        }
        if (paramsNumber != 4) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS, tokenInfoMessage);
            return false;
        }
        FunctionParameter argParam = funParams.get(1);
        SyntaxStackElement stackElement = new SyntaxStackElement(argParam.paramStr, token.tokenLevel + 1);
        syntaxStack.push(stackElement);
        int errors = this.checkCalculusParameter(stackElement.tokenStr);
        if (errors > 0) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION, tokenInfoMessage);
            return false;
        }
        if (!Expression.checkIfKnownArgument(argParam) && !Expression.checkIfUnknownToken(argParam)) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkInternalSyntaxCalculusOperatorIterated(String recursionInfoLevel, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack, int paramsNumber, List<FunctionParameter> funParams) {
        if (token.tokenId != 3 && token.tokenId != 1 && token.tokenId != 15 && token.tokenId != 16 && token.tokenId != 12 && token.tokenId != 13 && token.tokenId != 14) {
            return true;
        }
        if (paramsNumber != 4 && paramsNumber != 5) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS, tokenInfoMessage);
            return false;
        }
        FunctionParameter indexParam = funParams.get(0);
        SyntaxStackElement stackElement = new SyntaxStackElement(indexParam.paramStr, token.tokenLevel + 1);
        syntaxStack.push(stackElement);
        int errors = this.checkCalculusParameter(stackElement.tokenStr);
        if (errors > 0) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION, tokenInfoMessage);
            return false;
        }
        if (!Expression.checkIfKnownArgument(indexParam) && !Expression.checkIfUnknownToken(indexParam)) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkInternalSyntaxCalculusOperatorForwardBackwardDiff(String recursionInfoLevel, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack, int paramsNumber, List<FunctionParameter> funParams) {
        if (token.tokenId != 10 && token.tokenId != 11) {
            return true;
        }
        if (paramsNumber != 2 && paramsNumber != 3) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS, tokenInfoMessage);
            return false;
        }
        FunctionParameter xParam = funParams.get(1);
        if (!Expression.checkIfKnownArgument(xParam)) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxVariadicFunction(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage) {
        if (token.tokenTypeId != 7) {
            return true;
        }
        int paramsNumber = this.getParametersNumber(tokenIndex);
        if (paramsNumber < 1) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED, tokenInfoMessage);
            return false;
        }
        if (token.tokenId == 1 && (paramsNumber % 2 != 0 || paramsNumber < 2)) {
            this.errorMessage = StringModel.addErrorMassageTokenString(this.errorMessage, recursionInfoLevel, StringModel.STRING_RESOURCES.EXPECTED_EVEN_NUMBER_OF_ARGUMENTS, tokenInfoMessage);
            return false;
        }
        return true;
    }

    private boolean checkPartialSyntaxCalculusOperator(String recursionInfoLevel, int tokenIndex, Token token, String tokenInfoMessage, Stack<SyntaxStackElement> syntaxStack) {
        if (token.tokenTypeId != 8) {
            return true;
        }
        int paramsNumber = this.getParametersNumber(tokenIndex);
        List<FunctionParameter> funParams = null;
        if (paramsNumber > 0) {
            funParams = ExpressionUtils.getFunctionParameters(tokenIndex, this.initialTokens);
        }
        boolean syntax = true;
        syntax = this.checkInternalSyntaxCalculusOperatorDerivative(recursionInfoLevel, token, tokenInfoMessage, syntaxStack, paramsNumber, funParams) && syntax;
        syntax = this.checkInternalSyntaxCalculusOperatorDerivativeNth(recursionInfoLevel, token, tokenInfoMessage, syntaxStack, paramsNumber, funParams) && syntax;
        syntax = this.checkInternalSyntaxCalculusOperatorIntegralSolve(recursionInfoLevel, token, tokenInfoMessage, syntaxStack, paramsNumber, funParams) && syntax;
        syntax = this.checkInternalSyntaxCalculusOperatorIterated(recursionInfoLevel, token, tokenInfoMessage, syntaxStack, paramsNumber, funParams) && syntax;
        syntax = this.checkInternalSyntaxCalculusOperatorForwardBackwardDiff(recursionInfoLevel, token, tokenInfoMessage, syntaxStack, paramsNumber, funParams) && syntax;
        return syntax;
    }

    private static void performSyntaxStackPopIfEndOfSectionLevel(Token token, Stack<SyntaxStackElement> syntaxStack) {
        if (token.tokenTypeId == 20 && token.tokenId == 2 && !syntaxStack.isEmpty() && token.tokenLevel == ((SyntaxStackElement)syntaxStack.lastElement()).tokenLevel) {
            syntaxStack.pop();
        }
    }

    private boolean checkSyntax(String recursionInfoLevel, boolean functionWithBodyExt) {
        if (this.syntaxIsAlreadyCheckedNorErrors()) {
            this.registerFinalSyntaxAlreadyCheckedNorErrors(recursionInfoLevel);
            return true;
        }
        this.optionsChangesetNumber = mXparser.optionsChangesetNumber;
        if (functionWithBodyExt) {
            this.registerFinalSyntaxFunctionWithBodyExtNoErrors(recursionInfoLevel);
            return true;
        }
        this.registerPartialSyntaxStartingSyntaxCheck(recursionInfoLevel);
        boolean syntax = true;
        this.cleanExpressionString();
        if (this.expressionStringCleaned.isEmpty()) {
            this.registerFinalSyntaxExpressionStringIsEmpty(recursionInfoLevel);
            return false;
        }
        SyntaxChecker syn = new SyntaxChecker(new ByteArrayInputStream(this.expressionStringCleaned.getBytes()));
        try {
            syn.checkSyntax();
            this.tokenizeExpressionString();
            syntax = this.checkPartialSyntaxImpliedMultiplication(recursionInfoLevel) && syntax;
            syntax = this.checkPartialSyntaxDuplicatedKeywords(recursionInfoLevel) && syntax;
            int tokensNumber = this.initialTokens.size();
            Stack<SyntaxStackElement> syntaxStack = new Stack<SyntaxStackElement>();
            for (int tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
                String tokenInfoMessage;
                Token token = this.initialTokens.get(tokenIndex);
                syntax = this.checkPartialSyntaxUserDefinedArgument(recursionInfoLevel, tokenIndex, token, tokenInfoMessage = StringModel.buildTokenString(token.tokenStr, tokenIndex)) && syntax;
                syntax = this.checkPartialSyntaxUserDefinedRecursiveArgument(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxInvalidToken(recursionInfoLevel, token, tokenInfoMessage, syntaxStack) && syntax;
                syntax = this.checkPartialSyntaxUserDefinedFunction(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxBuiltinConstant(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxUserDefinedConstant(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxUnaryFunction(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxBinaryFunction(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxTernaryFunction(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                syntax = this.checkPartialSyntaxCalculusOperator(recursionInfoLevel, tokenIndex, token, tokenInfoMessage, syntaxStack) && syntax;
                syntax = this.checkPartialSyntaxVariadicFunction(recursionInfoLevel, tokenIndex, token, tokenInfoMessage) && syntax;
                Expression.performSyntaxStackPopIfEndOfSectionLevel(token, syntaxStack);
            }
        }
        catch (Exception e) {
            this.registerSyntaxLexicalError(recursionInfoLevel, e);
            syntax = false;
        }
        this.registerFinalSyntax(recursionInfoLevel, syntax);
        return syntax;
    }

    public double calculate() {
        return this.calculate(null);
    }

    private void registerErrorWhileCalculate(String errorMessageToAdd) {
        this.errorMessage = StringModel.addErrorMassageNoLevel(this.errorMessage, errorMessageToAdd, this.description, this.expressionString);
        this.errorMessageCalculate = StringModel.addErrorMassageNoLevel(this.errorMessageCalculate, errorMessageToAdd, this.description, this.expressionString);
    }

    public double calculate(CalcStepsRegister calcStepsRegister) {
        License.checkLicense();
        try {
            return this.calculateInternal(calcStepsRegister);
        }
        catch (Throwable e) {
            this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.ERROR_WHILE_EXECUTING_THE_CALCULATE + " " + StringModel.STRING_RESOURCES.EXCEPTION + ": " + e.getClass().getSimpleName() + ": " + StringUtils.trimNotNull(e.getMessage()));
            return Double.NaN;
        }
    }

    private String makeStepDescription() {
        String stepDescription = !this.description.trim().isEmpty() ? this.description.trim() + " = " + this.expressionString.trim() : this.expressionString.trim();
        return stepDescription;
    }

    private void registerCalculationStepRecord(CalcStepsRegister calcStepsRegister, int stepsRegisteredCounter, String stepDescription) {
        CalcStepRecord stepRecord = new CalcStepRecord();
        stepRecord.numberGroup = calcStepsRegister.stepNumberGroup;
        stepRecord.numberGroupWithin = stepsRegisteredCounter;
        stepRecord.description = stepDescription;
        stepRecord.content = ExpressionUtils.tokensListToString(this.tokensList);
        stepRecord.type = calcStepsRegister.stepType;
        if (stepsRegisteredCounter == 1) {
            stepRecord.firstInGroup = true;
        }
        calcStepsRegister.calcStepRecords.add(stepRecord);
    }

    private void registerCalculationStepRecord(CalcStepsRegister calcStepsRegister, int stepsRegisteredCounter, String stepDescription, double result) {
        CalcStepRecord stepRecord = new CalcStepRecord();
        stepRecord.numberGroup = calcStepsRegister.stepNumberGroup--;
        stepRecord.numberGroupWithin = stepsRegisteredCounter;
        stepRecord.description = stepDescription;
        stepRecord.content = ExpressionUtils.tokensListToString(this.tokensList);
        stepRecord.type = calcStepsRegister.stepType;
        stepRecord.lastInGroup = true;
        calcStepsRegister.calcStepRecords.add(stepRecord);
        if (calcStepsRegister.stepNumberGroup == 0) {
            calcStepsRegister.result = result;
            calcStepsRegister.computingTime = this.computingTime;
            calcStepsRegister.errorMessage = this.errorMessage;
        }
    }

    private int calculateFirstAndFullyCompile(CalcStepsRegister calcStepsRegister, String stepDescription) {
        ArrayList<Integer> commas = null;
        int emptyLoopCounter = 0;
        boolean storeStepsInRegister = true;
        int stepsRegisteredCounter = 0;
        CalcStepRecord.StepType stepTypePrev = CalcStepRecord.StepType.Unknown;
        do {
            int firstPos;
            Token token;
            if (storeStepsInRegister && calcStepsRegister != null) {
                this.registerCalculationStepRecord(calcStepsRegister, ++stepsRegisteredCounter, stepDescription);
            }
            storeStepsInRegister = true;
            if (mXparser.cancelCurrentCalculationFlag) {
                this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.CANCEL_REQUEST_FINISHING);
                return -1;
            }
            int tokensNumber = this.tokensList.size();
            int maxPartLevel = -1;
            boolean maxPartLevelNotInterrupted = false;
            int lPos = -1;
            int rPos = -1;
            int calculusPos = -1;
            int ifPos = -1;
            int iffPos = -1;
            int variadicFunPos = -1;
            int recArgPos = -1;
            int depArgPos = -1;
            int f3ArgPos = -1;
            int f2ArgPos = -1;
            int f1ArgPos = -1;
            int userFunPos = -1;
            int plusPos = -1;
            int minusPos = -1;
            int multiplyPos = -1;
            int dividePos = -1;
            int divideQuotientPos = -1;
            int powerPos = -1;
            int tetrationPos = -1;
            int factPos = -1;
            int modPos = -1;
            int percPos = -1;
            int powerNum = 0;
            int negPos = -1;
            int rootOperGroupPos = -1;
            int andGroupPos = -1;
            int orGroupPos = -1;
            int implGroupPos = -1;
            int bolPos = -1;
            int eqPos = -1;
            int neqPos = -1;
            int ltPos = -1;
            int gtPos = -1;
            int leqPos = -1;
            int geqPos = -1;
            int commaPos = -1;
            int lParPos = -1;
            int rParPos = -1;
            int bitwisePos = -1;
            int bitwiseComplPos = -1;
            int p = -1;
            if (this.compilationDetails.containsCalculus || this.compilationDetails.containsIf) {
                do {
                    token = this.tokensList.get(++p);
                    if (token.tokenTypeId == 8) {
                        calculusPos = p;
                        continue;
                    }
                    if (token.tokenTypeId == 6 && token.tokenId == 1) {
                        ifPos = p;
                        continue;
                    }
                    if (token.tokenTypeId != 7 || token.tokenId != 1) continue;
                    iffPos = p;
                } while (p < tokensNumber - 1 && calculusPos < 0 && ifPos < 0 && iffPos < 0);
            }
            if (calculusPos < 0 && ifPos < 0 && iffPos < 0) {
                Argument argument;
                int tokenIndex;
                for (tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
                    token = this.tokensList.get(tokenIndex);
                    if (token.tokenLevel > maxPartLevel) {
                        maxPartLevel = this.tokensList.get((int)tokenIndex).tokenLevel;
                        lPos = tokenIndex;
                        maxPartLevelNotInterrupted = true;
                    }
                    if (token.tokenLevel < maxPartLevel) {
                        maxPartLevelNotInterrupted = false;
                    }
                    if (maxPartLevelNotInterrupted && token.tokenLevel == maxPartLevel) {
                        rPos = tokenIndex;
                    }
                    if (token.tokenTypeId == 101) {
                        argument = this.argumentsList.get(this.tokensList.get((int)tokenIndex).tokenId);
                        if (argument.argumentType == 1) {
                            this.FREE_ARGUMENT(tokenIndex);
                            continue;
                        }
                        depArgPos = tokenIndex;
                        continue;
                    }
                    if (token.tokenTypeId == 9) {
                        this.CONSTANT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 12) {
                        this.UNIT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 104) {
                        this.USER_CONSTANT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId != 10) continue;
                    this.RANDOM_VARIABLE(tokenIndex);
                }
                if (lPos < 0) {
                    this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING);
                    return -1;
                }
                if (depArgPos >= 0) {
                    boolean depArgFound;
                    block3: do {
                        depArgFound = false;
                        int currentTokensNumber = this.tokensList.size();
                        for (tokenIndex = 0; tokenIndex < currentTokensNumber; ++tokenIndex) {
                            token = this.tokensList.get(tokenIndex);
                            if (token.tokenTypeId != 101) continue;
                            argument = this.argumentsList.get(this.tokensList.get((int)tokenIndex).tokenId);
                            if (argument.argumentType != 2) continue;
                            if (calcStepsRegister != null) {
                                stepTypePrev = calcStepsRegister.stepType;
                            }
                            this.DEPENDENT_ARGUMENT(tokenIndex, calcStepsRegister);
                            if (calcStepsRegister != null) {
                                calcStepsRegister.stepType = stepTypePrev;
                                this.registerCalculationStepRecord(calcStepsRegister, ++stepsRegisteredCounter, stepDescription);
                            }
                            depArgFound = true;
                            continue block3;
                        }
                    } while (depArgFound);
                    storeStepsInRegister = false;
                } else {
                    if (this.verboseMode) {
                        this.printSystemInfo(StringModel.STRING_RESOURCES.PARSING + " " + StringUtils.surroundBracketsAddSpace(lPos + ", " + rPos), true);
                        this.showParsing(lPos, rPos);
                    }
                    for (int pos = lPos; pos <= rPos; ++pos) {
                        boolean leftIsNumber = false;
                        boolean rigthIsNumber = false;
                        token = this.tokensList.get(pos);
                        if (pos - 1 >= 0) {
                            Token tokenL = this.tokensList.get(pos - 1);
                            if (tokenL.tokenTypeId == 0) {
                                leftIsNumber = true;
                            }
                        }
                        if (pos + 1 < tokensNumber) {
                            Token tokenR = this.tokensList.get(pos + 1);
                            if (tokenR.tokenTypeId == 0) {
                                rigthIsNumber = true;
                            }
                        }
                        if (token.tokenTypeId == 102 && recArgPos < 0) {
                            recArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 7 && variadicFunPos < 0) {
                            variadicFunPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 6 && f3ArgPos < 0) {
                            f3ArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 5 && f2ArgPos < 0) {
                            f2ArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 4 && f1ArgPos < 0) {
                            f1ArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 103 && userFunPos < 0) {
                            userFunPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 1) {
                            if (token.tokenId == 5 && leftIsNumber && rigthIsNumber) {
                                powerPos = pos;
                                ++powerNum;
                                continue;
                            }
                            if (token.tokenId == 9 && leftIsNumber && rigthIsNumber) {
                                tetrationPos = pos;
                                continue;
                            }
                            if (token.tokenId == 6 && factPos < 0 && leftIsNumber) {
                                factPos = pos;
                                continue;
                            }
                            if (token.tokenId == 8 && percPos < 0 && leftIsNumber) {
                                percPos = pos;
                                continue;
                            }
                            if ((token.tokenId == 10 || token.tokenId == 11 || token.tokenId == 12) && rootOperGroupPos < 0 && rigthIsNumber) {
                                rootOperGroupPos = pos;
                                continue;
                            }
                            if (token.tokenId == 7 && modPos < 0 && leftIsNumber && rigthIsNumber) {
                                modPos = pos;
                                continue;
                            }
                            if (token.tokenId == 1 && plusPos < 0 && rigthIsNumber) {
                                plusPos = pos;
                                continue;
                            }
                            if (token.tokenId == 2 && minusPos < 0 && rigthIsNumber) {
                                minusPos = pos;
                                continue;
                            }
                            if (token.tokenId == 3 && multiplyPos < 0 && leftIsNumber && rigthIsNumber) {
                                multiplyPos = pos;
                                continue;
                            }
                            if (token.tokenId == 4 && dividePos < 0 && leftIsNumber && rigthIsNumber) {
                                dividePos = pos;
                                continue;
                            }
                            if (token.tokenId != 13 || divideQuotientPos >= 0 || !leftIsNumber || !rigthIsNumber) continue;
                            divideQuotientPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 2) {
                            if (token.tokenId == 11 && negPos < 0 && rigthIsNumber) {
                                negPos = pos;
                                continue;
                            }
                            if (!leftIsNumber || !rigthIsNumber) continue;
                            if ((token.tokenId == 1 || token.tokenId == 2) && andGroupPos < 0) {
                                andGroupPos = pos;
                                continue;
                            }
                            if ((token.tokenId == 3 || token.tokenId == 4 || token.tokenId == 5) && orGroupPos < 0) {
                                orGroupPos = pos;
                                continue;
                            }
                            if ((token.tokenId == 6 || token.tokenId == 7 || token.tokenId == 8 || token.tokenId == 9 || token.tokenId == 10) && implGroupPos < 0) {
                                implGroupPos = pos;
                                continue;
                            }
                            if (bolPos >= 0) continue;
                            bolPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 3) {
                            if (token.tokenId == 1 && eqPos < 0 && leftIsNumber && rigthIsNumber) {
                                eqPos = pos;
                                continue;
                            }
                            if (token.tokenId == 2 && neqPos < 0 && leftIsNumber && rigthIsNumber) {
                                neqPos = pos;
                                continue;
                            }
                            if (token.tokenId == 3 && ltPos < 0 && leftIsNumber && rigthIsNumber) {
                                ltPos = pos;
                                continue;
                            }
                            if (token.tokenId == 4 && gtPos < 0 && leftIsNumber && rigthIsNumber) {
                                gtPos = pos;
                                continue;
                            }
                            if (token.tokenId == 5 && leqPos < 0 && leftIsNumber && rigthIsNumber) {
                                leqPos = pos;
                                continue;
                            }
                            if (token.tokenId != 6 || geqPos >= 0 || !leftIsNumber || !rigthIsNumber) continue;
                            geqPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 11) {
                            if (token.tokenId == 1 && bitwiseComplPos < 0 && rigthIsNumber) {
                                bitwiseComplPos = pos;
                                continue;
                            }
                            if (bitwisePos >= 0 || !leftIsNumber || !rigthIsNumber) continue;
                            bitwisePos = pos;
                            continue;
                        }
                        if (token.tokenTypeId != 20) continue;
                        if (token.tokenId == 3) {
                            if (commaPos < 0) {
                                commas = new ArrayList<Integer>();
                            }
                            commas.add(pos);
                            commaPos = pos;
                            continue;
                        }
                        if (token.tokenId == 1 && lParPos < 0) {
                            lParPos = pos;
                            continue;
                        }
                        if (token.tokenId != 2 || rParPos >= 0) continue;
                        rParPos = pos;
                    }
                    if (powerNum > 1) {
                        powerPos = -1;
                        p = rPos + 1;
                        do {
                            token = this.tokensList.get(--p);
                            if (token.tokenTypeId != 1 || token.tokenId != 5) continue;
                            powerPos = p;
                        } while (p > lPos && powerPos == -1);
                    }
                }
            }
            if (calculusPos >= 0) {
                this.calculusCalc(calculusPos);
            } else if (ifPos >= 0) {
                this.IF_CONDITION(ifPos);
            } else if (iffPos >= 0) {
                this.IFF(iffPos);
            } else if (recArgPos >= 0) {
                this.RECURSIVE_ARGUMENT(recArgPos);
            } else if (variadicFunPos >= 0) {
                this.variadicFunCalc(variadicFunPos);
            } else if (f3ArgPos >= 0) {
                this.f3ArgCalc(f3ArgPos);
            } else if (f2ArgPos >= 0) {
                this.f2ArgCalc(f2ArgPos);
            } else if (f1ArgPos >= 0) {
                this.f1ArgCalc(f1ArgPos);
            } else if (userFunPos >= 0) {
                if (calcStepsRegister != null) {
                    stepTypePrev = calcStepsRegister.stepType;
                }
                this.USER_FUNCTION(userFunPos, calcStepsRegister);
                if (calcStepsRegister != null) {
                    calcStepsRegister.stepType = stepTypePrev;
                }
            } else if (tetrationPos >= 0) {
                this.TETRATION(tetrationPos);
            } else if (powerPos >= 0) {
                this.POWER(powerPos);
            } else if (factPos >= 0) {
                this.FACT(factPos);
            } else if (percPos >= 0) {
                this.PERC(percPos);
            } else if (modPos >= 0) {
                this.MODULO(modPos);
            } else if (negPos >= 0) {
                this.NEG(negPos);
            } else if (rootOperGroupPos >= 0) {
                this.rootOperCalc(rootOperGroupPos);
            } else if (bitwiseComplPos >= 0) {
                this.BITWISE_COMPL(bitwiseComplPos);
            } else if (multiplyPos >= 0 || dividePos >= 0 || divideQuotientPos >= 0) {
                firstPos = ExpressionUtils.findNonNegativeMinimum(multiplyPos, dividePos, divideQuotientPos);
                if (multiplyPos == firstPos) {
                    this.MULTIPLY(multiplyPos);
                } else if (dividePos == firstPos) {
                    this.DIVIDE(dividePos);
                } else if (divideQuotientPos == firstPos) {
                    this.DIVIDE_QUOTIENT(divideQuotientPos);
                }
            } else if (minusPos >= 0 || plusPos >= 0) {
                firstPos = ExpressionUtils.findNonNegativeMinimum(minusPos, plusPos);
                if (minusPos == firstPos) {
                    this.MINUS(minusPos);
                } else if (plusPos == firstPos) {
                    this.PLUS(plusPos);
                }
            } else if (neqPos >= 0) {
                this.NEQ(neqPos);
            } else if (eqPos >= 0) {
                this.EQ(eqPos);
            } else if (ltPos >= 0) {
                this.LT(ltPos);
            } else if (gtPos >= 0) {
                this.GT(gtPos);
            } else if (leqPos >= 0) {
                this.LEQ(leqPos);
            } else if (geqPos >= 0) {
                this.GEQ(geqPos);
            } else if (commaPos >= 0) {
                for (int i = commas.size() - 1; i >= 0; --i) {
                    this.COMMA((Integer)commas.get(i));
                }
                storeStepsInRegister = false;
            } else if (andGroupPos >= 0) {
                this.bolCalc(andGroupPos);
            } else if (orGroupPos >= 0) {
                this.bolCalc(orGroupPos);
            } else if (implGroupPos >= 0) {
                this.bolCalc(implGroupPos);
            } else if (bolPos >= 0) {
                this.bolCalc(bolPos);
            } else if (bitwisePos >= 0) {
                this.bitwiseCalc(bitwisePos);
            } else if (lParPos >= 0 && rParPos > lParPos) {
                this.PARENTHESES(lParPos, rParPos);
                storeStepsInRegister = false;
            }
            if (this.verboseMode) {
                this.showParsing(0, this.tokensList.size() - 1);
                this.printSystemInfo(" " + StringModel.STRING_RESOURCES.DONE + StringInvariant.NEW_LINE, false);
            }
            emptyLoopCounter = this.tokensList.size() == tokensNumber ? ++emptyLoopCounter : 0;
            if (emptyLoopCounter <= 10) continue;
            this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN);
            return -1;
        } while (this.tokensList.size() > 1);
        if (!this.compilationDetails.containsIf) {
            this.isFullyCompiled = true;
        }
        return stepsRegisteredCounter;
    }

    private int applySequenceFromCompilation(CalcStepsRegister calcStepsRegister, String stepDescription) {
        int stepsRegisteredCounter = 0;
        CalcStepRecord.StepType stepTypePrev = CalcStepRecord.StepType.Unknown;
        boolean storeStepsInRegister = true;
        for (CompiledElement compiledElement : this.initialCompilationDetails.compiledElements) {
            if (mXparser.cancelCurrentCalculationFlag) {
                this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.CANCEL_REQUEST_FINISHING);
                return -1;
            }
            if (storeStepsInRegister && calcStepsRegister != null) {
                this.registerCalculationStepRecord(calcStepsRegister, ++stepsRegisteredCounter, stepDescription);
            }
            storeStepsInRegister = true;
            int pos = compiledElement.position1;
            if (this.verboseMode) {
                this.printSystemInfo(StringModel.STRING_RESOURCES.PARSING + " " + StringUtils.surroundBracketsAddSpace(pos + ", " + pos), true);
                this.showParsing(pos, pos);
            }
            switch (compiledElement.toCall) {
                case FREE_ARGUMENT: {
                    this.FREE_ARGUMENT(pos);
                    storeStepsInRegister = false;
                    break;
                }
                case CONSTANT: {
                    this.CONSTANT(pos);
                    storeStepsInRegister = false;
                    break;
                }
                case UNIT: {
                    this.UNIT(pos);
                    storeStepsInRegister = false;
                    break;
                }
                case USER_CONSTANT: {
                    this.USER_CONSTANT(pos);
                    storeStepsInRegister = false;
                    break;
                }
                case RANDOM_VARIABLE: {
                    this.RANDOM_VARIABLE(pos);
                    storeStepsInRegister = false;
                    break;
                }
                case DEPENDENT_ARGUMENT: {
                    if (calcStepsRegister != null) {
                        stepTypePrev = calcStepsRegister.stepType;
                    }
                    this.DEPENDENT_ARGUMENT(pos, calcStepsRegister);
                    if (calcStepsRegister == null) break;
                    calcStepsRegister.stepType = stepTypePrev;
                    break;
                }
                case calculusCalc: {
                    this.calculusCalc(pos);
                    break;
                }
                case IF_CONDITION: {
                    this.IF_CONDITION(pos);
                    break;
                }
                case IFF: {
                    this.IFF(pos);
                    break;
                }
                case RECURSIVE_ARGUMENT: {
                    this.RECURSIVE_ARGUMENT(pos);
                    break;
                }
                case variadicFunCalc: {
                    this.variadicFunCalc(pos);
                    break;
                }
                case f3ArgCalc: {
                    this.f3ArgCalc(pos);
                    break;
                }
                case f2ArgCalc: {
                    this.f2ArgCalc(pos);
                    break;
                }
                case f1ArgCalc: {
                    this.f1ArgCalc(pos);
                    break;
                }
                case USER_FUNCTION: {
                    if (calcStepsRegister != null) {
                        stepTypePrev = calcStepsRegister.stepType;
                    }
                    this.USER_FUNCTION(pos, calcStepsRegister);
                    if (calcStepsRegister == null) break;
                    calcStepsRegister.stepType = stepTypePrev;
                    break;
                }
                case TETRATION: {
                    this.TETRATION(pos);
                    break;
                }
                case POWER: {
                    this.POWER(pos);
                    break;
                }
                case FACT: {
                    this.FACT(pos);
                    break;
                }
                case PERC: {
                    this.PERC(pos);
                    break;
                }
                case MODULO: {
                    this.MODULO(pos);
                    break;
                }
                case NEG: {
                    this.NEG(pos);
                    break;
                }
                case rootOperCalc: {
                    this.rootOperCalc(pos);
                    break;
                }
                case BITWISE_COMPL: {
                    this.BITWISE_COMPL(pos);
                    break;
                }
                case MULTIPLY: {
                    this.MULTIPLY(pos);
                    break;
                }
                case DIVIDE: {
                    this.DIVIDE(pos);
                    break;
                }
                case DIVIDE_QUOTIENT: {
                    this.DIVIDE_QUOTIENT(pos);
                    break;
                }
                case MINUS: {
                    this.MINUS(pos);
                    break;
                }
                case PLUS: {
                    this.PLUS(pos);
                    break;
                }
                case NEQ: {
                    this.NEQ(pos);
                    break;
                }
                case EQ: {
                    this.EQ(pos);
                    break;
                }
                case LT: {
                    this.LT(pos);
                    break;
                }
                case GT: {
                    this.GT(pos);
                    break;
                }
                case LEQ: {
                    this.LEQ(pos);
                    break;
                }
                case GEQ: {
                    this.GEQ(pos);
                    break;
                }
                case COMMA: {
                    this.COMMA(pos);
                    storeStepsInRegister = false;
                    break;
                }
                case bolCalc: {
                    this.bolCalc(pos);
                    break;
                }
                case bitwiseCalc: {
                    this.bitwiseCalc(pos);
                    break;
                }
                case PARENTHESES: {
                    this.PARENTHESES(compiledElement.position1, compiledElement.position2);
                    storeStepsInRegister = false;
                }
            }
            if (!this.verboseMode) continue;
            this.showParsing(0, this.tokensList.size() - 1);
            this.printSystemInfo(" " + StringModel.STRING_RESOURCES.DONE + StringInvariant.NEW_LINE, false);
        }
        return stepsRegisteredCounter;
    }

    private double calculateInternal(CalcStepsRegister calcStepsRegister) {
        int stepsRegisteredCounter;
        this.computingTime = 0.0;
        long startTime = System.currentTimeMillis();
        if (this.verboseMode) {
            this.printSystemInfo(StringInvariant.NEW_LINE, false);
            this.printSystemInfo(StringInvariant.NEW_LINE, true);
            this.printSystemInfo(StringModel.STRING_RESOURCES.STARTING + StringInvariant.NEW_LINE, true);
            this.showArguments();
        }
        if (this.expressionWasModified || !this.syntaxStatus) {
            this.syntaxStatus = this.checkSyntax();
        }
        if (!this.syntaxStatus) {
            if (this.verboseMode) {
                this.printSystemInfo(StringModel.STRING_RESOURCES.PROBLEM_WITH_EXPRESSION_SYNTAX + StringInvariant.NEW_LINE, false);
            }
            this.recursionCallsCounter = 0;
            return Double.NaN;
        }
        if (this.recursionCallsCounter == 0 || this.internalClone) {
            this.copyInitialTokens();
        }
        if (this.tokensList.isEmpty()) {
            this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS);
            if (this.verboseMode) {
                this.printSystemInfo(StringModel.STRING_RESOURCES.EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS + StringInvariant.NEW_LINE, false);
            }
            this.recursionCallsCounter = 0;
            return Double.NaN;
        }
        if (this.recursionCallsCounter >= mXparser.MAX_RECURSION_CALLS) {
            if (this.verboseMode) {
                this.printSystemInfo(StringModel.STRING_RESOURCES.RECURSION_CALLS_COUNTER_EXCEEDED + StringInvariant.NEW_LINE, false);
            }
            --this.recursionCallsCounter;
            this.registerErrorWhileCalculate(StringModel.STRING_RESOURCES.RECURSION_CALLS_COUNTER_EXCEEDED);
            return Double.NaN;
        }
        ++this.recursionCallsCounter;
        if (this.verboseMode) {
            this.printSystemInfo(StringModel.STRING_RESOURCES.STARTING_CALCULATION_LOOP + StringInvariant.NEW_LINE, true);
        }
        CalcStepsRegister.stepNumberGroupIncrease(calcStepsRegister, this);
        String stepDescription = "";
        if (calcStepsRegister != null) {
            stepDescription = this.makeStepDescription();
        }
        if (this.verboseMode) {
            this.printSystemInfo(StringModel.STRING_RESOURCES.FULLY_COMPILED + " = " + this.isFullyCompiled + StringInvariant.NEW_LINE, true);
        }
        if (this.isFullyCompiled) {
            stepsRegisteredCounter = this.applySequenceFromCompilation(calcStepsRegister, stepDescription);
        } else {
            stepsRegisteredCounter = this.calculateFirstAndFullyCompile(calcStepsRegister, stepDescription);
            if (stepsRegisteredCounter < 0) {
                return Double.NaN;
            }
        }
        if (this.verboseMode) {
            this.printSystemInfo(StringModel.STRING_RESOURCES.CALCULATED_VALUE + ": " + this.tokensList.get((int)0).tokenValue + StringInvariant.NEW_LINE, true);
            this.printSystemInfo(StringModel.STRING_RESOURCES.EXITING + StringInvariant.NEW_LINE, true);
            this.printSystemInfo(StringInvariant.NEW_LINE, false);
        }
        long endTime = System.currentTimeMillis();
        this.computingTime = (double)(endTime - startTime) / 1000.0;
        --this.recursionCallsCounter;
        double result = this.tokensList.get((int)0).tokenValue;
        if (!this.disableRounding) {
            double resultInt;
            if (mXparser.almostIntRounding && Math.abs(result - (resultInt = (double)Math.round(result))) <= BinaryRelations.getEpsilon()) {
                result = resultInt;
            }
            if (mXparser.canonicalRounding) {
                result = MathFunctions.lengthRound(result);
            }
        }
        if (calcStepsRegister != null) {
            this.registerCalculationStepRecord(calcStepsRegister, ++stepsRegisteredCounter, stepDescription, result);
        }
        return result;
    }

    private void registerCompiledElement(CompiledElement.ToCall toCall, int position) {
        CompiledElement compiledElement = new CompiledElement();
        compiledElement.toCall = toCall;
        compiledElement.position1 = position;
        this.initialCompilationDetails.compiledElements.add(compiledElement);
    }

    private void registerCompiledElement(CompiledElement.ToCall toCall, int position1, int position2) {
        CompiledElement compiledElement = new CompiledElement();
        compiledElement.toCall = toCall;
        compiledElement.position1 = position1;
        compiledElement.position2 = position2;
        this.initialCompilationDetails.compiledElements.add(compiledElement);
    }

    private void f1ArgCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.f1ArgCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.SIN(pos);
                break;
            }
            case 2: {
                this.COS(pos);
                break;
            }
            case 3: {
                this.TAN(pos);
                break;
            }
            case 4: {
                this.CTAN(pos);
                break;
            }
            case 5: {
                this.SEC(pos);
                break;
            }
            case 6: {
                this.COSEC(pos);
                break;
            }
            case 7: {
                this.ASIN(pos);
                break;
            }
            case 8: {
                this.ACOS(pos);
                break;
            }
            case 9: {
                this.ATAN(pos);
                break;
            }
            case 10: {
                this.ACTAN(pos);
                break;
            }
            case 11: {
                this.LN(pos);
                break;
            }
            case 12: {
                this.LOG2(pos);
                break;
            }
            case 13: {
                this.LOG10(pos);
                break;
            }
            case 14: {
                this.RAD(pos);
                break;
            }
            case 15: {
                this.EXP(pos);
                break;
            }
            case 16: {
                this.SQRT(pos);
                break;
            }
            case 17: {
                this.SINH(pos);
                break;
            }
            case 18: {
                this.COSH(pos);
                break;
            }
            case 19: {
                this.TANH(pos);
                break;
            }
            case 20: {
                this.COTH(pos);
                break;
            }
            case 21: {
                this.SECH(pos);
                break;
            }
            case 22: {
                this.CSCH(pos);
                break;
            }
            case 23: {
                this.DEG(pos);
                break;
            }
            case 24: {
                this.ABS(pos);
                break;
            }
            case 25: {
                this.SGN(pos);
                break;
            }
            case 26: {
                this.FLOOR(pos);
                break;
            }
            case 27: {
                this.CEIL(pos);
                break;
            }
            case 29: {
                this.NOT(pos);
                break;
            }
            case 30: {
                this.ARSINH(pos);
                break;
            }
            case 31: {
                this.ARCOSH(pos);
                break;
            }
            case 32: {
                this.ARTANH(pos);
                break;
            }
            case 33: {
                this.ARCOTH(pos);
                break;
            }
            case 34: {
                this.ARSECH(pos);
                break;
            }
            case 35: {
                this.ARCSCH(pos);
                break;
            }
            case 36: {
                this.SA(pos);
                break;
            }
            case 37: {
                this.SINC(pos);
                break;
            }
            case 38: {
                this.BELL_NUMBER(pos);
                break;
            }
            case 39: {
                this.LUCAS_NUMBER(pos);
                break;
            }
            case 40: {
                this.FIBONACCI_NUMBER(pos);
                break;
            }
            case 41: {
                this.HARMONIC_NUMBER(pos);
                break;
            }
            case 42: {
                this.IS_PRIME(pos);
                break;
            }
            case 43: {
                this.PRIME_COUNT(pos);
                break;
            }
            case 44: {
                this.EXP_INT(pos);
                break;
            }
            case 45: {
                this.LOG_INT(pos);
                break;
            }
            case 46: {
                this.OFF_LOG_INT(pos);
                break;
            }
            case 47: {
                this.GAUSS_ERF(pos);
                break;
            }
            case 48: {
                this.GAUSS_ERFC(pos);
                break;
            }
            case 49: {
                this.GAUSS_ERF_INV(pos);
                break;
            }
            case 50: {
                this.GAUSS_ERFC_INV(pos);
                break;
            }
            case 51: {
                this.ULP(pos);
                break;
            }
            case 52: {
                this.ISNAN(pos);
                break;
            }
            case 53: {
                this.NDIG10(pos);
                break;
            }
            case 54: {
                this.NFACT(pos);
                break;
            }
            case 55: {
                this.ARCSEC(pos);
                break;
            }
            case 56: {
                this.ARCCSC(pos);
                break;
            }
            case 57: {
                this.GAMMA(pos);
                break;
            }
            case 58: {
                this.LAMBERT_W0(pos);
                break;
            }
            case 59: {
                this.LAMBERT_W1(pos);
                break;
            }
            case 60: {
                this.SGN_GAMMA(pos);
                break;
            }
            case 61: {
                this.LOG_GAMMA(pos);
                break;
            }
            case 62: {
                this.DI_GAMMA(pos);
                break;
            }
            case 63: {
                this.UDF_PARAM(pos);
                break;
            }
            case 64: {
                this.RND_STUDENT_T(pos);
                break;
            }
            case 65: {
                this.RND_CHI2(pos);
            }
        }
    }

    private void f2ArgCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.f2ArgCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.LOG(pos);
                break;
            }
            case 2: {
                this.MOD(pos);
                break;
            }
            case 3: {
                this.BINOM_COEFF(pos);
                break;
            }
            case 4: {
                this.BERNOULLI_NUMBER(pos);
                break;
            }
            case 5: {
                this.STIRLING1_NUMBER(pos);
                break;
            }
            case 6: {
                this.STIRLING2_NUMBER(pos);
                break;
            }
            case 7: {
                this.WORPITZKY_NUMBER(pos);
                break;
            }
            case 8: {
                this.EULER_NUMBER(pos);
                break;
            }
            case 9: {
                this.KRONECKER_DELTA(pos);
                break;
            }
            case 10: {
                this.EULER_POLYNOMIAL(pos);
                break;
            }
            case 11: {
                this.HARMONIC2_NUMBER(pos);
                break;
            }
            case 12: {
                this.RND_VAR_UNIFORM_CONT(pos);
                break;
            }
            case 13: {
                this.RND_VAR_UNIFORM_DISCR(pos);
                break;
            }
            case 14: {
                this.ROUND(pos);
                break;
            }
            case 15: {
                this.RND_NORMAL(pos);
                break;
            }
            case 16: {
                this.NDIG(pos);
                break;
            }
            case 17: {
                this.DIGIT10(pos);
                break;
            }
            case 18: {
                this.FACTVAL(pos);
                break;
            }
            case 19: {
                this.FACTEXP(pos);
                break;
            }
            case 20: {
                this.ROOT(pos);
                break;
            }
            case 21: {
                this.INC_GAMMA_LOWER(pos);
                break;
            }
            case 22: {
                this.INC_GAMMA_UPPER(pos);
                break;
            }
            case 23: {
                this.REG_GAMMA_LOWER(pos);
                break;
            }
            case 24: {
                this.REG_GAMMA_UPPER(pos);
                break;
            }
            case 25: {
                this.PERMUTATIONS(pos);
                break;
            }
            case 26: {
                this.BETA(pos);
                break;
            }
            case 27: {
                this.LOG_BETA(pos);
                break;
            }
            case 28: {
                this.PDF_STUDENT_T(pos);
                break;
            }
            case 29: {
                this.CDF_STUDENT_T(pos);
                break;
            }
            case 30: {
                this.QNT_STUDENT_T(pos);
                break;
            }
            case 31: {
                this.PDF_CHI2(pos);
                break;
            }
            case 32: {
                this.CDF_CHI2(pos);
                break;
            }
            case 33: {
                this.QNT_CHI2(pos);
                break;
            }
            case 34: {
                this.RND_F_SNEDECOR(pos);
            }
        }
    }

    private void f3ArgCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.f3ArgCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 2: {
                this.IF(pos);
                break;
            }
            case 3: {
                this.CHI(pos);
                break;
            }
            case 4: {
                this.CHI_LR(pos);
                break;
            }
            case 5: {
                this.CHI_L(pos);
                break;
            }
            case 6: {
                this.CHI_R(pos);
                break;
            }
            case 7: {
                this.PDF_UNIFORM_CONT(pos);
                break;
            }
            case 8: {
                this.CDF_UNIFORM_CONT(pos);
                break;
            }
            case 9: {
                this.QNT_UNIFORM_CONT(pos);
                break;
            }
            case 10: {
                this.PDF_NORMAL(pos);
                break;
            }
            case 11: {
                this.CDF_NORMAL(pos);
                break;
            }
            case 12: {
                this.QNT_NORMAL(pos);
                break;
            }
            case 13: {
                this.DIGIT(pos);
                break;
            }
            case 14: {
                this.INC_BETA(pos);
                break;
            }
            case 15: {
                this.REG_BETA(pos);
                break;
            }
            case 16: {
                this.PDF_F_SNEDECOR(pos);
                break;
            }
            case 17: {
                this.CDF_F_SNEDECOR(pos);
                break;
            }
            case 18: {
                this.QNT_F_SNEDECOR(pos);
            }
        }
    }

    private void variadicFunCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.variadicFunCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.IFF(pos);
                break;
            }
            case 2: {
                this.MIN_VARIADIC(pos);
                break;
            }
            case 3: {
                this.MAX_VARIADIC(pos);
                break;
            }
            case 8: {
                this.SUM_VARIADIC(pos);
                break;
            }
            case 9: {
                this.PROD_VARIADIC(pos);
                break;
            }
            case 10: {
                this.AVG_VARIADIC(pos);
                break;
            }
            case 11: {
                this.VAR_VARIADIC(pos);
                break;
            }
            case 12: {
                this.STD_VARIADIC(pos);
                break;
            }
            case 4: {
                this.CONTINUED_FRACTION(pos);
                break;
            }
            case 5: {
                this.CONTINUED_POLYNOMIAL(pos);
                break;
            }
            case 6: {
                this.GCD(pos);
                break;
            }
            case 7: {
                this.LCM(pos);
                break;
            }
            case 13: {
                this.RND_LIST(pos);
                break;
            }
            case 14: {
                this.COALESCE(pos);
                break;
            }
            case 15: {
                this.OR_VARIADIC(pos);
                break;
            }
            case 16: {
                this.AND_VARIADIC(pos);
                break;
            }
            case 17: {
                this.XOR_VARIADIC(pos);
                break;
            }
            case 18: {
                this.ARGMIN_VARIADIC(pos);
                break;
            }
            case 19: {
                this.ARGMAX_VARIADIC(pos);
                break;
            }
            case 20: {
                this.MEDIAN_VARIADIC(pos);
                break;
            }
            case 21: {
                this.MODE_VARIADIC(pos);
                break;
            }
            case 22: {
                this.BASE_VARIADIC(pos);
                break;
            }
            case 23: {
                this.NDIST_VARIADIC(pos);
            }
        }
    }

    private void calculusCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.calculusCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.SUM(pos);
                break;
            }
            case 3: {
                this.PROD(pos);
                break;
            }
            case 15: {
                this.MIN(pos);
                break;
            }
            case 16: {
                this.MAX(pos);
                break;
            }
            case 12: {
                this.AVG(pos);
                break;
            }
            case 13: {
                this.VAR(pos);
                break;
            }
            case 14: {
                this.STD(pos);
                break;
            }
            case 5: {
                this.INTEGRAL(pos);
                break;
            }
            case 17: {
                this.SOLVE(pos);
                break;
            }
            case 6: {
                this.DERIVATIVE(pos, 3);
                break;
            }
            case 7: {
                this.DERIVATIVE(pos, 1);
                break;
            }
            case 8: {
                this.DERIVATIVE(pos, 2);
                break;
            }
            case 9: {
                this.DERIVATIVE_NTH(pos, 3);
                break;
            }
            case 10: {
                this.FORWARD_DIFFERENCE(pos);
                break;
            }
            case 11: {
                this.BACKWARD_DIFFERENCE(pos);
            }
        }
    }

    private void rootOperCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.rootOperCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 10: {
                this.SQUARE_ROOT_OPERATOR(pos);
                break;
            }
            case 11: {
                this.CUBE_ROOT_OPERATOR(pos);
                break;
            }
            case 12: {
                this.FOURTH_ROOT_OPERATOR(pos);
            }
        }
    }

    private void bolCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.bolCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.AND(pos);
                break;
            }
            case 7: {
                this.CIMP(pos);
                break;
            }
            case 9: {
                this.CNIMP(pos);
                break;
            }
            case 10: {
                this.EQV(pos);
                break;
            }
            case 6: {
                this.IMP(pos);
                break;
            }
            case 2: {
                this.NAND(pos);
                break;
            }
            case 8: {
                this.NIMP(pos);
                break;
            }
            case 4: {
                this.NOR(pos);
                break;
            }
            case 3: {
                this.OR(pos);
                break;
            }
            case 5: {
                this.XOR(pos);
            }
        }
    }

    private void bitwiseCalc(int pos) {
        if (!this.isFullyCompiled) {
            this.registerCompiledElement(CompiledElement.ToCall.bitwiseCalc, pos);
        }
        switch (this.tokensList.get((int)pos).tokenId) {
            case 2: {
                this.BITWISE_AND(pos);
                break;
            }
            case 4: {
                this.BITWISE_OR(pos);
                break;
            }
            case 3: {
                this.BITWISE_XOR(pos);
                break;
            }
            case 7: {
                this.BITWISE_NAND(pos);
                break;
            }
            case 8: {
                this.BITWISE_NOR(pos);
                break;
            }
            case 9: {
                this.BITWISE_XNOR(pos);
                break;
            }
            case 5: {
                this.BITWISE_LEFT_SHIFT(pos);
                break;
            }
            case 6: {
                this.BITWISE_RIGHT_SHIFT(pos);
            }
        }
    }

    private void initParserKeyWords() {
        this.keyWordsList = new ArrayList<KeyWord>();
        ExpressionUtils.addParserKeyWords(this.parserKeyWordsOnly, this.UDFExpression, this.unicodeKeyWordsEnabled, this.keyWordsList);
        this.modifyParserKeyWords();
        this.validateParserKeyWords();
        this.addUserDefinedKeyWords();
    }

    private void modifyParserKeyWords() {
        boolean toModify;
        boolean toRemove = !mXparser.tokensToRemove.isEmpty();
        boolean bl = toModify = !mXparser.tokensToModify.isEmpty();
        if (!toRemove && !toModify) {
            return;
        }
        ArrayList<KeyWord> keyWordsToRemove = new ArrayList<KeyWord>();
        for (int i = 0; i < this.keyWordsList.size(); ++i) {
            KeyWord kw = this.keyWordsList.get(i);
            if (kw.wordTypeId != 4 && kw.wordTypeId != 5 && kw.wordTypeId != 6 && kw.wordTypeId != 7 && kw.wordTypeId != 8 && kw.wordTypeId != 9 && kw.wordTypeId != 10 && kw.wordTypeId != 12) continue;
            if (toRemove && mXparser.tokensToRemove.contains(kw.wordString)) {
                keyWordsToRemove.add(kw);
            }
            if (!toModify) continue;
            for (TokenModification tm : mXparser.tokensToModify) {
                if (!tm.currentToken.equals(kw.wordString)) continue;
                String wordString = tm.newToken;
                String wordDescription = kw.description;
                if (tm.newTokenDescription != null) {
                    wordDescription = tm.newTokenDescription;
                }
                String wordSyntax = kw.syntax.replace(tm.currentToken, tm.newToken);
                KeyWord newKw = new KeyWord(wordString, wordDescription, kw.wordId, wordSyntax, kw.since, kw.wordTypeId);
                this.keyWordsList.set(i, newKw);
            }
        }
        if (toRemove && !keyWordsToRemove.isEmpty()) {
            for (KeyWord kw : keyWordsToRemove) {
                this.keyWordsList.remove(kw);
            }
        }
    }

    private void validateParserKeyWords() {
        if (!mXparser.overrideBuiltinTokens) {
            return;
        }
        ArrayList<String> userDefinedTokens = new ArrayList<String>();
        for (Argument arg : this.argumentsList) {
            userDefinedTokens.add(arg.getArgumentName());
        }
        for (Function fun : this.functionsList) {
            userDefinedTokens.add(fun.getFunctionName());
        }
        for (Constant cons : this.constantsList) {
            userDefinedTokens.add(cons.getConstantName());
        }
        if (userDefinedTokens.isEmpty()) {
            return;
        }
        ArrayList<KeyWord> keyWordsToOverride = new ArrayList<KeyWord>();
        for (KeyWord kw : this.keyWordsList) {
            if (!userDefinedTokens.contains(kw.wordString)) continue;
            keyWordsToOverride.add(kw);
        }
        if (keyWordsToOverride.isEmpty()) {
            return;
        }
        for (KeyWord kw : keyWordsToOverride) {
            this.keyWordsList.remove(kw);
        }
    }

    private boolean checkArgumentNameInCalculusOperator(Token token) {
        if (this.neverParseForImpliedMultiplication.contains(token.tokenStr)) {
            this.initialTokens.add(token);
            return true;
        }
        int initialTokensSize = this.initialTokens.size();
        if (initialTokensSize < 2) {
            return false;
        }
        boolean argumentNameFound = false;
        if (initialTokensSize >= 2) {
            Token tokenMinus2 = this.initialTokens.get(initialTokensSize - 2);
            if (tokenMinus2.tokenTypeId == 8) {
                switch (tokenMinus2.tokenId) {
                    case 1: 
                    case 3: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        argumentNameFound = true;
                    }
                }
            }
        }
        if (initialTokensSize >= 4 && !argumentNameFound) {
            Token tokenMinus4 = this.initialTokens.get(initialTokensSize - 4);
            if (tokenMinus4.tokenTypeId == 8) {
                switch (tokenMinus4.tokenId) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 17: {
                        argumentNameFound = true;
                    }
                }
            }
        }
        if (argumentNameFound) {
            this.initialTokens.add(token);
            this.neverParseForImpliedMultiplication.add(token.tokenStr);
        }
        return argumentNameFound;
    }

    private boolean checkSpecialConstantName(Token token) {
        int tokenStrLenght = token.tokenStr.length();
        if (tokenStrLenght < 2) {
            return false;
        }
        if (token.tokenStr.charAt(0) != '[') {
            return false;
        }
        if (token.tokenStr.charAt(tokenStrLenght - 1) != ']') {
            return false;
        }
        this.initialTokensAdd(token);
        return true;
    }

    private boolean checkOtherNumberBases(Token token) {
        int numeralSystemBase;
        int dotPos = 0;
        int tokenStrLength = token.tokenStr.length();
        if (tokenStrLength >= 2 && token.tokenStr.charAt(1) == '.') {
            dotPos = 1;
        }
        if (dotPos == 0 && tokenStrLength >= 3 && token.tokenStr.charAt(2) == '.') {
            dotPos = 2;
        }
        if (dotPos == 0 && tokenStrLength >= 4 && token.tokenStr.charAt(3) == '.') {
            dotPos = 3;
        }
        if (dotPos == 0) {
            return false;
        }
        String baseInd = token.tokenStr.substring(0, dotPos).toLowerCase();
        String numberLiteral = "";
        if (tokenStrLength > dotPos + 1) {
            numberLiteral = token.tokenStr.substring(dotPos + 1);
        }
        if ((numeralSystemBase = ExpressionUtils.getNumeralSystemBaseFromBaseInd(baseInd)) > 0 && numeralSystemBase <= 36) {
            double tokenValue = NumberTheory.convOthBase2Decimal(numberLiteral, numeralSystemBase);
            if (Double.isNaN(tokenValue)) {
                return false;
            }
            token.tokenTypeId = 0;
            token.tokenId = 1;
            token.tokenValue = tokenValue;
            this.initialTokensAdd(token);
            return true;
        }
        return false;
    }

    private void addFractionToken(Token token) {
        double fractionValue;
        boolean mixedFraction;
        int underscore1stPos = token.tokenStr.indexOf(95);
        int underscore2ndPos = token.tokenStr.indexOf(95, underscore1stPos + 1);
        boolean bl = mixedFraction = underscore2ndPos > 0;
        if (mixedFraction) {
            String wholeStr = token.tokenStr.substring(0, underscore1stPos);
            String numeratorStr = token.tokenStr.substring(underscore1stPos + 1, underscore2ndPos);
            String denominatorStr = token.tokenStr.substring(underscore2ndPos + 1);
            double whole = Double.parseDouble(wholeStr);
            double numerator = Double.parseDouble(numeratorStr);
            double denominator = Double.parseDouble(denominatorStr);
            fractionValue = denominator == 0.0 ? Double.NaN : whole + numerator / denominator;
        } else {
            String numeratorStr = token.tokenStr.substring(0, underscore1stPos);
            String denominatorStr = token.tokenStr.substring(underscore1stPos + 1);
            double numerator = Double.parseDouble(numeratorStr);
            double denominator = Double.parseDouble(denominatorStr);
            fractionValue = denominator == 0.0 ? Double.NaN : numerator / denominator;
        }
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.tokenValue = fractionValue;
        this.initialTokensAdd(token);
    }

    private boolean checkFraction(Token token) {
        if (token.tokenStr.length() < 3) {
            return false;
        }
        if (!StringUtils.regexMatch(token.tokenStr, "([0-9]([0-9])*_)?[0-9]([0-9])*_[0-9]([0-9])*")) {
            return false;
        }
        this.addFractionToken(token);
        return true;
    }

    private void initialTokensAdd(Token token) {
        if (this.initialTokens.isEmpty()) {
            this.initialTokens.add(token);
            return;
        }
        Token precedingToken = this.initialTokens.get(this.initialTokens.size() - 1);
        if (token.isSpecialTokenName()) {
            if (!(precedingToken.isLeftParenthesis() || precedingToken.isBinaryOperator() || precedingToken.isParameterSeparator() || precedingToken.isUnaryLeftOperator())) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
        } else if (precedingToken.isSpecialTokenName()) {
            if (!(token.isRightParenthesis() || token.isBinaryOperator() || token.isParameterSeparator() || token.isUnaryRightOperator())) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
        } else if (token.isLeftParenthesis()) {
            if (precedingToken.isRightParenthesis()) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
            if (precedingToken.isNumber()) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
            if (precedingToken.isIdentifier()) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
        } else if (precedingToken.isRightParenthesis()) {
            if (token.isNumber()) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
            if (!(token.isParameterSeparator() || token.isBinaryOperator() || token.isUnaryRightOperator() || token.isRightParenthesis())) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
        } else if (token.isUnicodeRootOperator()) {
            if (!(precedingToken.isLeftParenthesis() || precedingToken.isBinaryOperator() || precedingToken.isParameterSeparator() || precedingToken.isUnaryLeftOperator())) {
                if (this.impliedMultiplicationMode) {
                    this.initialTokens.add(Token.makeMultiplyToken());
                    this.initialTokens.add(token);
                    return;
                }
                this.impliedMultiplicationError = true;
            }
        } else if (!(token.isLeftParenthesis() || token.isRightParenthesis() || token.isBinaryOperator() || token.isParameterSeparator() || token.isUnaryRightOperator() || precedingToken.isLeftParenthesis() || precedingToken.isRightParenthesis() || precedingToken.isBinaryOperator() || precedingToken.isParameterSeparator() || precedingToken.isUnaryLeftOperator())) {
            if (this.impliedMultiplicationMode) {
                this.initialTokens.add(Token.makeMultiplyToken());
                this.initialTokens.add(token);
                return;
            }
            this.impliedMultiplicationError = true;
        }
        this.initialTokens.add(token);
    }

    private void assignKnownKeyword(Token token, KeyWord keyWord) {
        token.tokenTypeId = keyWord.wordTypeId;
        token.tokenId = keyWord.wordId;
        if (token.tokenTypeId == 101) {
            token.tokenValue = this.argumentsList.get((int)token.tokenId).argumentValue;
        }
    }

    private KeyWord tryFindKnownKeyword(String tokenStr) {
        for (KeyWord kw : this.keyWordsList) {
            if (!kw.wordString.equals(tokenStr)) continue;
            return kw;
        }
        return new KeyWord();
    }

    private boolean tryAssignKnownKeyword(Token token) {
        KeyWord keyWord = this.tryFindKnownKeyword(token.tokenStr);
        if (keyWord.wordTypeId != -1) {
            this.assignKnownKeyword(token, keyWord);
            return true;
        }
        return false;
    }

    private void initialTokensAddTokenPart(TokenPart tokenPart) {
        Token token = new Token();
        token.tokenStr = tokenPart.str;
        switch (tokenPart.type) {
            case 1: 
            case 2: {
                token.tokenValue = Double.valueOf(token.tokenStr);
                token.tokenTypeId = 0;
                token.tokenId = 1;
                this.initialTokensAdd(token);
                break;
            }
            case 3: {
                this.addFractionToken(token);
                break;
            }
            case 4: {
                this.checkOtherNumberBases(token);
                break;
            }
            case 5: {
                this.assignKnownKeyword(token, tokenPart.keyWord);
                this.initialTokensAdd(token);
                break;
            }
            case 6: {
                this.initialTokensAdd(token);
            }
        }
    }

    private boolean checkNumberNameManyImpliedMultiplication(Token token, boolean parenthesisIsOnTheRight) {
        boolean foundNameFolloweByInteger;
        int tokenStrLength = token.tokenStr.length();
        if (tokenStrLength < 2) {
            return false;
        }
        String substr = "";
        int lPos = 0;
        int lastConsumedPos = -1;
        ArrayList<TokenPart> tokenParts = new ArrayList<TokenPart>();
        TokenPart tokenPart = null;
        do {
            int rPos;
            boolean canStartDecimal = false;
            boolean canStartOtherNumberBase = false;
            char c = token.tokenStr.charAt(lPos);
            boolean isDigit = StringUtils.is0To9Digit(c);
            if (isDigit || c == '.' || c == '+' || c == '-') {
                canStartDecimal = true;
            }
            boolean canStartFraction = isDigit;
            if (c == 'b' || c == 'B' || c == 'o' || c == 'O' || c == 'h' || c == 'H') {
                canStartOtherNumberBase = true;
            }
            boolean canStartKeyword = !canStartDecimal;
            boolean decimalFound = false;
            boolean otherNumberBaseFound = false;
            boolean fractionFound = false;
            boolean keywordFound = false;
            KeyWord parserKeyword = null;
            for (rPos = tokenStrLength; rPos > lPos; --rPos) {
                substr = token.tokenStr.substring(lPos, rPos);
                if (canStartDecimal && (decimalFound = StringUtils.regexMatch(substr, "[+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?")) || canStartFraction && (fractionFound = StringUtils.regexMatch(substr, "([0-9]([0-9])*_)?[0-9]([0-9])*_[0-9]([0-9])*")) || canStartOtherNumberBase && (otherNumberBaseFound = StringUtils.regexMatch(substr, "([+-]?[bB]1\\.(1)*|[+-]?[bB][2]?\\.[01]([01])*|[+-]?[bB]3\\.[0-2]([0-2])*|[+-]?[bB]4\\.[0-3]([0-3])*|[+-]?[bB]5\\.[0-4]([0-4])*|[+-]?[bB]6\\.[0-5]([0-5])*|[+-]?[bB]7\\.[0-6]([0-6])*|[+-]?([bB]8|[oO])\\.[0-7]([0-7])*|[+-]?[bB]9\\.[0-8]([0-8])*|[+-]?[bB]10\\.[0-9]([0-9])*|[+-]?[bB]11\\.[0-9aA]([0-9aA])*|[+-]?[bB]12\\.[0-9a-bA-B]([0-9a-bA-B])*|[+-]?[bB]13\\.[0-9a-cA-C]([0-9a-cA-C])*|[+-]?[bB]14\\.[0-9a-dA-D]([0-9a-dA-D])*|[+-]?[bB]15\\.[0-9a-eA-E]([0-9a-eA-E])*|[+-]?([bB]16|[hH])\\.[0-9a-fA-F]([0-9a-fA-F])*|[+-]?[bB]17\\.[0-9a-gA-G]([0-9a-gA-G])*|[+-]?[bB]18\\.[0-9a-hA-H]([0-9a-hA-H])*|[+-]?[bB]19\\.[0-9a-iA-I]([0-9a-iA-I])*|[+-]?[bB]20\\.[0-9a-jA-J]([0-9a-jA-J])*|[+-]?[bB]21\\.[0-9a-kA-K]([0-9a-kA-K])*|[+-]?[bB]22\\.[0-9a-lA-L]([0-9a-lA-L])*|[+-]?[bB]23\\.[0-9a-mA-M]([0-9a-mA-M])*|[+-]?[bB]24\\.[0-9a-nA-N]([0-9a-nA-N])*|[+-]?[bB]25\\.[0-9a-oA-O]([0-9a-oA-O])*|[+-]?[bB]26\\.[0-9a-pA-P]([0-9a-pA-P])*|[+-]?[bB]27\\.[0-9a-qA-Q]([0-9a-qA-Q])*|[+-]?[bB]28\\.[0-9a-rA-R]([0-9a-rA-R])*|[+-]?[bB]29\\.[0-9a-sA-S]([0-9a-sA-S])*|[+-]?[bB]30\\.[0-9a-tA-T]([0-9a-tA-T])*|[+-]?[bB]31\\.[0-9a-uA-U]([0-9a-uA-U])*|[+-]?[bB]32\\.[0-9a-vA-V]([0-9a-vA-V])*|[+-]?[bB]33\\.[0-9a-wA-W]([0-9a-wA-W])*|[+-]?[bB]34\\.[0-9a-xA-X]([0-9a-xA-X])*|[+-]?[bB]35\\.[0-9a-yA-Y]([0-9a-yA-Y])*|[+-]?[bB]36\\.[0-9a-zA-Z]([0-9a-zA-Z])*)"))) break;
                if (!canStartKeyword) continue;
                KeyWord kw = this.tryFindKnownKeyword(substr);
                if (kw.wordTypeId != -1) {
                    if (KeyWord.isFunctionForm(kw) && (rPos != tokenStrLength || !parenthesisIsOnTheRight)) continue;
                    parserKeyword = kw;
                    keywordFound = true;
                    break;
                }
                if (!this.neverParseForImpliedMultiplication.contains(substr)) continue;
                keywordFound = true;
                parserKeyword = new KeyWord();
                break;
            }
            if (decimalFound || fractionFound || otherNumberBaseFound || keywordFound) {
                if (lPos - lastConsumedPos > 1) {
                    tokenPart = new TokenPart();
                    tokenPart.str = token.tokenStr.substring(lastConsumedPos + 1, lPos);
                    tokenPart.type = 6;
                    tokenParts.add(tokenPart);
                }
                tokenPart = new TokenPart();
                tokenPart.str = substr;
                if (decimalFound) {
                    tokenPart.type = StringUtils.regexMatch(tokenPart.str, "[0-9]([0-9])*") ? 1 : 2;
                }
                if (fractionFound) {
                    tokenPart.type = 3;
                }
                if (otherNumberBaseFound) {
                    tokenPart.type = 4;
                }
                if (keywordFound) {
                    tokenPart.type = 5;
                    tokenPart.keyWord = parserKeyword;
                }
                tokenParts.add(tokenPart);
                if (rPos > lPos) {
                    lastConsumedPos = rPos - 1;
                    lPos = rPos;
                    continue;
                }
                lastConsumedPos = tokenStrLength - 1;
                lPos = tokenStrLength;
                continue;
            }
            ++lPos;
        } while (lPos < tokenStrLength);
        if (lPos - lastConsumedPos > 1) {
            tokenPart = new TokenPart();
            tokenPart.str = token.tokenStr.substring(lastConsumedPos + 1, lPos);
            tokenPart.type = 6;
            tokenParts.add(tokenPart);
        }
        if (tokenParts.size() == 1) {
            this.initialTokensAddTokenPart((TokenPart)tokenParts.get(0));
            return true;
        }
        TokenPart partAtPos = null;
        TokenPart partAtPosPlus1 = null;
        do {
            int namePos;
            foundNameFolloweByInteger = false;
            for (namePos = 0; namePos < tokenParts.size() - 1; ++namePos) {
                partAtPos = (TokenPart)tokenParts.get(namePos);
                partAtPosPlus1 = (TokenPart)tokenParts.get(namePos + 1);
                if (partAtPos.type != 5 && partAtPos.type != 6 || partAtPosPlus1.type != 1) continue;
                foundNameFolloweByInteger = true;
                break;
            }
            if (!foundNameFolloweByInteger) continue;
            partAtPos.str = partAtPos.str + partAtPosPlus1.str;
            partAtPos.type = 6;
            partAtPos.keyWord = null;
            tokenParts.remove(namePos + 1);
        } while (foundNameFolloweByInteger);
        if (tokenParts.size() == 1) {
            this.initialTokensAddTokenPart((TokenPart)tokenParts.get(0));
            return true;
        }
        for (int i = 0; i < tokenParts.size(); ++i) {
            if (i > 0) {
                this.initialTokens.add(Token.makeMultiplyToken());
            }
            this.initialTokensAddTokenPart((TokenPart)tokenParts.get(i));
        }
        return true;
    }

    private void addToken(String tokenStr, KeyWord keyWord, boolean parenthesisIsOnTheRight) {
        Token token = new Token();
        token.tokenStr = tokenStr;
        token.keyWord = keyWord.wordString;
        token.tokenTypeId = keyWord.wordTypeId;
        token.tokenId = keyWord.wordId;
        if (token.tokenTypeId != -1) {
            this.initialTokensAdd(token);
        }
        if (token.tokenTypeId == 101) {
            token.tokenValue = this.argumentsList.get((int)token.tokenId).argumentValue;
        } else if (token.tokenTypeId == 0) {
            token.tokenValue = Double.parseDouble(token.tokenStr);
            token.keyWord = "_num_";
        } else if (token.tokenTypeId == -1) {
            boolean alternativeMatchFound = this.checkArgumentNameInCalculusOperator(token);
            if (!alternativeMatchFound) {
                alternativeMatchFound = this.checkSpecialConstantName(token);
            }
            if (!alternativeMatchFound) {
                alternativeMatchFound = this.checkOtherNumberBases(token);
            }
            if (!alternativeMatchFound) {
                alternativeMatchFound = this.checkFraction(token);
            }
            if (this.impliedMultiplicationMode && !alternativeMatchFound) {
                alternativeMatchFound = this.checkNumberNameManyImpliedMultiplication(token, parenthesisIsOnTheRight);
            }
            if (!alternativeMatchFound) {
                this.initialTokensAdd(token);
            }
        }
    }

    private void addToken(String tokenStr, KeyWord keyWord) {
        this.addToken(tokenStr, keyWord, false);
    }

    private void addUserDefinedKeyWords() {
        if (this.parserKeyWordsOnly) {
            return;
        }
        ExpressionUtils.addArgumentsKeyWords(this.argumentsList, this.keyWordsList);
        ExpressionUtils.addFunctionsKeyWords(this.functionsList, this.keyWordsList);
        ExpressionUtils.addConstantsKeyWords(this.constantsList, this.keyWordsList);
    }

    private void tokenizeExpressionString() {
        String newExpressionString;
        this.impliedMultiplicationError = false;
        this.initParserKeyWords();
        Collections.sort(this.keyWordsList, new DescKwLenComparator());
        int numberKwId = -1;
        int plusKwId = -1;
        int minusKwId = -1;
        for (int kwId = 0; kwId < this.keyWordsList.size(); ++kwId) {
            if (this.keyWordsList.get((int)kwId).wordTypeId == 0) {
                numberKwId = kwId;
            }
            if (this.keyWordsList.get((int)kwId).wordTypeId != 1) continue;
            if (this.keyWordsList.get((int)kwId).wordId == 1) {
                plusKwId = kwId;
            }
            if (this.keyWordsList.get((int)kwId).wordId != 2) continue;
            minusKwId = kwId;
        }
        this.initialTokens = new ArrayList<Token>();
        this.neverParseForImpliedMultiplication = new HashSet<String>();
        int expLen = this.expressionString.length();
        if (expLen == 0) {
            return;
        }
        if (!this.syntaxStatus || !this.syntaxStatus) {
            this.cleanExpressionString();
        }
        if ((newExpressionString = this.expressionStringCleaned).isEmpty()) {
            return;
        }
        int lastPos = 0;
        int pos = 0;
        String tokenStr = "";
        boolean matchFoundPrev = false;
        boolean matchFound = false;
        KeyWord kw = null;
        String sub = "";
        String kwStr = "";
        boolean specialConstFound = false;
        String specialConstStr = "";
        do {
            char followingChar;
            char precedingChar;
            char c;
            int numEnd = -1;
            char firstChar = newExpressionString.charAt(pos);
            if (firstChar == '+' || firstChar == '-' || firstChar == '.' || StringUtils.is0To9Digit(firstChar)) {
                for (int i = pos; i < newExpressionString.length() && (i <= pos || (c = newExpressionString.charAt(i)) == '+' || c == '-' || StringUtils.is0To9Digit(c) || c == '.' || c == 'e' || c == 'E'); ++i) {
                    String str = newExpressionString.substring(pos, i + 1);
                    if (!StringUtils.regexMatch(str, "[+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?")) continue;
                    numEnd = i;
                }
            }
            if (numEnd >= 0 && pos > 0 && !StringUtils.canBeSeparatingChar(precedingChar = newExpressionString.charAt(pos - 1))) {
                numEnd = -1;
            }
            if (numEnd >= 0 && numEnd < newExpressionString.length() - 1 && !StringUtils.canBeSeparatingChar(followingChar = newExpressionString.charAt(numEnd + 1))) {
                numEnd = -1;
            }
            if (numEnd >= 0) {
                if (!matchFoundPrev && pos > 0) {
                    tokenStr = newExpressionString.substring(lastPos, pos);
                    this.addToken(tokenStr, new KeyWord(), StringUtils.charIsLeftParenthesis(newExpressionString, pos));
                }
                firstChar = newExpressionString.charAt(pos);
                boolean leadingOp = true;
                if (firstChar == '-' || firstChar == '+') {
                    if (!this.initialTokens.isEmpty()) {
                        Token lastToken = this.initialTokens.get(this.initialTokens.size() - 1);
                        leadingOp = !(lastToken.tokenTypeId == 1 && lastToken.tokenId != 6 && lastToken.tokenId != 8 || lastToken.tokenTypeId == 3 || lastToken.tokenTypeId == 2 || lastToken.tokenTypeId == 11 || lastToken.tokenTypeId == 20 && lastToken.tokenId == 1);
                    } else {
                        leadingOp = false;
                    }
                } else {
                    leadingOp = false;
                }
                if (leadingOp) {
                    if (firstChar == '-') {
                        this.addToken("-", this.keyWordsList.get(minusKwId));
                    }
                    if (firstChar == '+') {
                        this.addToken("+", this.keyWordsList.get(plusKwId));
                    }
                    ++pos;
                }
                tokenStr = newExpressionString.substring(pos, numEnd + 1);
                this.addToken(tokenStr, this.keyWordsList.get(numberKwId));
                lastPos = pos = numEnd + 1;
                matchFound = true;
                matchFoundPrev = true;
                continue;
            }
            int kwId = -1;
            matchFound = false;
            firstChar = newExpressionString.charAt(pos);
            do {
                kw = this.keyWordsList.get(++kwId);
                kwStr = kw.wordString;
                if (pos + kwStr.length() > newExpressionString.length()) continue;
                sub = newExpressionString.substring(pos, pos + kwStr.length());
                if (sub.equals(kwStr)) {
                    matchFound = true;
                }
                if (!matchFound || firstChar == '[' || kw.wordTypeId != 101 && kw.wordTypeId != 102 && kw.wordTypeId != 4 && kw.wordTypeId != 5 && kw.wordTypeId != 6 && kw.wordTypeId != 7 && kw.wordTypeId != 9 && kw.wordTypeId != 104 && kw.wordTypeId != 10 && kw.wordTypeId != 12 && kw.wordTypeId != 103 && kw.wordTypeId != 8) continue;
                if (pos > 0 && !StringUtils.canBeSeparatingChar(precedingChar = newExpressionString.charAt(pos - 1))) {
                    matchFound = false;
                }
                if (!matchFound || pos + kwStr.length() >= newExpressionString.length() || StringUtils.canBeSeparatingChar(followingChar = newExpressionString.charAt(pos + kwStr.length()))) continue;
                matchFound = false;
            } while (kwId < this.keyWordsList.size() - 1 && !matchFound);
            specialConstFound = false;
            if (!matchFound && firstChar == '[') {
                for (int i = pos + 1; i < newExpressionString.length(); ++i) {
                    c = newExpressionString.charAt(i);
                    if (c != ']') continue;
                    specialConstFound = true;
                    specialConstStr = newExpressionString.substring(pos, i + 1);
                    break;
                }
            }
            if (matchFound || specialConstFound) {
                if (!matchFoundPrev && pos > 0) {
                    tokenStr = newExpressionString.substring(lastPos, pos);
                    this.addToken(tokenStr, new KeyWord(), StringUtils.charIsLeftParenthesis(newExpressionString, pos));
                }
                matchFoundPrev = true;
                if (matchFound) {
                    tokenStr = newExpressionString.substring(pos, pos + kwStr.length());
                    if (kw.wordTypeId != 20 || kw.wordId != 4) {
                        this.addToken(tokenStr, kw);
                    }
                } else {
                    tokenStr = specialConstStr;
                    this.addToken(tokenStr, new KeyWord());
                }
                lastPos = pos + tokenStr.length();
                pos += tokenStr.length();
                continue;
            }
            matchFoundPrev = false;
            if (pos >= newExpressionString.length()) continue;
            ++pos;
        } while (pos < newExpressionString.length());
        if (!matchFound) {
            tokenStr = newExpressionString.substring(lastPos, pos);
            this.addToken(tokenStr, new KeyWord(), StringUtils.charIsLeftParenthesis(newExpressionString, pos));
        }
        ExpressionUtils.evaluateTokensLevels(this.initialTokens);
    }

    private void copyInitialTokens() {
        boolean prepareInitialTokensListInfo = false;
        if (this.initialCompilationDetails == null) {
            this.initialCompilationDetails = new CompilationDetails();
            this.initialCompilationDetails.compiledElements = new ArrayList<CompiledElement>();
            prepareInitialTokensListInfo = true;
        }
        this.tokensList = new ArrayList<Token>();
        if (prepareInitialTokensListInfo) {
            for (Token token : this.initialTokens) {
                this.tokensList.add(token.clone());
                if (token.tokenTypeId == 8) {
                    this.initialCompilationDetails.containsCalculus = true;
                    continue;
                }
                if (token.tokenTypeId == 6 && token.tokenId == 1) {
                    this.initialCompilationDetails.containsIf = true;
                    continue;
                }
                if (token.tokenTypeId != 7 || token.tokenId != 1) continue;
                this.initialCompilationDetails.containsIf = true;
            }
        } else {
            for (Token token : this.initialTokens) {
                this.tokensList.add(token.clone());
            }
        }
        if (this.compilationDetails == null) {
            this.compilationDetails = new CompilationDetails();
        }
        this.compilationDetails.containsCalculus = this.initialCompilationDetails.containsCalculus;
        this.compilationDetails.containsIf = this.initialCompilationDetails.containsIf;
        this.compilationDetails.compiledElements = this.initialCompilationDetails.compiledElements;
    }

    public List<Token> getCopyOfInitialTokens() {
        this.tokenizeExpressionString();
        return ExpressionUtils.getCopyOfInitialTokens(this.expressionString, this.initialTokens);
    }

    public void consolePrintCopyOfInitialTokens() {
        mXparser.consolePrintTokens(this.getCopyOfInitialTokens());
    }

    public String[] getMissingUserDefinedArguments() {
        return ExpressionUtils.getMissingUserDefinedArguments(this.getCopyOfInitialTokens());
    }

    public String[] getMissingUserDefinedUnits() {
        return ExpressionUtils.getMissingUserDefinedUnits(this.getCopyOfInitialTokens());
    }

    public String[] getMissingUserDefinedFunctions() {
        return ExpressionUtils.getMissingUserDefinedFunctions(this.getCopyOfInitialTokens());
    }

    List<Token> getInitialTokens() {
        return this.initialTokens;
    }

    private void showParsing(int lPos, int rPos) {
        ExpressionUtils.showParsing(lPos, rPos, this.tokensList);
    }

    void showKeyWords() {
        ExpressionUtils.showKeyWords(this.keyWordsList);
    }

    public String getHelp() {
        return this.getHelp("");
    }

    public String getHelp(String query) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelp(query, this.keyWordsList);
    }

    public String getHelp(boolean addHeader, boolean addCaption, String caption) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelp("", this.keyWordsList, addHeader, addCaption, caption);
    }

    public String getHelp(String query, boolean addHeader, boolean addCaption, String caption) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelp(query, this.keyWordsList, addHeader, addCaption, caption);
    }

    public String getHelpAsCsv() {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsCsv(this.keyWordsList, "\"", ";", true, "");
    }

    public String getHelpAsCsv(String query) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsCsv(this.keyWordsList, "\"", ";", true, query);
    }

    public String getHelpAsCsv(String quote, String delimiter, boolean addHeader) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsCsv(this.keyWordsList, quote, delimiter, addHeader, "");
    }

    public String getHelpAsCsv(String query, String quote, String delimiter, boolean addHeader) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsCsv(this.keyWordsList, quote, delimiter, addHeader, query);
    }

    public String getHelpAsHtmlTable() {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsHtmlTable(this.keyWordsList, true, "");
    }

    public String getHelpAsHtmlTable(String query) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsHtmlTable(this.keyWordsList, true, query);
    }

    public String getHelpAsHtmlTable(boolean addHeader, boolean addCaption, boolean addFigure, String caption, String cssClass) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsHtmlTable(this.keyWordsList, addHeader, addCaption, addFigure, "", caption, cssClass);
    }

    public String getHelpAsHtmlTable(String query, boolean addHeader, boolean addCaption, boolean addFigure, String caption, String cssClass) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsHtmlTable(this.keyWordsList, addHeader, addCaption, addFigure, query, caption, cssClass);
    }

    public String getHelpAsMarkdownTable() {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsMarkdownTable(this.keyWordsList, "");
    }

    public String getHelpAsMarkdownTable(String query) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsMarkdownTable(this.keyWordsList, query);
    }

    public String getHelpAsMarkdownTable(boolean addHeader, boolean addCaption, String caption) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsMarkdownTable(this.keyWordsList, addHeader, addCaption, "", caption);
    }

    public String getHelpAsMarkdownTable(String query, boolean addHeader, boolean addCaption, String caption) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsMarkdownTable(this.keyWordsList, addHeader, addCaption, query, caption);
    }

    public String getHelpAsJson() {
        return this.getHelpAsJson("");
    }

    public String getHelpAsJson(String query) {
        return this.getHelpAsJson(query, true, "");
    }

    public String getHelpAsJson(boolean addCaption, String caption) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsJson(this.keyWordsList, addCaption, "", caption);
    }

    public String getHelpAsJson(String query, boolean addCaption, String caption) {
        this.initParserKeyWords();
        return ExpressionUtils.getHelpAsJson(this.keyWordsList, addCaption, query, caption);
    }

    public List<KeyWord> getKeyWords() {
        return this.getKeyWords("");
    }

    public List<KeyWord> getKeyWords(String query) {
        this.initParserKeyWords();
        return ExpressionUtils.getKeyWords(query, this.keyWordsList);
    }

    void showTokens() {
        Expression.showTokens(this.tokensList);
    }

    static void showTokens(List<Token> tokensList) {
        ExpressionUtils.showTokens(tokensList);
    }

    void showInitialTokens() {
        Expression.showTokens(this.initialTokens);
    }

    private void showArguments() {
        for (Argument a : this.argumentsList) {
            boolean vMode = a.getVerboseMode();
            a.setSilentMode();
            this.printSystemInfo(a.getArgumentName() + " = " + a.getArgumentValue() + StringInvariant.NEW_LINE, true);
            if (!vMode) continue;
            a.setVerboseMode();
        }
    }

    private void printSystemInfo(String info, boolean withExpressionString) {
        if (withExpressionString) {
            mXparser.consolePrint(StringUtils.surroundSquareBrackets(this.description) + StringUtils.surroundSquareBracketsAddSpace(this.expressionString) + info);
        } else {
            mXparser.consolePrint(info);
        }
    }

    protected Expression clone() {
        Expression newExp = new Expression(this, false, null);
        if (this.initialTokens != null && !this.initialTokens.isEmpty()) {
            newExp.initialTokens = Expression.createInitialTokens(0, this.initialTokens.size() - 1, this.initialTokens);
            newExp.initialCompilationDetails = this.initialCompilationDetails;
        }
        return newExp;
    }

    Expression cloneForThreadSafeInternal(CloneCache cloneCache) {
        Expression expressionClone = cloneCache.getExpressionClone(this);
        if (expressionClone == null) {
            cloneCache.cacheCloneInProgress(this);
            expressionClone = new Expression(this, true, cloneCache);
            if (this.initialTokens != null && !this.initialTokens.isEmpty()) {
                expressionClone.initialTokens = Expression.createInitialTokens(0, this.initialTokens.size() - 1, this.initialTokens);
                expressionClone.initialCompilationDetails = this.initialCompilationDetails;
            }
            cloneCache.clearCloneInProgress(this);
            cloneCache.cacheExpressionClone(this, expressionClone);
        }
        return expressionClone;
    }

    public Expression cloneForThreadSafe() {
        CloneCache cloneCache = new CloneCache();
        Expression expressionClone = this.cloneForThreadSafeInternal(cloneCache);
        cloneCache.addAllAtTheEndElements();
        cloneCache.clearCache();
        return expressionClone;
    }
}

