/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;

public final class BinaryRelations {
    public static final double DEFAULT_COMPARISON_EPSILON = 1.0E-14;
    static double epsilon = 1.0E-14;
    static boolean epsilonComparison = true;

    public static void setExactComparison() {
        epsilonComparison = false;
    }

    public static void setEpsilonComparison() {
        epsilonComparison = true;
    }

    public static void setEpsilon(double epsilon) {
        if (epsilon > 0.0) {
            BinaryRelations.epsilon = epsilon;
        }
    }

    public static void setDefaultEpsilon() {
        epsilon = 1.0E-14;
    }

    public static double getEpsilon() {
        return epsilon;
    }

    public static boolean checkIfEpsilonMode() {
        return epsilonComparison;
    }

    public static boolean checkIfExactMode() {
        return !epsilonComparison;
    }

    public static double eq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            eps = 0.0;
        }
        double result = 0.0;
        if (epsilonComparison) {
            if (MathFunctions.abs(a - b) <= eps) {
                result = 1.0;
            }
        } else if (a == b) {
            result = 1.0;
        }
        return result;
    }

    public static boolean isEqualOrAlmost(double a, double b) {
        return Math.abs(a - b) <= 1.0E-14;
    }

    public static double neq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            eps = 0.0;
        }
        double result = 0.0;
        if (epsilonComparison) {
            if (MathFunctions.abs(a - b) > eps) {
                result = 1.0;
            }
        } else if (a != b) {
            result = 1.0;
        }
        return result;
    }

    public static double lt(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            eps = 0.0;
        }
        double result = 0.0;
        if (epsilonComparison) {
            if (a < b - eps) {
                result = 1.0;
            }
        } else if (a < b) {
            result = 1.0;
        }
        return result;
    }

    public static double gt(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            eps = 0.0;
        }
        double result = 0.0;
        if (epsilonComparison) {
            if (a > b + eps) {
                result = 1.0;
            }
        } else if (a > b) {
            result = 1.0;
        }
        return result;
    }

    public static double leq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            eps = 0.0;
        }
        double result = 0.0;
        if (epsilonComparison) {
            if (a <= b + eps) {
                result = 1.0;
            }
        } else if (a <= b) {
            result = 1.0;
        }
        return result;
    }

    public static double geq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            eps = 0.0;
        }
        double result = 0.0;
        if (epsilonComparison) {
            if (a >= b - eps) {
                result = 1.0;
            }
        } else if (a >= b) {
            result = 1.0;
        }
        return result;
    }
}

