/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.ShortcutHandler;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.config.ConfigGui;
import com.cleanroommc.bogosorter.common.network.CSort;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.bogosorter.compat.screen.WarningScreen;
import com.cleanroommc.modularui.factory.ClientGUI;
import com.kbp.client.KBPMod;
import com.kbp.client.api.IPatchedKeyBinding;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static final List<ItemStack> allItems = new ArrayList<ItemStack>();
    public static final String BOGO_CATEGORY = "bogosort.key.categories";
    public static final String KEY_PREFIX = "bogosort.key.";
    public static final KeyBinding configGuiKey = new KeyBinding("bogosort.key.sort_config", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, 37, "bogosort.key.categories");
    public static final KeyBinding sortKey = new KeyBinding("bogosort.key.sort", (IKeyConflictContext)KeyConflictContext.GUI, -98, "bogosort.key.categories");
    public static final int LMB = 0;
    public static final int RMB = 1;
    public static final int WHEEL = 2;
    public static final int ALT = 56;
    public static final int CTRL = Minecraft.field_142025_a ? 219 : 29;
    public static final int SHIFT = 42;
    public static final int SPACE = 57;
    public static final IPatchedKeyBinding moveAllSame = KBPMod.newBuilder((String)"bogosort.key.move_all_same").withCategory("bogosort.key.categories").withMouseButton(0).withCmbKeys(new Integer[]{56}).withConflictContext((IKeyConflictContext)KeyConflictContext.GUI).buildAndRegis();
    public static final IPatchedKeyBinding moveAll = KBPMod.newBuilder((String)"bogosort.key.move_all").withCategory("bogosort.key.categories").withMouseButton(0).withCmbKeys(new Integer[]{57}).withConflictContext((IKeyConflictContext)KeyConflictContext.GUI).buildAndRegis();
    public static final IPatchedKeyBinding moveSingle = KBPMod.newBuilder((String)"bogosort.key.move_single").withCategory("bogosort.key.categories").withMouseButton(0).withCmbKeys(new Integer[]{CTRL}).withConflictContext((IKeyConflictContext)KeyConflictContext.GUI).buildAndRegis();
    public static final IPatchedKeyBinding moveSingleEmpty = KBPMod.newBuilder((String)"bogosort.key.move_single_empty").withCategory("bogosort.key.categories").withMouseButton(1).withCmbKeys(new Integer[]{CTRL}).withConflictContext((IKeyConflictContext)KeyConflictContext.GUI).buildAndRegis();
    public static final IPatchedKeyBinding throwAllSame = KBPMod.newBuilder((String)"bogosort.key.throw_all_same").withCategory("bogosort.key.categories").withKey(16).withCmbKeys(new Integer[]{56}).withConflictContext((IKeyConflictContext)KeyConflictContext.GUI).buildAndRegis();
    public static final IPatchedKeyBinding throwAll = KBPMod.newBuilder((String)"bogosort.key.throw_all").withCategory("bogosort.key.categories").withKey(16).withCmbKeys(new Integer[]{57}).withConflictContext((IKeyConflictContext)KeyConflictContext.GUI).buildAndRegis();
    private static long timeConfigGui = 0L;
    private static long timeSort = 0L;
    private static long timeShortcut = 0L;
    private static long ticks = 0L;
    private static GuiScreen nextGui = null;

    public static void openNextTick(GuiScreen screen) {
        nextGui = screen;
    }

    public static long getTicks() {
        return ticks;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++ticks;
        }
        if (nextGui != null) {
            ClientGUI.open((GuiScreen)nextGui);
            nextGui = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && !WarningScreen.wasOpened) {
            WarningScreen.wasOpened = true;
            ArrayList<String> warnings = new ArrayList<String>();
            if (Loader.isModLoaded((String)"inventorytweaks")) {
                warnings.add("InventoryTweaks is loaded. This will cause issues!");
                warnings.add("Consider removing the mod and reload the game.");
            }
            if (!warnings.isEmpty()) {
                warnings.add(0, TextFormatting.BOLD + "! Warning from Inventory Bogosorter !");
                warnings.add(1, "");
                event.setGui((GuiScreen)new WarningScreen(warnings));
            }
        }
    }

    private static void shortcutAction() {
        timeShortcut = Minecraft.func_71386_F();
    }

    private static boolean canDoShortcutAction() {
        return Minecraft.func_71386_F() - timeShortcut > 50L;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        ClientEventHandler.handleInput(null);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.MouseInputEvent event) {
        ClientEventHandler.handleInput(null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGuiKeyInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!(event.getGui() instanceof GuiContainer)) {
            return;
        }
        if (ClientEventHandler.handleInput((GuiContainer)event.getGui())) {
            event.setCanceled(true);
            return;
        }
        if (FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            if (Keyboard.isKeyDown((int)79)) {
                ISlot slot = ClientEventHandler.getSlot(event.getGui());
                SortHandler sortHandler = ClientEventHandler.createSortHandler(event.getGui(), slot);
                if (sortHandler == null) {
                    return;
                }
                sortHandler.clearAllItems(slot);
                return;
            }
            if (Keyboard.isKeyDown((int)80)) {
                if (allItems.isEmpty()) {
                    for (Item item : ForgeRegistries.ITEMS) {
                        NonNullList subItems = NonNullList.func_191196_a();
                        item.func_150895_a(CreativeTabs.field_78027_g, subItems);
                        allItems.addAll((Collection<ItemStack>)subItems);
                    }
                }
                ISlot slot = ClientEventHandler.getSlot(event.getGui());
                SortHandler sortHandler = ClientEventHandler.createSortHandler(event.getGui(), slot);
                if (sortHandler == null) {
                    return;
                }
                sortHandler.randomizeItems(slot);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (event.getGui() instanceof GuiContainer && ClientEventHandler.handleInput((GuiContainer)event.getGui())) {
            event.setCanceled(true);
        }
    }

    public static boolean handleInput(@Nullable GuiContainer container) {
        long t;
        if (container != null && container.func_193976_p()) {
            return false;
        }
        if (container != null && ClientEventHandler.canDoShortcutAction()) {
            if (moveAll.getKeyBinding().func_151468_f() && ShortcutHandler.moveAllItems(container, false)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (moveAllSame.getKeyBinding().func_151468_f() && ShortcutHandler.moveAllItems(container, true)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (moveSingle.getKeyBinding().func_151468_f() && ShortcutHandler.moveSingleItem(container, false)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (moveSingleEmpty.getKeyBinding().func_151468_f() && ShortcutHandler.moveSingleItem(container, true)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (throwAll.getKeyBinding().func_151468_f() && ShortcutHandler.dropItems(container, false)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (throwAllSame.getKeyBinding().func_151468_f() && ShortcutHandler.dropItems(container, true)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
        }
        boolean c = configGuiKey.func_151468_f();
        boolean s = sortKey.func_151468_f();
        if (c && (t = Minecraft.func_71386_F()) - timeConfigGui > 500L) {
            if (!ConfigGui.closeCurrent()) {
                BogoSortAPI.INSTANCE.openConfigGui(Minecraft.func_71410_x().field_71462_r);
            }
            timeConfigGui = t;
            return true;
        }
        if (container != null && s && (t = Minecraft.func_71386_F()) - timeSort > 500L) {
            ISlot slot = ClientEventHandler.getSlot((GuiScreen)container);
            if (!ClientEventHandler.canSort(slot) || !ClientEventHandler.sort((GuiScreen)container, slot)) {
                return false;
            }
            timeSort = t;
            return true;
        }
        return false;
    }

    private static boolean canSort(@Nullable ISlot slot) {
        return !Minecraft.func_71410_x().field_71439_g.func_184812_l_() || sortKey.getKeyModifier().isActive(null) != Minecraft.func_71410_x().field_71474_y.field_74322_I.getKeyModifier().isActive(null) || sortKey.func_151463_i() != Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() || Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b() && (slot == null || slot.bogo$getStack().func_190926_b());
    }

    private static boolean isButtonPressed(int button) {
        return Mouse.getEventButtonState() && Mouse.getEventButton() == button;
    }

    private static boolean isKeyDown(KeyBinding key) {
        if (!key.getKeyModifier().isActive(null)) {
            return false;
        }
        if (key.func_151463_i() < 0) {
            return ClientEventHandler.isButtonPressed(key.func_151463_i() + 100);
        }
        return Keyboard.getEventKeyState() && Keyboard.getEventKey() == key.func_151463_i();
    }

    public static boolean isSortableContainer(GuiScreen screen) {
        return screen instanceof GuiContainer && BogoSortAPI.isValidSortable(((GuiContainer)screen).field_147002_h);
    }

    public static <T extends Container> T getSortableContainer(GuiScreen screen) {
        return (T)((GuiContainer)screen).field_147002_h;
    }

    @Nullable
    public static ISlot getSlot(GuiScreen guiScreen) {
        if (guiScreen instanceof GuiContainer) {
            return (ISlot)((GuiContainer)guiScreen).getSlotUnderMouse();
        }
        return null;
    }

    public static boolean sort(GuiScreen guiScreen, @Nullable ISlot slot) {
        if (guiScreen instanceof GuiContainer) {
            Container container = ((GuiContainer)guiScreen).field_147002_h;
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            if (sortingContext.isEmpty()) {
                return false;
            }
            SlotGroup slotGroup = null;
            if (slot == null) {
                if (sortingContext.getNonPlayerSlotGroupAmount() == 1) {
                    slotGroup = sortingContext.getNonPlayerSlotGroup();
                } else if (sortingContext.hasPlayer() && sortingContext.getNonPlayerSlotGroupAmount() == 0) {
                    slotGroup = sortingContext.getPlayerSlotGroup();
                }
                if (slotGroup == null || slotGroup.isEmpty()) {
                    return false;
                }
                slot = slotGroup.getSlots().get(0);
            } else {
                slotGroup = sortingContext.getSlotGroup(slot.bogo$getSlotNumber());
                if (slotGroup == null || slotGroup.isEmpty()) {
                    return false;
                }
            }
            List<SortRule<ItemStack>> sortRules = BogoSorterConfig.sortRules;
            boolean color = sortRules.contains(BogoSortAPI.INSTANCE.getItemSortRule("color"));
            boolean name = sortRules.contains(BogoSortAPI.INSTANCE.getItemSortRule("display_name"));
            NetworkHandler.sendToServer(new CSort(ClientEventHandler.createSortData(slotGroup, color, name), BogoSorterConfig.sortRules, BogoSorterConfig.nbtSortRules, slot.bogo$getSlotNumber(), slotGroup.isPlayerInventory()));
            SortHandler.playSortSound();
            return true;
        }
        return false;
    }

    public static Collection<ClientSortData> createSortData(SlotGroup slotGroup, boolean color, boolean name) {
        if (!color && !name) {
            return Collections.emptyList();
        }
        Object2ObjectOpenCustomHashMap map = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);
        for (ISlot slot1 : slotGroup.getSlots()) {
            map.computeIfAbsent(slot1.bogo$getStack(), stack -> ClientSortData.of(stack, color, name)).getSlotNumbers().add(slot1.bogo$getSlotNumber());
        }
        return map.values();
    }

    public static SortHandler createSortHandler(GuiScreen guiScreen, @Nullable ISlot slot) {
        if (slot != null && guiScreen instanceof GuiContainer) {
            Container container = ((GuiContainer)guiScreen).field_147002_h;
            boolean player = BogoSortAPI.isPlayerSlot(slot);
            if (!player && !ClientEventHandler.isSortableContainer(guiScreen)) {
                return null;
            }
            return new SortHandler((EntityPlayer)Minecraft.func_71410_x().field_71439_g, container, (Int2ObjectMap<ClientSortData>)Int2ObjectMaps.emptyMap());
        }
        return null;
    }
}

