/*
 * Decompiled with CFR 0.152.
 */
package com.wildbamaboy.crashtomainmenu.asm;

import com.wildbamaboy.crashtomainmenu.asm.LoadingPlugin;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    private static final String ASM_HOOKS = "com/wildbamaboy/crashtomainmenu/asm/ASMHooks";
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            ClassTransformer.log("Transforming " + transformedName);
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformMinecraft(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("run", "func_99999_d", "()V");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, ClassTransformer.combine(node -> node.getOpcode() == 25, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "onMinecraftRun", "()V", false));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transform(byte[] basicClass, TransformerAction ... methods) {
        ClassReader reader;
        try {
            reader = new ClassReader(basicClass);
        }
        catch (NullPointerException ex) {
            return basicClass;
        }
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (TransformerAction pair : methods) {
            didAnything |= pair.test(node);
        }
        if (didAnything) {
            SafeClassWriter writer = new SafeClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction predicate) {
        for (MethodNode method : node.methods) {
            if (!sig.matches(method)) continue;
            ClassTransformer.log("Located method, patching...");
            boolean finish = predicate.test(method);
            ClassTransformer.log("Patch result: " + finish);
            return finish;
        }
        ClassTransformer.log("Failed to locate the method!");
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return node -> ClassTransformer.applyOnNode(node, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            ClassTransformer.log("Located patch target node " + ClassTransformer.getNodeString(anode));
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    private static void log(String str) {
        LogManager.getLogger((String)"CrashToMainMenu").info(str);
    }

    private static String getNodeString(ClassNode node) {
        StringWriter sw = new StringWriter();
        PrintWriter printer = new PrintWriter(sw);
        TraceClassVisitor visitor = new TraceClassVisitor(printer);
        node.accept((ClassVisitor)visitor);
        return sw.toString();
    }

    private static String getNodeString(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    private static boolean hasOptifine(String msg) {
        try {
            if (Class.forName("optifine.OptiFineTweaker") != null) {
                ClassTransformer.log("Optifine Detected. Disabling Patch for " + msg);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static TransformerAction forMethod(MethodSignature sig, MethodAction ... actions) {
        return new MethodTransformerAction(sig, actions);
    }

    private static TransformerAction inject(MethodSignature sig, NewMethodAction ... actions) {
        return new MethodInjectorAction(sig, actions);
    }

    static {
        transformers.put("net.minecraft.client.Minecraft", ClassTransformer::transformMinecraft);
        ClassTransformer.log("Base transform code adapted from https://github.com/Vazkii/Quark/blob/master/src/main/java/vazkii/quark/base/asm/LoadingPlugin.java");
    }

    private static class MethodInjectorAction
    implements TransformerAction {
        private final MethodSignature sig;
        private final NewMethodAction[] actions;

        public MethodInjectorAction(MethodSignature sig, NewMethodAction[] actions) {
            this.sig = sig;
            this.actions = actions;
        }

        @Override
        public boolean test(ClassNode classNode) {
            ClassTransformer.log("Injecting method (" + this.sig + ")");
            MethodVisitor method = classNode.visitMethod(1, LoadingPlugin.runtimeDeobfEnabled ? this.sig.srgName : this.sig.funcName, this.sig.funcDesc, null, null);
            for (NewMethodAction action : this.actions) {
                boolean finish = action.test(method);
                ClassTransformer.log("Patch result: " + finish);
            }
            return true;
        }
    }

    private static class MethodTransformerAction
    implements TransformerAction {
        private final MethodSignature sig;
        private final MethodAction[] actions;

        public MethodTransformerAction(MethodSignature sig, MethodAction[] actions) {
            this.sig = sig;
            this.actions = actions;
        }

        @Override
        public boolean test(ClassNode classNode) {
            boolean didAnything = false;
            ClassTransformer.log("Applying Transformation to method (" + this.sig + ")");
            for (MethodAction action : this.actions) {
                didAnything |= ClassTransformer.findMethodAndTransform(classNode, this.sig, action);
            }
            return didAnything;
        }
    }

    private static interface NewMethodAction
    extends Predicate<MethodVisitor> {
    }

    private static interface TransformerAction
    extends Predicate<ClassNode> {
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static interface Transformer
    extends Function<byte[], byte[]> {
    }

    public static class SafeClassWriter
    extends ClassWriter {
        public SafeClassWriter(int flags) {
            super(flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            LaunchClassLoader classLoader = Launch.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, (ClassLoader)classLoader);
                d = Class.forName(type2.replace('/', '.'), false, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }

    public static class MethodSignature {
        private final String funcName;
        private final String srgName;
        private final String funcDesc;

        public MethodSignature(String funcName, String srgName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.funcDesc = funcDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + "] Descriptor " + this.funcDesc;
        }

        public boolean matches(String methodName, String methodDesc) {
            return (methodName.equals(this.funcName) || methodName.equals(this.srgName)) && methodDesc.equals(this.funcDesc);
        }

        public boolean matches(MethodNode method) {
            return this.matches(method.name, method.desc);
        }

        public boolean matches(MethodInsnNode method) {
            return this.matches(method.name, method.desc);
        }

        public String mappedName(String owner) {
            return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(owner, this.srgName, this.funcDesc);
        }
    }
}

